/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.item.armor.ItemDragonArmor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DragonArmorMaterial {
    private static final List<DragonArmorMaterial> MATERIALS = new ArrayList<DragonArmorMaterial>();
    public static final DragonArmorMaterial IRON = new DragonArmorMaterial("iron");
    public static final DragonArmorMaterial COPPER = new DragonArmorMaterial("copper");
    public static final DragonArmorMaterial SILVER = new DragonArmorMaterial("silver");
    public static final DragonArmorMaterial GOLD = new DragonArmorMaterial("gold");
    public static final DragonArmorMaterial DIAMOND = new DragonArmorMaterial("diamond");
    public static final DragonArmorMaterial NETHERITE = new DragonArmorMaterial("netherite");
    public static final DragonArmorMaterial DRAGON_STEEL_FIRE = new DragonArmorMaterial("dragon_steel_fire");
    public static final DragonArmorMaterial DRAGON_STEEL_ICE = new DragonArmorMaterial("dragon_steel_ice");
    public static final DragonArmorMaterial DRAGON_STEEL_LIGHTNING = new DragonArmorMaterial("dragon_steel_lightning");
    private final String name;

    public DragonArmorMaterial(String name) {
        this.name = name;
        MATERIALS.add(this);
    }

    public static ResourceLocation getArmorTexture(ItemStack stack, EquipmentSlot slot) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ItemDragonArmor) {
            ItemDragonArmor armorItem = (ItemDragonArmor)item;
            return armorItem.type.getTexture(slot);
        }
        return ResourceLocation.m_214293_((String)"minecraft", (String)"missing");
    }

    public static List<DragonArmorMaterial> values() {
        return ImmutableList.copyOf(MATERIALS);
    }

    public String getId() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    public ResourceLocation getTexture(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND -> null;
            case EquipmentSlot.FEET -> ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/dragon_armor/armor_tail_" + this.name + ".png"));
            case EquipmentSlot.LEGS -> ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/dragon_armor/armor_body_" + this.name + ".png"));
            case EquipmentSlot.CHEST -> ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/dragon_armor/armor_neck_" + this.name + ".png"));
            case EquipmentSlot.HEAD -> ResourceLocation.m_214293_((String)"iceandfire", (String)("textures/models/dragon_armor/armor_head_" + this.name + ".png"));
        };
    }
}

