/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.compat.emi;

import com.iafenvoy.iceandfire.recipe.DragonForgeRecipe;
import com.iafenvoy.iceandfire.registry.IafRecipes;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class ForgeRecipeHolder {
    private final String dragonType;
    private final EmiTexture texture;
    private final EmiStack workstation;
    private final EmiRecipeCategory category;

    public ForgeRecipeHolder(ResourceLocation id, String dragonType, EmiTexture texture, EmiStack workstation) {
        this.dragonType = dragonType;
        this.texture = texture;
        this.workstation = workstation;
        this.category = new EmiRecipeCategory(id, (EmiRenderable)workstation, (EmiRenderable)texture);
    }

    public void register(EmiRegistry registry) {
        registry.addCategory(this.category);
        registry.addWorkstation(this.category, (EmiIngredient)this.workstation);
        List forgeRecipeList = registry.getRecipeManager().m_44013_((RecipeType)IafRecipes.DRAGON_FORGE_TYPE.get());
        for (DragonForgeRecipe recipe : forgeRecipeList.stream().filter(item -> item.getDragonType().equals(this.dragonType)).toList()) {
            registry.addRecipe((EmiRecipe)new DragonForgeEmiRecipe(recipe, this.category));
        }
    }

    public class DragonForgeEmiRecipe
    implements EmiRecipe {
        private final DragonForgeRecipe recipe;
        private final EmiRecipeCategory category;

        public DragonForgeEmiRecipe(DragonForgeRecipe recipe, EmiRecipeCategory category) {
            this.recipe = recipe;
            this.category = category;
        }

        public EmiRecipeCategory getCategory() {
            return this.category;
        }

        @Nullable
        public ResourceLocation getId() {
            return this.recipe.m_6423_();
        }

        public List<EmiIngredient> getInputs() {
            return List.of(EmiIngredient.of((Ingredient)this.recipe.getInput()), EmiIngredient.of((Ingredient)this.recipe.getBlood()));
        }

        public List<EmiStack> getOutputs() {
            return List.of(EmiStack.of((ItemStack)this.recipe.m_8043_(null)));
        }

        public int getDisplayWidth() {
            return 176;
        }

        public int getDisplayHeight() {
            return 1120;
        }

        public void addWidgets(WidgetHolder widgets) {
            widgets.addTexture(ForgeRecipeHolder.this.texture, 3, 4);
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.getInput()), 67, 33);
            widgets.addSlot(EmiIngredient.of((Ingredient)this.recipe.getBlood()), 85, 33);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)this.recipe.m_8043_(null)), 143, 30).large(true).recipeContext((EmiRecipe)this);
        }
    }
}

