/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiSettings;
import xaeroplus.mixin.client.MixinGuiMapAccessor;
import xaeroplus.util.ChunkUtils;

public class GuiMapHelper {
    public static Optional<GuiMap> getGuiMap() {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof GuiMap) {
            return Optional.of((GuiMap)currentScreen);
        }
        if (currentScreen instanceof GuiSettings) {
            GuiSettings screen = (GuiSettings)currentScreen;
            Screen screen2 = screen.parent;
            if (screen2 instanceof GuiMap) {
                GuiMap map = (GuiMap)screen2;
                return Optional.of(map);
            }
            screen2 = screen.escape;
            if (screen2 instanceof GuiMap) {
                GuiMap map = (GuiMap)screen2;
                return Optional.of(map);
            }
        }
        return Optional.empty();
    }

    public static double getCameraX(GuiMap guiMap) {
        return ((MixinGuiMapAccessor)guiMap).getCameraX();
    }

    public static double getCameraZ(GuiMap guiMap) {
        return ((MixinGuiMapAccessor)guiMap).getCameraZ();
    }

    public static double getDestScale(GuiMap guiMap) {
        return ((MixinGuiMapAccessor)guiMap).getDestScale();
    }

    public static int getGuiMapRegionSize(GuiMap guiMap) {
        return (int)Math.max(5.0 / GuiMapHelper.getDestScale(guiMap), 3.0);
    }

    public static boolean isGuiMapLoaded() {
        return Minecraft.m_91087_().f_91080_ instanceof GuiMap;
    }

    public static int getGuiMapCenterRegionX(GuiMap guiMap) {
        return ChunkUtils.coordToRegionCoord(GuiMapHelper.getCameraX(guiMap));
    }

    public static int getGuiMapCenterRegionZ(GuiMap guiMap) {
        return ChunkUtils.coordToRegionCoord(GuiMapHelper.getCameraZ(guiMap));
    }
}

