/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.XaeroPlusSetting;
import xaeroplus.settings.XaeroPlusSettingsReflectionHax;

public class XaeroPlusBooleanSetting
extends XaeroPlusSetting {
    private boolean value;
    private Consumer<Boolean> settingChangeConsumer;

    private XaeroPlusBooleanSetting(String settingName, String settingNameTranslationKey, boolean value, String tooltipTranslationKey, Supplier<Boolean> visibilitySupplier, Consumer<Boolean> settingChangeConsumer, KeyMapping keyBinding) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, keyBinding, visibilitySupplier);
        this.value = value;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static XaeroPlusBooleanSetting create(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, boolean defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusBooleanSetting setting = new XaeroPlusBooleanSetting("[XP] " + settingName, settingNameTranslationKey, defaultValue, tooltipTranslationKey, null, null, new KeyMapping(settingNameTranslationKey, -1, "XaeroPlus"));
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public static XaeroPlusBooleanSetting create(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, Consumer<Boolean> settingChangeConsumer, boolean defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusBooleanSetting setting = new XaeroPlusBooleanSetting("[XP] " + settingName, settingNameTranslationKey, defaultValue, tooltipTranslationKey, null, settingChangeConsumer, new KeyMapping(settingNameTranslationKey, -1, "XaeroPlus"));
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public static XaeroPlusBooleanSetting create(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, Supplier<Boolean> visibilitySupplier, boolean defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusBooleanSetting setting = new XaeroPlusBooleanSetting("[XP] " + settingName, settingNameTranslationKey, defaultValue, tooltipTranslationKey, visibilitySupplier, null, new KeyMapping(settingNameTranslationKey, -1, "XaeroPlus"));
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public static XaeroPlusBooleanSetting create(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, Supplier<Boolean> visibilitySupplier, Consumer<Boolean> settingChangeConsumer, boolean defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusBooleanSetting setting = new XaeroPlusBooleanSetting("[XP] " + settingName, settingNameTranslationKey, defaultValue, tooltipTranslationKey, visibilitySupplier, settingChangeConsumer, new KeyMapping(settingNameTranslationKey, -1, "XaeroPlus"));
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(value);
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.warn("Error applying setting change consumer for {}", (Object)this.getSettingName(), (Object)e);
            }
        }
    }

    public Consumer<Boolean> getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public void setSettingChangeConsumer(Consumer<Boolean> settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(this.value);
        }
    }
}

