/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.concurrent.TimeUnit;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundSectionBlocksUpdatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.PacketReceivedEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightLocalCache;
import xaeroplus.feature.render.highlights.ChunkHighlightSavingCache;
import xaeroplus.mixin.client.mc.AccessorWorldRenderer;
import xaeroplus.module.Module;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.ChunkUtils;

@Module.ModuleInfo
public class NewChunks
extends Module {
    private ChunkHighlightCache newChunksCache = new ChunkHighlightLocalCache();
    private final Cache<Long, Byte> oldChunksCache = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private int newChunksColor = ColorHelper.getColor(255, 0, 0, 100);
    private final Minecraft mc = Minecraft.m_91087_();
    private static final Direction[] searchDirs = new Direction[]{Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.UP};
    private static final String DATABASE_NAME = "XaeroPlusNewChunks";

    public void setNewChunksCache(boolean disk) {
        try {
            Long2LongMap map = this.newChunksCache.getHighlightsState();
            this.newChunksCache.onDisable();
            this.newChunksCache = disk ? new ChunkHighlightSavingCache(DATABASE_NAME) : new ChunkHighlightLocalCache();
            if (this.isEnabled()) {
                this.newChunksCache.onEnable();
                if (map != null) {
                    this.newChunksCache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error closing new chunks cache", (Throwable)e);
        }
    }

    @EventHandler
    public void onPacketReceivedEvent(PacketReceivedEvent event) {
        block10: {
            ChunkPos chunkPos;
            block11: {
                Packet<?> packet;
                block9: {
                    if (this.mc.f_91073_ == null || ((AccessorWorldRenderer)this.mc.f_91060_).getChunks() == null) {
                        return;
                    }
                    packet = event.packet();
                    if (!(packet instanceof ClientboundSectionBlocksUpdatePacket)) break block9;
                    ClientboundSectionBlocksUpdatePacket packet2 = (ClientboundSectionBlocksUpdatePacket)packet;
                    packet2.m_132992_((pos, state) -> {
                        if (!state.m_60819_().m_76178_() && !state.m_60819_().m_76170_()) {
                            ChunkPos chunkPos = new ChunkPos(pos);
                            for (Direction dir : searchDirs) {
                                if (!this.mc.f_91073_.m_8055_(pos.m_121945_(dir)).m_60819_().m_76170_() || this.oldChunksCache.getIfPresent((Object)ChunkUtils.chunkPosToLong(chunkPos)) != null) continue;
                                this.newChunksCache.addHighlight(chunkPos.f_45578_, chunkPos.f_45579_);
                                return;
                            }
                        }
                    });
                    break block10;
                }
                packet = event.packet();
                if (!(packet instanceof ClientboundBlockUpdatePacket)) break block11;
                ClientboundBlockUpdatePacket packet3 = (ClientboundBlockUpdatePacket)packet;
                if (packet3.m_131746_().m_60819_().m_76178_() || packet3.m_131746_().m_60819_().m_76170_()) break block10;
                chunkPos = new ChunkPos(packet3.m_131749_());
                for (Direction dir : searchDirs) {
                    if (!this.mc.f_91073_.m_8055_(packet3.m_131749_().m_121945_(dir)).m_60819_().m_76170_() || this.oldChunksCache.getIfPresent((Object)ChunkUtils.chunkPosToLong(chunkPos)) != null) continue;
                    this.newChunksCache.addHighlight(chunkPos.f_45578_, chunkPos.f_45579_);
                    return;
                }
                break block10;
            }
            chunkPos = event.packet();
            if (chunkPos instanceof ClientboundLevelChunkWithLightPacket) {
                ClientboundLevelChunkWithLightPacket packet = (ClientboundLevelChunkWithLightPacket)chunkPos;
                ChunkPos pos2 = new ChunkPos(packet.m_195717_(), packet.m_195718_());
                if (!this.newChunksCache.isHighlighted(pos2.f_45578_, pos2.f_45579_, ChunkUtils.getActualDimension()) && this.mc.f_91073_.m_7726_().m_6196_(packet.m_195717_(), packet.m_195718_()) == null) {
                    LevelChunk chunk = new LevelChunk((Level)this.mc.f_91073_, pos2);
                    try {
                        chunk.m_187971_(packet.m_195719_().m_195656_(), new CompoundTag(), packet.m_195719_().m_195657_(packet.m_195717_(), packet.m_195718_()));
                    }
                    catch (Throwable e) {
                        return;
                    }
                    for (int x = 0; x < 16; ++x) {
                        for (int y = this.mc.f_91073_.m_141937_(); y < this.mc.f_91073_.m_151558_(); ++y) {
                            for (int z = 0; z < 16; ++z) {
                                FluidState fluid = chunk.m_62814_(x, y, z);
                                if (fluid.m_76178_() || fluid.m_76170_()) continue;
                                this.oldChunksCache.put((Object)ChunkUtils.chunkPosToLong(pos2), (Object)0);
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (XaeroPlusSettingRegistry.newChunksSaveLoadToDisk.getValue() && this.inUnknownDimension() && this.newChunksCache instanceof ChunkHighlightSavingCache) {
            XaeroPlusSettingRegistry.newChunksSaveLoadToDisk.setValue(false);
            XaeroPlus.LOGGER.warn("Entered unknown dimension with saving cache on, disabling disk saving");
        }
        this.newChunksCache.handleWorldChange();
    }

    public boolean inUnknownDimension() {
        ResourceKey<Level> dim = ChunkUtils.getActualDimension();
        return dim != Level.f_46428_ && dim != Level.f_46429_ && dim != Level.f_46430_;
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        this.newChunksCache.handleTick();
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), new ChunkHighlightProvider(this::isNewChunk, this::getNewChunksColor));
        this.newChunksCache.onEnable();
    }

    @Override
    public void onDisable() {
        this.newChunksCache.onDisable();
        Globals.drawManager.unregister(this.getClass());
    }

    public int getNewChunksColor() {
        return this.newChunksColor;
    }

    public void setRgbColor(int color) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(color, (int)XaeroPlusSettingRegistry.newChunksAlphaSetting.getValue());
    }

    public void setAlpha(float a) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(this.newChunksColor, (int)a);
    }

    public boolean isNewChunk(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        return this.newChunksCache.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }
}

