/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalXZ;
import baritone.api.utils.interfaces.IGoalRenderPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.OptimizedMath;
import xaero.map.mods.SupportMods;
import xaeroplus.Globals;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.feature.extensions.IWaypointDimension;
import xaeroplus.module.Module;
import xaeroplus.util.BaritoneGoalHelper;
import xaeroplus.util.BaritoneHelper;
import xaeroplus.util.ChunkUtils;

@Module.ModuleInfo
public class BaritoneGoalSync
extends Module {
    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        if (!BaritoneHelper.isBaritonePresent()) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointSet waypointSet = waypointsManager.getWaypoints();
        if (waypointSet == null) {
            return;
        }
        WaypointWorld waypointWorld = waypointsManager.getCurrentWorld();
        if (waypointWorld == null) {
            return;
        }
        ArrayList waypoints = waypointSet.getList();
        Optional<Waypoint> baritoneGoalWaypoint = waypoints.stream().filter(waypoint -> waypoint.getName().equals("Baritone Goal")).findFirst();
        Goal goal = BaritoneGoalHelper.getBaritoneGoal();
        if (goal == null) {
            baritoneGoalWaypoint.ifPresent(waypoint -> this.removeBaritoneGoalWaypoint(waypoints, (Waypoint)waypoint));
            return;
        }
        BlockPos baritoneGoalBlockPos = this.getBaritoneGoalBlockPos(goal);
        if (baritoneGoalBlockPos == null) {
            baritoneGoalWaypoint.ifPresent(waypoint -> this.removeBaritoneGoalWaypoint(waypoints, (Waypoint)waypoint));
            return;
        }
        double dimDiv = waypointsManager.getDimensionDivision(waypointWorld);
        int x = OptimizedMath.myFloor((double)((double)baritoneGoalBlockPos.m_123341_() * dimDiv));
        int z = OptimizedMath.myFloor((double)((double)baritoneGoalBlockPos.m_123343_() * dimDiv));
        if (baritoneGoalWaypoint.isPresent()) {
            Waypoint waypoint2 = baritoneGoalWaypoint.get();
            ResourceKey<Level> customDim = Globals.getCurrentDimensionId();
            ResourceKey<Level> actualDim = ChunkUtils.getActualDimension();
            double customDimDiv = 1.0;
            if (customDim != actualDim) {
                if (customDim == Level.f_46429_ && actualDim == Level.f_46428_) {
                    customDimDiv = 0.125;
                } else if (customDim == Level.f_46428_ && actualDim == Level.f_46429_) {
                    customDimDiv = 8.0;
                }
            }
            int expectedX = (int)((double)x * customDimDiv);
            int expectedZ = (int)((double)z * customDimDiv);
            if (waypoint2.getX() != expectedX || waypoint2.getY() != baritoneGoalBlockPos.m_123342_() || waypoint2.getZ() != expectedZ) {
                waypoint2.setX(expectedX);
                waypoint2.setY(baritoneGoalBlockPos.m_123342_());
                waypoint2.setZ(expectedZ);
                SupportMods.xaeroMinimap.requestWaypointsRefresh();
            }
        } else {
            Waypoint waypoint3 = new Waypoint(x, baritoneGoalBlockPos.m_123342_(), z, "Baritone Goal", "B", 10, 0, true);
            ((IWaypointDimension)waypoint3).setDimension((ResourceKey<Level>)waypointWorld.getDimId());
            waypoints.add(waypoint3);
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
        }
    }

    private void removeBaritoneGoalWaypoint(List<Waypoint> waypoints, Waypoint waypoint) {
        if (waypoints.remove(waypoint)) {
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
        }
    }

    private BlockPos getBaritoneGoalBlockPos(Goal goal) {
        if (goal instanceof GoalXZ) {
            return new BlockPos(((GoalXZ)goal).getX(), 64, ((GoalXZ)goal).getZ());
        }
        if (goal instanceof IGoalRenderPos) {
            return ((IGoalRenderPos)goal).getGoalPos();
        }
        return null;
    }
}

