/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaeroplus.Globals;
import xaeroplus.feature.extensions.IWaypointDimension;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.DataFolderResolveUtil;

@Mixin(value={WaypointsManager.class}, remap=false)
public abstract class MixinWaypointsManager {
    @Shadow
    private Minecraft mc;
    @Shadow
    private String mainContainerID;
    @Shadow
    private String containerIDIgnoreCaseCache;
    Waypoint selected = null;
    WaypointWorld displayedWorld = null;

    @Shadow
    public abstract String ignoreContainerCase(String var1, String var2);

    @Shadow
    public abstract String getDimensionDirectoryName(ResourceKey<Level> var1);

    @Inject(method={"getMainContainer"}, at={@At(value="HEAD")}, cancellable=true)
    private void getMainContainer(boolean preIp6Fix, ClientPacketListener connection, CallbackInfoReturnable<String> cir) {
        DataFolderResolveUtil.resolveDataFolder(connection, cir);
    }

    @Inject(method={"teleportToWaypoint(Lxaero/common/minimap/waypoints/Waypoint;Lxaero/common/minimap/waypoints/WaypointWorld;Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="HEAD")}, remap=false)
    public void teleportToWaypointHead(Waypoint selected, WaypointWorld displayedWorld, Screen screen, boolean respectHiddenCoords, CallbackInfo ci) {
        this.selected = selected;
        this.displayedWorld = displayedWorld;
    }

    @Redirect(method={"teleportToWaypoint(Lxaero/common/minimap/waypoints/Waypoint;Lxaero/common/minimap/waypoints/WaypointWorld;Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at=@At(value="INVOKE", target="Lxaero/common/minimap/waypoints/WaypointsManager;getAutoWorld()Lxaero/common/minimap/waypoints/WaypointWorld;"), remap=false)
    public WaypointWorld getAutoWorldRedirect(WaypointsManager instance) {
        if (!XaeroPlusSettingRegistry.owAutoWaypointDimension.getValue()) {
            return instance.getAutoWorld();
        }
        ResourceKey<Level> waypointDimension = ((IWaypointDimension)this.selected).getDimension();
        if (waypointDimension != Globals.getCurrentDimensionId()) {
            return null;
        }
        return instance.getAutoWorld();
    }

    @Inject(method={"getPotentialContainerID"}, at={@At(value="HEAD")}, cancellable=true)
    private void getPotentialContainerID(CallbackInfoReturnable<String> cir) {
        if (!XaeroPlusSettingRegistry.owAutoWaypointDimension.getValue()) {
            return;
        }
        ResourceKey dimension = this.mc.f_91073_.m_46472_();
        if (dimension == Level.f_46428_ || dimension == Level.f_46429_) {
            dimension = Level.f_46428_;
        }
        cir.setReturnValue((Object)this.ignoreContainerCase(this.mainContainerID + "/" + this.getDimensionDirectoryName((ResourceKey<Level>)dimension), this.containerIDIgnoreCaseCache));
    }

    @Inject(method={"createTemporaryWaypoints(Lxaero/common/minimap/waypoints/WaypointWorld;IIIZD)V"}, at={@At(value="INVOKE", target="Lxaero/common/IXaeroMinimap;getSettings()Lxaero/common/settings/ModSettings;", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void createTempWaypointInject(WaypointWorld wpw, int x, int y, int z, boolean yIncluded, double dimScale, CallbackInfo ci, double waypointDestDimScale, double dimDiv, Waypoint waypoint) {
        ((IWaypointDimension)waypoint).setDimension((ResourceKey<Level>)wpw.getDimId());
    }
}

