/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.util.DataFolderResolveUtil;

@Mixin(value={MapProcessor.class}, remap=false)
public abstract class MixinMapProcessor {
    @Shadow
    private String currentWorldId;
    @Shadow
    private String currentDimId;
    @Shadow
    private String currentMWId;

    @Inject(method={"getMainId"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getMainId(boolean rootFolderFormat, boolean preIP6Fix, ClientPacketListener connection, CallbackInfoReturnable<String> cir) {
        DataFolderResolveUtil.resolveDataFolder(connection, cir);
    }

    @Inject(method={"getDimensionName"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void getDimensionName(ResourceKey<Level> id, CallbackInfoReturnable<String> cir) {
        if (!Globals.nullOverworldDimensionFolder && id == Level.f_46428_) {
            cir.setReturnValue((Object)"DIM0");
        }
    }

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Ljava/lang/Thread;sleep(J)V"))
    public void decreaseThreadSleepTime(long millis) throws InterruptedException {
        Thread.sleep(5L);
    }

    @Redirect(method={"updateWorldSynced"}, at=@At(value="INVOKE", target="Ljava/nio/file/Path;resolve(Ljava/lang/String;)Ljava/nio/file/Path;"))
    public Path replaceLockPath(Path instance, String other) {
        return Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(Globals.LOCK_ID + ".lock");
    }

    @Inject(method={"updateWorldSynced"}, at={@At(value="INVOKE", target="Lxaero/map/MapProcessor;popRenderPause(ZZ)V", ordinal=0)})
    public void fireWorldChangedEvent(CallbackInfo ci) {
        XaeroPlus.EVENT_BUS.call((Object)new XaeroWorldChangeEvent(this.currentWorldId, this.currentDimId, this.currentMWId));
    }
}

