/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Optional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import xaero.common.gui.ConfigSettingEntry;
import xaero.common.gui.GuiSettings;
import xaero.common.gui.ISettingEntry;
import xaero.common.misc.KeySortableByOther;
import xaero.common.settings.ModOptions;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.XaeroPlusSetting;
import xaeroplus.settings.XaeroPlusSettingsReflectionHax;

@Mixin(value={GuiSettings.class}, remap=false)
public class MixinCommonGuiSettings {
    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Ljava/util/ArrayList;add(Ljava/lang/Object;)Z"), remap=true)
    public boolean settingListToRenderRedirect(ArrayList instance, Object entryObject) {
        KeySortableByOther entry = (KeySortableByOther)entryObject;
        ISettingEntry settingEntry = (ISettingEntry)entry.getKey();
        if (settingEntry instanceof ConfigSettingEntry) {
            try {
                Field option = ConfigSettingEntry.class.getDeclaredField("option");
                option.setAccessible(true);
                ModOptions modOptions = (ModOptions)option.get(settingEntry);
                String settingName = modOptions.getEnumString();
                Optional<XaeroPlusSetting> foundSetting = XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get().stream().filter(s -> s.getSettingName().equals(settingName)).findFirst();
                if (foundSetting.isPresent() && !foundSetting.get().isVisible()) {
                    return false;
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.warn("Failed to edit settings gui", (Throwable)e);
            }
        }
        instance.add(entryObject);
        return false;
    }
}

