/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.util.ChunkUtils;

public abstract class ChunkHighlightBaseCacheHandler
implements ChunkHighlightCache {
    public final ReadWriteLock lock = new StampedLock().asReadWriteLock();
    public final Long2LongMap chunks = new Long2LongOpenHashMap();

    @Override
    public boolean addHighlight(int x, int z) {
        return this.addHighlight(x, z, System.currentTimeMillis());
    }

    public boolean addHighlight(int x, int z, long foundTime) {
        long chunkPos = ChunkUtils.chunkPosToLong(x, z);
        try {
            if (this.lock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                this.chunks.put(chunkPos, foundTime);
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed to add new highlight", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean removeHighlight(int x, int z) {
        long chunkPos = ChunkUtils.chunkPosToLong(x, z);
        try {
            if (this.lock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                this.chunks.remove(chunkPos);
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed to add new highlight", (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean isHighlighted(int x, int z, ResourceKey<Level> dimensionId) {
        return this.isHighlighted(ChunkUtils.chunkPosToLong(x, z));
    }

    public boolean isHighlighted(long chunkPos) {
        try {
            if (this.lock.readLock().tryLock()) {
                boolean containsKey = this.chunks.containsKey(chunkPos);
                this.lock.readLock().unlock();
                return containsKey;
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error checking if chunk is highlighted", (Throwable)e);
        }
        return false;
    }

    public boolean isHighlightedWithWait(long chunkPos) {
        try {
            if (this.lock.readLock().tryLock(1L, TimeUnit.SECONDS)) {
                boolean containsKey = this.chunks.containsKey(chunkPos);
                this.lock.readLock().unlock();
                return containsKey;
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error checking if chunk is highlighted", (Throwable)e);
        }
        return false;
    }

    @Override
    public Long2LongMap getHighlightsState() {
        return this.chunks;
    }

    @Override
    public void loadPreviousState(Long2LongMap state) {
        if (state == null) {
            return;
        }
        try {
            if (this.lock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                this.chunks.putAll((Map)state);
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error loading previous state", (Throwable)e);
        }
    }

    public void replaceState(Long2LongOpenHashMap state) {
        try {
            if (this.lock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                this.chunks.clear();
                this.chunks.putAll((Map)state);
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed replacing cache state", (Throwable)e);
        }
    }

    public void reset() {
        try {
            if (this.lock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                this.chunks.clear();
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed resetting cache", (Throwable)e);
        }
    }
}

