/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;

public class Model {
    VertexBuffer toDraw;

    public Model(Vector3f[] modelData, Vector2f[] uvData) {
        BufferBuilder bufferbuilder = new BufferBuilder(modelData.length);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (int i = 0; i < modelData.length; ++i) {
            Vector3f pos = modelData[i];
            Vector2f uv = uvData[i];
            bufferbuilder.m_5483_((double)pos.x(), (double)pos.y(), (double)pos.z()).m_7421_(uv.x(), uv.y()).m_5752_();
        }
        this.toDraw = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.upload(bufferbuilder.m_231175_());
    }

    public void drawWithShader(Matrix4f matrix4f, Matrix4f matrix4f2, ShaderInstance shaderInstance) {
        this.toDraw.m_85921_();
        this.toDraw.m_253207_(matrix4f, matrix4f2, shaderInstance);
    }

    public void draw(Matrix4f matrix4f) {
        this.drawWithShader(matrix4f, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
    }

    private void upload(BufferBuilder.RenderedBuffer renderedBuffer) {
        RenderSystem.assertOnRenderThread();
        if (renderedBuffer.m_231199_()) {
            renderedBuffer.m_231200_();
        } else {
            this.toDraw.m_85921_();
            this.toDraw.m_231221_(renderedBuffer);
        }
    }

    public void close() {
        this.toDraw.close();
    }
}

