/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.buffered;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Vector2f;
import org.joml.Vector3f;
import xaeroplus.feature.render.buffered.Model;
import xaeroplus.module.impl.FpsLimiter;

public class BufferedComponent {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static Model model = null;
    private final RenderTarget renderTarget = new TextureTarget(100, 100, true, false);
    private long fpsTimer = System.currentTimeMillis();
    private int guiScale = 0;
    private boolean isRendering = false;
    private final Supplier<Integer> fpsLimitSupplier;

    public BufferedComponent(Supplier<Integer> fpsLimitSupplier) {
        this.fpsLimitSupplier = fpsLimitSupplier;
    }

    private static void refreshModel(int screenWidth, int screenHeight) {
        if (model != null) {
            model.close();
        }
        Vector3f[] modelData = new Vector3f[]{new Vector3f(0.0f, (float)screenHeight, -90.0f), new Vector3f((float)screenWidth, (float)screenHeight, -90.0f), new Vector3f((float)screenWidth, 0.0f, -90.0f), new Vector3f(0.0f, 0.0f, -90.0f)};
        Vector2f[] uvData = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f), new Vector2f(0.0f, 1.0f)};
        model = new Model(modelData, uvData);
    }

    public boolean render() {
        boolean updateFrame;
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        boolean forceRender = false;
        if (this.renderTarget.f_83915_ != minecraft.m_91268_().m_85441_() || this.renderTarget.f_83916_ != minecraft.m_91268_().m_85442_() || (Integer)BufferedComponent.minecraft.f_91066_.m_231928_().m_231551_() != this.guiScale) {
            this.renderTarget.m_83941_(minecraft.m_91268_().m_85441_(), minecraft.m_91268_().m_85442_(), true);
            BufferedComponent.refreshModel(screenWidth, screenHeight);
            this.guiScale = (Integer)BufferedComponent.minecraft.f_91066_.m_231928_().m_231551_();
            forceRender = true;
        }
        if (model == null) {
            BufferedComponent.refreshModel(screenWidth, screenHeight);
        }
        boolean bl = updateFrame = forceRender || System.currentTimeMillis() > this.fpsTimer;
        if (!updateFrame) {
            this.renderTextureOverlay(this.renderTarget.m_83975_());
            return true;
        }
        this.renderTarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
        this.renderTarget.m_83954_(false);
        this.renderTarget.m_83947_(false);
        this.isRendering = true;
        FpsLimiter.renderTargetOverwrite = this.renderTarget;
        BufferedComponent.applyBlend();
        this.renderTarget.m_83947_(false);
        return false;
    }

    public void postRender() {
        if (!this.isRendering) {
            return;
        }
        FpsLimiter.renderTargetOverwrite = null;
        this.renderTarget.m_83970_();
        Minecraft.m_91087_().m_91385_().m_83947_(true);
        this.fpsTimer = System.currentTimeMillis() + (long)(1000 / this.fpsLimitSupplier.get());
        this.isRendering = false;
        this.renderTextureOverlay(this.renderTarget.m_83975_());
    }

    private void renderTextureOverlay(int textureid) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (int)textureid);
        model.draw(RenderSystem.getModelViewMatrix());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void applyBlend() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }
}

