/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaeroplus.Globals;
import xaeroplus.feature.render.ChunkHighlightPredicate;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.DrawFeature;
import xaeroplus.feature.render.MinimapBackgroundDrawHelper;
import xaeroplus.util.ChunkUtils;

public class DrawManager {
    private final Reference2ObjectMap<Class<?>, DrawFeature> chunkHighlightDrawFeatures = new Reference2ObjectOpenHashMap();

    public synchronized void registerChunkHighlightProvider(Class<?> clazz, ChunkHighlightProvider feature) {
        this.chunkHighlightDrawFeatures.put(clazz, (Object)new DrawFeature(feature, this.createChunkHighlightRenderCache(feature)));
    }

    public synchronized void unregister(Class<?> clazz) {
        this.chunkHighlightDrawFeatures.remove(clazz);
    }

    private AsyncLoadingCache<Long, LongList> createChunkHighlightRenderCache(ChunkHighlightProvider chunkHighlightProvider) {
        return Caffeine.newBuilder().expireAfterWrite(3000L, TimeUnit.MILLISECONDS).refreshAfterWrite(500L, TimeUnit.MILLISECONDS).executor((Executor)Globals.cacheRefreshExecutorService.get()).buildAsync(regionLong -> this.loadHighlightChunksInRegion((long)regionLong, chunkHighlightProvider.chunkHighlightPredicate()));
    }

    private LongList loadHighlightChunksInRegion(long regionLong, ChunkHighlightPredicate highlightPredicate) {
        LongArrayList list = new LongArrayList(8);
        int regionX = ChunkUtils.longToChunkX(regionLong);
        int regionZ = ChunkUtils.longToChunkZ(regionLong);
        for (int cx = 0; cx < 8; ++cx) {
            for (int cz = 0; cz < 8; ++cz) {
                int mapTileChunkX = (regionX << 3) + cx;
                int mapTileChunkZ = (regionZ << 3) + cz;
                for (int t = 0; t < 16; ++t) {
                    int chunkPosX = (mapTileChunkX << 2) + t % 4;
                    int chunkPosZ = (mapTileChunkZ << 2) + (t >> 2);
                    if (!highlightPredicate.isHighlighted(chunkPosX, chunkPosZ, Globals.getCurrentDimensionId())) continue;
                    list.add(ChunkUtils.chunkPosToLong(chunkPosX, chunkPosZ));
                }
            }
        }
        return list;
    }

    public synchronized void drawMinimapFeatures(int minViewX, int maxViewX, int minViewZ, int maxViewZ, int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, PoseStack matrixStack, VertexConsumer overlayBufferBuilder, MinimapRendererHelper helper) {
        LongArraySet regions = new LongArraySet(4);
        for (int i = minViewX; i <= maxViewX; ++i) {
            for (int j = minViewZ; j <= maxViewZ; ++j) {
                int regX = i >> 3;
                int regZ = j >> 3;
                regions.add(ChunkUtils.chunkPosToLong(regX, regZ));
            }
        }
        long[] regionsArray = regions.toLongArray();
        for (DrawFeature feature : this.chunkHighlightDrawFeatures.values()) {
            this.drawMinimapChunkHighlights(feature, regionsArray, chunkX, chunkZ, tileX, tileZ, insideX, insideZ, matrixStack, overlayBufferBuilder, helper);
        }
    }

    public synchronized void drawWorldMapFeatures(int leafRegionX, int leafRegionZ, int level, int flooredCameraX, int flooredCameraZ, PoseStack matrixStack, VertexConsumer overlayBuffer) {
        int mx = leafRegionX + level;
        int mz = leafRegionZ + level;
        LongArraySet regions = new LongArraySet(1);
        for (int regX = leafRegionX; regX < mx; ++regX) {
            for (int regZ = leafRegionZ; regZ < mz; ++regZ) {
                regions.add(ChunkUtils.chunkPosToLong(regX, regZ));
            }
        }
        long[] regionsArray = regions.toLongArray();
        for (DrawFeature feature : this.chunkHighlightDrawFeatures.values()) {
            this.drawWorldMapChunkHighlights(feature, regionsArray, flooredCameraX, flooredCameraZ, matrixStack, overlayBuffer);
        }
    }

    private void drawMinimapChunkHighlights(DrawFeature feature, long[] regionsArray, int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, PoseStack matrixStack, VertexConsumer overlayBufferBuilder, MinimapRendererHelper helper) {
        int color = feature.chunkHighlightProvider().colorSupplier().get();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a == 0.0f) {
            return;
        }
        for (int r = 0; r < regionsArray.length; ++r) {
            long regionLong = regionsArray[r];
            int regionX = ChunkUtils.longToChunkX(regionLong);
            int regionZ = ChunkUtils.longToChunkZ(regionLong);
            int cx = regionX & 7;
            int cz = regionZ & 7;
            int drawX = (cx - chunkX << 6) - (tileX << 4) - insideX;
            int drawZ = (cz - chunkZ << 6) - (tileZ << 4) - insideZ;
            LongList highlights = feature.getChunkHighlights(regionLong);
            for (int i = 0; i < highlights.size(); ++i) {
                long chunkPosLong = highlights.getLong(i);
                int chunkPosX = ChunkUtils.longToChunkX(chunkPosLong);
                int chunkPosZ = ChunkUtils.longToChunkZ(chunkPosLong);
                int left = drawX + 16 * (chunkPosX - cx * 4);
                int top = drawZ + 16 * (chunkPosZ - cz * 4);
                helper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), overlayBufferBuilder, (float)left, (float)top, 16, 16, color);
            }
        }
    }

    private void drawWorldMapChunkHighlights(DrawFeature feature, long[] regionsArray, int flooredCameraX, int flooredCameraZ, PoseStack matrixStack, VertexConsumer overlayBuffer) {
        int color = feature.chunkHighlightProvider().colorSupplier().get();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a == 0.0f) {
            return;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        for (int reg = 0; reg < regionsArray.length; ++reg) {
            LongList highlights = feature.getChunkHighlights(regionsArray[reg]);
            for (int i = 0; i < highlights.size(); ++i) {
                int chunkX = ChunkUtils.longToChunkX(highlights.getLong(i));
                int chunkZ = ChunkUtils.longToChunkZ(highlights.getLong(i));
                float left = ChunkUtils.chunkCoordToCoord(chunkX) - flooredCameraX;
                float top = ChunkUtils.chunkCoordToCoord(chunkZ) - flooredCameraZ;
                float right = left + 16.0f;
                float bottom = top + 16.0f;
                MinimapBackgroundDrawHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_252922_(), overlayBuffer, left, top, right, bottom, r, g, b, a);
            }
        }
    }
}

