/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.zip.ZipInputStream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.world.MapWorld;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.DrawManager;
import xaeroplus.settings.XaeroPlusSetting;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.settings.XaeroPlusSettingsReflectionHax;

public class Globals {
    public static boolean FOLLOW = false;
    public static boolean nullOverworldDimensionFolder = false;
    public static XaeroPlusSettingRegistry.DataFolderResolutionMode dataFolderResolutionMode = XaeroPlusSettingRegistry.DataFolderResolutionMode.IP;
    public static int minimapScalingFactor = 1;
    public static boolean shouldResetFBO = false;
    public static String LOCK_ID = UUID.randomUUID().toString();
    public static GuiGraphics minimapDrawContext = null;
    public static String waypointsSearchFilter = "";
    public static List<Button> guiMapButtonTempList = Lists.newArrayList();
    public static ByteArrayOutputStream zipFastByteBuffer = new ByteArrayOutputStream();
    public static Supplier<ExecutorService> cacheRefreshExecutorService = Suppliers.memoize(() -> Executors.newFixedThreadPool(Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() / 2, 4)), new ThreadFactoryBuilder().setNameFormat("XaeroPlus-Cache-Refresh-%d").setDaemon(true).build()));
    public static final ResourceLocation xpGuiTextures = new ResourceLocation("xaeroplus", "gui/xpgui.png");
    public static DrawManager drawManager = new DrawManager();

    public static ResourceKey<Level> getCurrentDimensionId() {
        try {
            ResourceKey dim = XaeroWorldMapCore.currentSession.getMapProcessor().getMapWorld().getCurrentDimensionId();
            if (dim == null) {
                return Level.f_46428_;
            }
            return dim;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed getting current dimension id", (Throwable)e);
            return Level.f_46428_;
        }
    }

    public static void onAllSettingsLoaded() {
        XaeroPlusSettingsReflectionHax.ALL_SETTINGS.get().forEach(XaeroPlusSetting::init);
        nullOverworldDimensionFolder = XaeroPlusSettingRegistry.nullOverworldDimensionFolder.getValue();
        dataFolderResolutionMode = XaeroPlusSettingRegistry.dataFolderResolutionMode.getValue();
        minimapScalingFactor = (int)XaeroPlusSettingRegistry.minimapScaling.getValue();
    }

    public static void switchToDimension(ResourceKey<Level> newDimId) {
        if (newDimId == null) {
            return;
        }
        try {
            WorldMapSession session = XaeroWorldMapCore.currentSession;
            if (session == null) {
                return;
            }
            MapProcessor mapProcessor = session.getMapProcessor();
            if (mapProcessor == null) {
                return;
            }
            MapWorld mapWorld = mapProcessor.getMapWorld();
            if (mapWorld == null) {
                return;
            }
            mapWorld.setCustomDimensionId(newDimId);
            mapProcessor.checkForWorldUpdate();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Failed switching to dimension: {}", newDimId, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] decompressZipToBytes(Path input) {
        try (ZipInputStream in = new ZipInputStream(Files.newInputStream(input, new OpenOption[0]));){
            if (in.getNextEntry() == null) return new byte[0];
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

