/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.task.GetServerDetailsTask;
import java.lang.reflect.Field;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.patreon.GuiUpdateAll;
import xaero.map.patreon.Patreon;

public class ClientEvents {
    public static final ResourceLocation VANILLA_GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;

    public Screen handleGuiOpen(Screen gui) {
        if (gui instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                GetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = Misc.getFieldReflection(RealmsLongRunningMcoTaskScreen.class, "task", "field_19919", "Lnet/minecraft/class_4358;", "f_88773_");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = Misc.getFieldReflection(GetServerDetailsTask.class, "server", "field_20224", "Lnet/minecraft/class_4877;", "f_90327_");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)gui)) instanceof GetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (GetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.f_87473_ != this.latestRealm.f_87473_)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        return gui;
    }

    public boolean handleRenderTick(boolean start) {
        WorldMapSession worldmapSession;
        Minecraft mc = Minecraft.m_91087_();
        if (!start) {
            WorldMap.glObjectDeleter.work();
        }
        boolean shouldCancelGameRender = false;
        if (mc.f_91074_ != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (!start) {
                mapProcessor.onRenderProcess(mc);
                mapProcessor.resetRenderStartTime();
                Queue<Runnable> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                Runnable task = mapProcessor.getRenderStartTimeUpdater();
                Runnable[] currentTasks = minecraftScheduledTasks.toArray(new Runnable[0]);
                minecraftScheduledTasks.clear();
                minecraftScheduledTasks.add(task);
                for (Runnable t : currentTasks) {
                    minecraftScheduledTasks.add(t);
                }
            } else {
                if (!SupportMods.vivecraft && Misc.screenShouldSkipWorldRender(mc.f_91080_, true)) {
                    RenderSystem.enableDepthTest();
                    mc.f_91073_.m_194141_();
                    mc.f_91073_.m_7726_().m_7827_().m_9323_();
                    shouldCancelGameRender = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
        return shouldCancelGameRender;
    }

    public void handleDrawScreen(Screen gui) {
        if (Patreon.needsNotification() && gui instanceof TitleScreen && !SupportMods.minimap()) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiUpdateAll());
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    public void handlePlayerSetSpawnEvent(BlockPos spawn, ClientLevel world) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(spawn, world);
        }
    }

    public void handleWorldUnload(LevelAccessor world) {
        WorldMapSession worldmapSession;
        if (Minecraft.m_91087_().f_91074_ != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (world == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (world instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)world;
            WorldDataHandler.onServerWorldUnload(sw);
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }

    public void handleRenderCrosshairs(GuiGraphics guiGraphics) {
        String crosshairMessage;
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession == null ? null : worldmapSession.getMapProcessor();
        String string = crosshairMessage = mapProcessor == null ? null : mapProcessor.getCrosshairMessage();
        if (crosshairMessage != null) {
            int messageWidth = Minecraft.m_91087_().f_91062_.m_92895_(crosshairMessage);
            RenderSystem.disableBlend();
            Window window = Minecraft.m_91087_().m_91268_();
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, crosshairMessage, window.m_85445_() / 2 - messageWidth / 2, window.m_85446_() / 2 + 60, -1);
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)VANILLA_GUI_ICONS_LOCATION);
        }
    }

    public boolean handleClientPlayerChatReceivedEvent(ChatType.Bound chatType, Component component, GameProfile gameProfile) {
        if (component == null) {
            return false;
        }
        return this.handleChatMessage(gameProfile == null ? null : gameProfile.getName(), component);
    }

    public boolean handleClientSystemChatReceivedEvent(Component component) {
        WorldMapSession worldmapSession;
        if (component == null) {
            return false;
        }
        String textString = component.getString();
        if (textString.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlayMessage(false);
        }
        if (textString.contains("\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o\u00a7w\u00a7m\u00a7n\u00a7e\u00a7t\u00a7h\u00a7e\u00a7r\u00a7i\u00a7s\u00a7f\u00a7a\u00a7i\u00a7r")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlayMessage(true);
        }
        return this.handleChatMessage(I18n.m_118938_((String)"gui.xaero_waypoint_server_shared", (Object[])new Object[0]), component);
    }

    private boolean handleChatMessage(String playerName, Component text) {
        return false;
    }

    public void handlePlayerTickStart(Player player) {
        WorldMapSession worldmapSession;
        if (player == Minecraft.m_91087_().f_91074_ && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            worldmapSession.getControlsHandler().handleKeyEvents();
        }
    }

    public void handleClientTickStart() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            WorldMap.crashHandler.checkForCrashes();
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            if (worldmapSession != null) {
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                mapProcessor.onClientTickStart();
            }
        }
    }

    public void handleClientRunTickStart() {
        if (Minecraft.m_91087_().f_91074_ != null) {
            WorldMap.crashHandler.checkForCrashes();
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            if (worldmapSession != null) {
                worldmapSession.getMapProcessor().getWorldDataHandler().handleRenderExecutor();
            }
        }
    }
}

