/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.JsonHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class PotionProviderRecipe
implements Recipe<CraftingContainer> {
    private final ResourceLocation id;
    private final NonNullList<Ingredient> providers;
    private final List<Potion> potions;

    public PotionProviderRecipe(ResourceLocation id, NonNullList<Ingredient> providers, List<Potion> potions) {
        this.id = id;
        this.providers = providers;
        this.potions = potions;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return "potion_provider";
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.providers;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(CraftingContainer wrapper, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Jeed.getPotionProviderSerializer();
    }

    public RecipeType<?> m_6671_() {
        return Jeed.getPotionProviderType();
    }

    public List<Potion> getPotions() {
        return this.potions.isEmpty() ? BuiltInRegistries.f_256980_.m_123024_().toList() : this.potions;
    }

    public static class Serializer
    implements RecipeSerializer<PotionProviderRecipe> {
        public PotionProviderRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            List<Potion> potions;
            NonNullList<Ingredient> providers = JsonHelper.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"providers"));
            try {
                potions = JsonHelper.readPotionList(GsonHelper.m_13933_((JsonObject)json, (String)"potions"));
            }
            catch (Exception ignored) {
                potions = new ArrayList<Potion>();
            }
            if (providers.isEmpty()) {
                throw new JsonParseException("No effect providers for recipe");
            }
            return new PotionProviderRecipe(recipeId, providers, potions);
        }

        @Nullable
        public PotionProviderRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            NonNullList providers = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            providers.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            int x = buffer.m_130242_();
            ArrayList<Potion> potions = new ArrayList<Potion>();
            for (int y = 0; y < x; ++y) {
                potions.add(JsonHelper.getPotion(buffer.m_130281_()));
            }
            return new PotionProviderRecipe(recipeId, (NonNullList<Ingredient>)providers, potions);
        }

        public void toNetwork(FriendlyByteBuf buffer, PotionProviderRecipe recipe) {
            buffer.m_130130_(recipe.providers.size());
            for (Ingredient result : recipe.providers) {
                result.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.potions.size());
            for (Potion potion : recipe.potions) {
                buffer.m_130085_(BuiltInRegistries.f_256980_.m_7981_((Object)potion));
            }
        }
    }
}

