/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.rei;

import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.rei.BreedingDisplay;
import com.christofmeg.justenoughbreeding.utils.Utils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BreedingCategoryREI
implements DisplayCategory<BreedingDisplay> {
    public static final CategoryIdentifier<BreedingDisplay> TYPE = CategoryIdentifier.of((String)"justenoughbreeding", (String)"breeding");
    final int inputSlotFrameX = 74;
    final int inputSlot1FrameY = 63;
    final int inputSlot2FrameY = 44;
    final int outputSlotFrameX = 135;
    final int outputSlotFrameY = 53;
    final int eggSlotX = 154;
    final int eggSlotY = 6;
    final int arrowX = 98;
    final int arrowY = 52;
    final int mobSlotX = 5;
    final int mobSlotY = 15;

    public CategoryIdentifier<? extends BreedingDisplay> getCategoryIdentifier() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"translation.justenoughbreeding.breeding");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Items.f_42405_);
    }

    public List<Widget> setupDisplay(BreedingDisplay display, Rectangle bounds) {
        LinkedList<Widget> widgets = new LinkedList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add((Widget)Widgets.createSlotBase((Rectangle)new Rectangle(bounds.x + 5, bounds.y + 15, 61, 81)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 154, bounds.y + 6)).entries(List.of(EntryStacks.of((ItemStack)display.breedingRecipe.spawnEgg))));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 74, bounds.y + 63)).entries((Collection)display.getInputEntries().get(0)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 74, bounds.y + 44)).entries((Collection)display.getExtraInputEntries().get(0)));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(bounds.x + 98, bounds.y + 52)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(bounds.x + 135, bounds.y + 53)));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 135, bounds.y + 53)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        BreedingRecipe recipe = display.breedingRecipe;
        EntityType<?> entityType = recipe.entityType;
        if (entityType != null) {
            Minecraft instance = Minecraft.m_91087_();
            Font font = instance.f_91062_;
            MutableComponent entityName = Component.m_237115_((String)entityType.m_20675_());
            Object entityNameString = entityName.getString();
            if (recipe.needsToBeTamed != null) {
                MutableComponent tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
            } else if (recipe.animalTrusting != null) {
                MutableComponent trusting = Component.m_237115_((String)"translation.justenoughbreeding.trusting");
                entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
            } else if (recipe.spawnEgg.m_41778_().startsWith("item.tfc")) {
                MutableComponent familiarity = Component.m_237115_((String)"tfc.jade.familiarity");
                String tfc = familiarity.getString().replaceAll(":[^:]*$", "");
                entityNameString = (String)entityNameString + " (" + tfc + " > 30)";
            }
            int stringWidth = font.m_92895_((String)entityNameString);
            int availableWidth = 154;
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)((String)entityNameString).length();
                int maxCharacters = (int)((float)availableWidth / pixelWidthPerCharacter);
                entityNameString = ((String)entityNameString).substring(0, maxCharacters);
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.m_130674_((String)entityNameString);
                widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + 5, bounds.y + 5), (Component)abbreviatedEntityName).noShadow().leftAligned().color(-12566464, -4473925));
            }
            widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.createDrawableWidget((stack, mouseX, mouseY, v) -> {
                LivingEntity currentLivingEntity = recipe.doRendering();
                if (currentLivingEntity != null) {
                    Utils.renderEntity(stack.m_280168_(), mouseX, currentLivingEntity);
                }
            }), (double)(bounds.x + 5), (double)(bounds.y + 15 - 10), (double)0.0));
        }
        return widgets;
    }

    public int getDisplayWidth(BreedingDisplay breedingDisplay) {
        return 176;
    }

    public int getDisplayHeight() {
        return 101;
    }
}

