/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.net.covers1624.quack.net.download;

import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.annotation.Requires;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.net.download.DownloadListener;
import net.creeperhost.ftbbackups.repack.net.covers1624.quack.util.DataUtils;
import net.creeperhost.ftbbackups.repack.net.covers1624.tconsole.AbstractTail;
import net.creeperhost.ftbbackups.repack.net.covers1624.tconsole.api.Tail;
import net.creeperhost.ftbbackups.repack.net.covers1624.tconsole.api.TailGroup;
import org.fusesource.jansi.Ansi;

@Requires(value="net.creeperhost.ftbbackups.repack.net.covers1624:TailConsole")
public class DownloadProgressTail
extends AbstractTail
implements DownloadListener {
    private Status status = Status.IDLE;
    private String fileName = "";
    private long totalLen;
    private long progress;
    private long startTime;
    private boolean newData = false;

    public DownloadProgressTail() {
        super(1);
    }

    public void tick() {
        if (this.newData) {
            Ansi a = Ansi.ansi();
            switch (this.status) {
                case IDLE: {
                    a.a("Idle..");
                    break;
                }
                case CONNECTING: {
                    a.a("Connecting: " + this.fileName + "..");
                    break;
                }
                case DOWNLOADING: {
                    int termWidth = this.getTerminalWidth();
                    double done = (double)this.progress / (double)this.totalLen;
                    long elapsed = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.startTime);
                    double speedBps = (double)this.progress / (double)elapsed;
                    if (Double.isInfinite(speedBps)) {
                        speedBps = 0.0;
                    }
                    String prefix = "Downloading: " + this.fileName + " ";
                    String progressString = MessageFormat.format(" {0}/{1}({2}%) {3}", DataUtils.humanSize(this.progress), DataUtils.humanSize(this.totalLen), (int)(done * 100.0), DataUtils.humanSpeed(speedBps));
                    int remaining = termWidth - (progressString.length() + prefix.length());
                    a.a(prefix);
                    Ansi.Color color = done > 0.75 ? Ansi.Color.GREEN : (done > 0.5 ? Ansi.Color.YELLOW : Ansi.Color.RED);
                    int width = (int)Math.floor(done * (double)(remaining -= 2));
                    a.fg(color).a("[").bold();
                    for (int i = 1; i <= remaining; ++i) {
                        if (i <= width) {
                            if (i == width) {
                                a.a(">");
                                continue;
                            }
                            a.a("=");
                            continue;
                        }
                        a.a("-");
                    }
                    a.boldOff();
                    a.a("]").fgDefault().a(progressString);
                    break;
                }
            }
            this.setLine(0, a);
        }
    }

    public boolean setLine(int line, String text) {
        this.newData = false;
        return super.setLine(line, text);
    }

    public Status getStatus() {
        return this.status;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getTotalLen() {
        return this.totalLen;
    }

    public long getProgress() {
        return this.progress;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.onNewData();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.onNewData();
    }

    public void setTotalLen(long totalLen) {
        this.totalLen = totalLen;
        this.onNewData();
    }

    public void setProgress(long progress) {
        this.progress = progress;
        this.onNewData();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.onNewData();
    }

    private void onNewData() {
        this.newData = true;
        this.tick();
    }

    @Override
    public void connecting() {
        this.setStatus(Status.CONNECTING);
    }

    @Override
    public void start(long expectedLen) {
        this.setTotalLen(expectedLen);
        this.setStatus(Status.DOWNLOADING);
        this.setStartTime(System.currentTimeMillis());
    }

    @Override
    public void update(long processedBytes) {
        this.setProgress(processedBytes);
    }

    @Override
    public void finish(long totalProcessed) {
        this.setStatus(Status.IDLE);
    }

    public static class Pool {
        private final TailGroup group;
        private final ArrayDeque<DownloadProgressTail> tails = new ArrayDeque();

        public Pool(TailGroup group) {
            this.group = group;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DownloadProgressTail pop() {
            DownloadProgressTail ret;
            ArrayDeque<DownloadProgressTail> arrayDeque = this.tails;
            synchronized (arrayDeque) {
                ret = this.tails.poll();
            }
            if (ret == null) {
                ret = (DownloadProgressTail)this.group.add((Tail)new DownloadProgressTail());
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void push(DownloadProgressTail tail) {
            ArrayDeque<DownloadProgressTail> arrayDeque = this.tails;
            synchronized (arrayDeque) {
                this.tails.addLast(tail);
            }
        }
    }

    public static enum Status {
        IDLE,
        CONNECTING,
        DOWNLOADING;

    }
}

