/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.forge;

import net.creeperhost.polylib.PolyLib;
import net.creeperhost.polylib.events.ChunkEvents;
import net.creeperhost.polylib.forge.inventory.energy.ForgeEnergyContainer;
import net.creeperhost.polylib.forge.inventory.energy.ForgeItemEnergyContainer;
import net.creeperhost.polylib.forge.inventory.item.ItemContainerWrapper;
import net.creeperhost.polylib.inventory.energy.PolyEnergyBlock;
import net.creeperhost.polylib.inventory.energy.PolyEnergyItem;
import net.creeperhost.polylib.inventory.item.ItemInventoryBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="polylib", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onChunkLoadEvent(ChunkEvent.Load event) {
        ((ChunkEvents.ChunkLoadEvent)ChunkEvents.CHUNK_LOAD_EVENT.invoker()).onChunkLoad((Level)event.getLevel(), (LevelChunk)event.getChunk());
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
        ((ChunkEvents.ChunkUnloadEvent)ChunkEvents.CHUNK_UNLOAD_EVENT.invoker()).onChunkUnload((Level)event.getLevel(), (LevelChunk)event.getChunk());
    }

    @SubscribeEvent
    public static void OnAttachCapabilitiesEvent(AttachCapabilitiesEvent<BlockEntity> event) {
        Object object = event.getObject();
        if (object instanceof PolyEnergyBlock) {
            PolyEnergyBlock energyBlock = (PolyEnergyBlock)object;
            event.addCapability(new ResourceLocation("polylib", "energy"), new ForgeEnergyContainer(energyBlock.getEnergyStorage(), (BlockEntity)event.getObject()));
        }
        if ((object = event.getObject()) instanceof ItemInventoryBlock) {
            ItemInventoryBlock itemInventoryBlock = (ItemInventoryBlock)object;
            String name = ((BlockEntity)event.getObject()).m_58900_().m_60734_().m_7705_();
            PolyLib.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Adding item cap to " + name);
            event.addCapability(new ResourceLocation("polylib", "item"), (ICapabilityProvider)new ItemContainerWrapper(itemInventoryBlock.getContainer()));
        }
    }

    @SubscribeEvent
    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (item instanceof PolyEnergyItem) {
            PolyEnergyItem energyItem = (PolyEnergyItem)item;
            event.addCapability(new ResourceLocation("polylib", "energy"), new ForgeItemEnergyContainer(energyItem.getEnergyStorage((ItemStack)event.getObject()), (ItemStack)event.getObject()));
        }
    }
}

