/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import org.jetbrains.annotations.NotNull;

public class GuiRectangle
extends GuiElement<GuiRectangle>
implements BackgroundRender {
    private Supplier<Integer> fill = null;
    private Supplier<Integer> border = null;
    private Supplier<Integer> borderWidth = () -> 1;
    private Supplier<Integer> shadeTopLeft;
    private Supplier<Integer> shadeBottomRight;
    private Supplier<Integer> shadeCorners;

    public GuiRectangle(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public GuiRectangle border(int border) {
        return this.border(() -> border);
    }

    public GuiRectangle border(Supplier<Integer> border) {
        this.border = border;
        return this;
    }

    public GuiRectangle fill(int fill) {
        return this.fill(() -> fill);
    }

    public GuiRectangle fill(Supplier<Integer> fill) {
        this.fill = fill;
        return this;
    }

    public GuiRectangle rectangle(int fill, int border) {
        return this.rectangle(() -> fill, () -> border);
    }

    public GuiRectangle rectangle(Supplier<Integer> fill, Supplier<Integer> border) {
        this.fill = fill;
        this.border = border;
        return this;
    }

    public GuiRectangle shadedRect(int topLeft, int bottomRight, int fill) {
        return this.shadedRect(() -> topLeft, () -> bottomRight, () -> fill);
    }

    public GuiRectangle shadedRect(Supplier<Integer> topLeft, Supplier<Integer> bottomRight, Supplier<Integer> fill) {
        return this.shadedRect(topLeft, bottomRight, () -> GuiRender.midColour((Integer)topLeft.get(), (Integer)bottomRight.get()), fill);
    }

    public GuiRectangle shadedRect(int topLeft, int bottomRight, int cornerMix, int fill) {
        return this.shadedRect(() -> topLeft, () -> bottomRight, () -> cornerMix, () -> fill);
    }

    public GuiRectangle shadedRect(Supplier<Integer> topLeft, Supplier<Integer> bottomRight, Supplier<Integer> cornerMix, Supplier<Integer> fill) {
        this.fill = fill;
        this.shadeTopLeft = topLeft;
        this.shadeBottomRight = bottomRight;
        this.shadeCorners = cornerMix;
        return this;
    }

    public GuiRectangle borderWidth(int borderWidth) {
        return this.borderWidth(() -> borderWidth);
    }

    public GuiRectangle borderWidth(Supplier<Integer> borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public int getBorderWidth() {
        return this.borderWidth.get();
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.shadeTopLeft != null && this.shadeBottomRight != null && this.shadeCorners != null) {
            render.shadedRect(this.getRectangle(), this.getBorderWidth(), this.shadeTopLeft.get(), this.shadeBottomRight.get(), this.shadeCorners.get(), this.fill == null ? 0 : this.fill.get());
        } else if (this.border != null) {
            render.borderRect(this.getRectangle(), this.getBorderWidth(), this.fill == null ? 0 : this.fill.get(), this.border.get());
        } else if (this.fill != null) {
            render.rect(this.getRectangle(), this.fill.get());
        }
    }

    public static GuiRectangle vanillaSlot(@NotNull GuiParent<?> parent) {
        return new GuiRectangle(parent).shadedRect(-13158601, -1, -7631989, -7631989);
    }

    public static GuiRectangle invertedSlot(@NotNull GuiParent<?> parent) {
        return new GuiRectangle(parent).shadedRect(-1, -13158601, -7631989, -7631989);
    }

    public static GuiRectangle planeButton(@NotNull GuiParent<?> parent) {
        return new GuiRectangle(parent).shadedRect(-5592406, -11250604, -9474193);
    }
}

