/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.lib.ContentElement;
import net.creeperhost.polylib.client.modulargui.lib.CursorHelper;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiManipulable
extends GuiElement<GuiManipulable>
implements ContentElement<GuiElement<?>> {
    private final GuiElement<?> contentElement;
    private int dragXOffset = 0;
    private int dragYOffset = 0;
    private boolean isDragging = false;
    private boolean dragPos = false;
    private boolean dragTop = false;
    private boolean dragLeft = false;
    private boolean dragBottom = false;
    private boolean dragRight = false;
    private boolean enableCursors = false;
    public double xMin = 0.0;
    public double xMax = 0.0;
    public double yMin = 0.0;
    public double yMax = 0.0;
    protected Rectangle minSize = Rectangle.create(0.0, 0.0, 50.0, 50.0);
    protected Rectangle maxSize = Rectangle.create(0.0, 0.0, 256.0, 256.0);
    protected Runnable onMovedCallback = null;
    protected Runnable onResizedCallback = null;
    protected PositionRestraint positionRestraint = draggable -> {
        double move;
        if (this.xMin < 0.0) {
            move = -this.xMin;
            this.xMin += move;
            this.xMax += move;
        } else if (this.xMax > (double)this.scaledScreenWidth()) {
            move = this.xMax - (double)this.scaledScreenWidth();
            this.xMin -= move;
            this.xMax -= move;
        }
        if (this.yMin < 0.0) {
            move = -this.yMin;
            this.yMin += move;
            this.yMax += move;
        } else if (this.yMax > (double)this.scaledScreenHeight()) {
            move = this.yMax - (double)this.scaledScreenHeight();
            this.yMin -= move;
            this.yMax -= move;
        }
    };
    private GuiElement<?> moveHandle = null;
    private GuiElement<?> leftHandle = null;
    private GuiElement<?> rightHandle = null;
    private GuiElement<?> topHandle = null;
    private GuiElement<?> bottomHandle = null;

    public GuiManipulable(@NotNull GuiParent<?> parent) {
        super(parent);
        this.contentElement = (GuiElement)((GuiElement)((GuiElement)((GuiElement)new GuiElement(this).constrain(GeoParam.LEFT, Constraint.dynamic(() -> this.xMin))).constrain(GeoParam.RIGHT, Constraint.dynamic(() -> this.xMax))).constrain(GeoParam.TOP, Constraint.dynamic(() -> this.yMin))).constrain(GeoParam.BOTTOM, Constraint.dynamic(() -> this.yMax));
    }

    public GuiManipulable resetBounds() {
        this.xMin = this.xMin();
        this.xMax = this.xMax();
        this.yMin = this.yMin();
        this.yMax = this.yMax();
        return this;
    }

    @Override
    public GuiManipulable constrain(GeoParam param, @Nullable Constraint constraint) {
        return ((GuiManipulable)super.constrain(param, constraint)).resetBounds();
    }

    @Override
    public void onScreenInit(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        super.onScreenInit(mc, font, screenWidth, screenHeight);
        this.resetBounds();
    }

    @Override
    public GuiElement<?> getContentElement() {
        return this.contentElement;
    }

    public GuiManipulable addResizeHandles(int handleSize, boolean includeTopHandle) {
        if (includeTopHandle) {
            this.addTopHandle(handleSize);
        }
        this.addLeftHandle(handleSize);
        this.addRightHandle(handleSize);
        this.addBottomHandle(handleSize);
        return this;
    }

    public GuiManipulable addTopHandle(int handleSize) {
        if (this.topHandle != null) {
            throw new IllegalStateException("Top handle already exists!");
        }
        this.topHandle = (GuiElement)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle(this.contentElement).constrain(GeoParam.TOP, Constraint.match(this.contentElement.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.match(this.contentElement.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(this.contentElement.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable addBottomHandle(int handleSize) {
        if (this.bottomHandle != null) {
            throw new IllegalStateException("Bottom handle already exists!");
        }
        this.bottomHandle = (GuiElement)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle(this.contentElement).constrain(GeoParam.BOTTOM, Constraint.match(this.contentElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, Constraint.match(this.contentElement.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(this.contentElement.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable addLeftHandle(int handleSize) {
        if (this.leftHandle != null) {
            throw new IllegalStateException("Left handle already exists!");
        }
        this.leftHandle = (GuiElement)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle(this.contentElement).constrain(GeoParam.LEFT, Constraint.match(this.contentElement.get(GeoParam.LEFT)))).constrain(GeoParam.TOP, Constraint.match(this.contentElement.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, Constraint.match(this.contentElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable addRightHandle(int handleSize) {
        if (this.rightHandle != null) {
            throw new IllegalStateException("Left handle already exists!");
        }
        this.rightHandle = (GuiElement)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle(this.contentElement).constrain(GeoParam.RIGHT, Constraint.match(this.contentElement.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, Constraint.match(this.contentElement.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, Constraint.match(this.contentElement.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, Constraint.literal(handleSize));
        return this;
    }

    public GuiManipulable addMoveHandle(int handleSize) {
        if (this.moveHandle != null) {
            throw new IllegalStateException("Move handle already exists!");
        }
        this.moveHandle = (GuiElement)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle(this.contentElement).constrain(GeoParam.TOP, Constraint.match(this.contentElement.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, Constraint.match(this.contentElement.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, Constraint.match(this.contentElement.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, Constraint.literal(handleSize));
        return this;
    }

    public GuiElement<?> getMoveHandle() {
        return this.moveHandle;
    }

    public GuiElement<?> getLeftHandle() {
        return this.leftHandle;
    }

    public GuiElement<?> getRightHandle() {
        return this.rightHandle;
    }

    public GuiElement<?> getTopHandle() {
        return this.topHandle;
    }

    public GuiElement<?> getBottomHandle() {
        return this.bottomHandle;
    }

    public GuiManipulable enableCursors(boolean enableCursors) {
        this.enableCursors = enableCursors;
        return this;
    }

    public GuiManipulable setOnMovedCallback(Runnable onMovedCallback) {
        this.onMovedCallback = onMovedCallback;
        return this;
    }

    public GuiManipulable setOnResizedCallback(Runnable onResizedCallback) {
        this.onResizedCallback = onResizedCallback;
        return this;
    }

    public GuiManipulable setPositionRestraint(PositionRestraint positionRestraint) {
        this.positionRestraint = positionRestraint;
        return this;
    }

    public void setMinSize(Rectangle minSize) {
        this.minSize = minSize;
    }

    public void setMaxSize(Rectangle maxSize) {
        this.maxSize = maxSize;
    }

    public Rectangle getMinSize() {
        return this.minSize;
    }

    public Rectangle getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void tick(double mouseX, double mouseY) {
        if (this.enableCursors) {
            boolean any;
            boolean posFlag = this.moveHandle != null && this.moveHandle.isMouseOver();
            boolean topFlag = this.topHandle != null && this.topHandle.isMouseOver();
            boolean leftFlag = this.leftHandle != null && this.leftHandle.isMouseOver();
            boolean bottomFlag = this.bottomHandle != null && this.bottomHandle.isMouseOver();
            boolean rightFlag = this.rightHandle != null && this.rightHandle.isMouseOver();
            boolean bl = any = posFlag || topFlag || leftFlag || bottomFlag || rightFlag;
            if (any) {
                if (posFlag) {
                    this.getModularGui().setCursor(CursorHelper.DRAG);
                } else if (topFlag && leftFlag || bottomFlag && rightFlag) {
                    this.getModularGui().setCursor(CursorHelper.RESIZE_TLBR);
                } else if (topFlag && rightFlag || bottomFlag && leftFlag) {
                    this.getModularGui().setCursor(CursorHelper.RESIZE_TRBL);
                } else if (topFlag || bottomFlag) {
                    this.getModularGui().setCursor(CursorHelper.RESIZE_V);
                } else {
                    this.getModularGui().setCursor(CursorHelper.RESIZE_H);
                }
            }
        }
        super.tick(mouseX, mouseY);
    }

    public void startDragging() {
        double mouseX = this.getModularGui().computeMouseX();
        double mouseY = this.getModularGui().computeMouseY();
        this.dragXOffset = (int)(mouseX - this.xMin);
        this.dragYOffset = (int)(mouseY - this.yMin);
        this.isDragging = true;
        this.dragPos = true;
        this.onStartMove(mouseX, mouseY);
        this.onStartManipulation(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean rightFlag;
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        boolean posFlag = this.moveHandle != null && this.moveHandle.isMouseOver();
        boolean topFlag = this.topHandle != null && this.topHandle.isMouseOver();
        boolean leftFlag = this.leftHandle != null && this.leftHandle.isMouseOver();
        boolean bottomFlag = this.bottomHandle != null && this.bottomHandle.isMouseOver();
        boolean bl = rightFlag = this.rightHandle != null && this.rightHandle.isMouseOver();
        if (posFlag || topFlag || leftFlag || bottomFlag || rightFlag) {
            this.dragXOffset = (int)(mouseX - this.xMin);
            this.dragYOffset = (int)(mouseY - this.yMin);
            this.isDragging = true;
            if (posFlag) {
                this.dragPos = true;
                if (this.onStartMove(mouseX, mouseY)) {
                    this.isDragging = false;
                    return true;
                }
            } else {
                this.dragTop = topFlag;
                this.dragLeft = leftFlag;
                this.dragBottom = bottomFlag;
                this.dragRight = rightFlag;
                this.onStartResized(mouseX, mouseY);
            }
            if (this.onStartManipulation(mouseX, mouseY)) {
                this.dragRight = false;
                this.dragBottom = false;
                this.dragLeft = false;
                this.dragTop = false;
                this.dragPos = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.isDragging) {
            double xMove = mouseX - (double)this.dragXOffset - this.xMin;
            double yMove = mouseY - (double)this.dragYOffset - this.yMin;
            if (this.dragPos) {
                Rectangle previous = Rectangle.create(this.xMin, this.yMin, this.xMax - this.xMin, this.yMax - this.yMin);
                this.xMin += xMove;
                this.xMax += xMove;
                this.yMin += yMove;
                this.yMax += yMove;
                this.validatePosition();
                this.validateMove(previous, (int)mouseX, (int)mouseY);
                this.onMoved();
            } else {
                Rectangle min = this.getMinSize();
                Rectangle max = this.getMaxSize();
                if (this.dragTop) {
                    this.yMin += yMove;
                    if (this.yMax - this.yMin < min.height()) {
                        this.yMin = this.yMax - min.height();
                    }
                    if (this.yMax - this.yMin > max.height()) {
                        this.yMin = this.yMax - max.height();
                    }
                    if (this.yMin < 0.0) {
                        this.yMin = 0.0;
                    }
                }
                if (this.dragLeft) {
                    this.xMin += xMove;
                    if (this.xMax - this.xMin < min.width()) {
                        this.xMin = this.xMax - min.width();
                    }
                    if (this.xMax - this.xMin > max.width()) {
                        this.xMin = this.xMax - max.width();
                    }
                    if (this.xMin < 0.0) {
                        this.xMin = 0.0;
                    }
                }
                if (this.dragBottom) {
                    this.yMax = this.yMin + ((double)this.dragYOffset + yMove);
                    if (this.yMax - this.yMin < min.height()) {
                        this.yMax = this.yMin + min.height();
                    }
                    if (this.yMax - this.yMin > max.height()) {
                        this.yMax = this.yMin + max.height();
                    }
                    if (this.yMax > (double)this.scaledScreenHeight()) {
                        this.yMax = this.scaledScreenHeight();
                    }
                }
                if (this.dragRight) {
                    this.xMax = this.xMin + ((double)this.dragXOffset + xMove);
                    if (this.xMax - this.xMin < min.width()) {
                        this.xMax = this.xMin + min.width();
                    }
                    if (this.xMax - this.xMin > max.width()) {
                        this.xMax = this.xMin + max.width();
                    }
                    if (this.xMax > (double)this.scaledScreenWidth()) {
                        this.xMax = this.scaledScreenWidth();
                    }
                }
                this.validatePosition();
                this.onResized();
            }
            this.onManipulated(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            this.validatePosition();
            if (this.dragPos) {
                this.onFinishMove(mouseX, mouseY);
            } else {
                this.onFinishResized(mouseX, mouseY);
            }
            this.onFinishManipulation(mouseX, mouseY);
        }
        this.dragRight = false;
        this.dragBottom = false;
        this.dragLeft = false;
        this.dragTop = false;
        this.dragPos = false;
        this.isDragging = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected void validatePosition() {
        double x = this.xMin;
        double y = this.yMin;
        this.positionRestraint.restrainPosition(this);
        if ((x != this.xMin || y != this.yMin) && this.onMovedCallback != null) {
            this.onMovedCallback.run();
        }
    }

    protected void onMoved() {
        if (this.onMovedCallback != null) {
            this.onMovedCallback.run();
        }
    }

    protected void onResized() {
        if (this.onResizedCallback != null) {
            this.onResizedCallback.run();
        }
    }

    protected void onManipulated(double mouseX, double mouseY) {
    }

    protected boolean onStartManipulation(double mouseX, double mouseY) {
        return false;
    }

    protected void onFinishManipulation(double mouseX, double mouseY) {
    }

    protected boolean onStartMove(double mouseX, double mouseY) {
        return false;
    }

    protected void onStartResized(double mouseX, double mouseY) {
    }

    protected void onFinishMove(double mouseX, double mouseY) {
    }

    protected void onFinishResized(double mouseX, double mouseY) {
    }

    protected void validateMove(Rectangle previous, double mouseX, double mouseY) {
    }

    public static interface PositionRestraint {
        public void restrainPosition(GuiManipulable var1);
    }
}

