/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ExecuteEffect;
import se.mickelus.tetra.effect.ExtractionEffect;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.ItemEffectHandler;
import se.mickelus.tetra.effect.JankEffect;
import se.mickelus.tetra.effect.LungeEffect;
import se.mickelus.tetra.effect.OverpowerEffect;
import se.mickelus.tetra.effect.PiercingEffect;
import se.mickelus.tetra.effect.PryChargedEffect;
import se.mickelus.tetra.effect.PryEffect;
import se.mickelus.tetra.effect.PunctureEffect;
import se.mickelus.tetra.effect.ReapEffect;
import se.mickelus.tetra.effect.SculkTaintEffect;
import se.mickelus.tetra.effect.SlamEffect;
import se.mickelus.tetra.effect.SweepingEffect;
import se.mickelus.tetra.effect.UnboundExtractionEffect;
import se.mickelus.tetra.effect.howling.HowlingEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.items.modular.ChargedAbilityPacket;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.SecondaryAbilityPacket;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.util.TierHelper;
import se.mickelus.tetra.util.ToolActionHelper;

@ParametersAreNonnullByDefault
public class ItemModularHandheld
extends ModularItem {
    public static final TagKey<Block> nailedTag = BlockTags.create((ResourceLocation)new ResourceLocation("tetra", "nailed"));
    public static final int blockingDurationLimit = 16;
    static final ChargedAbilityEffect[] abilities = new ChargedAbilityEffect[]{ExecuteEffect.instance, LungeEffect.instance, SlamEffect.instance, PunctureEffect.instance, OverpowerEffect.instance, ReapEffect.instance, PryChargedEffect.instance};
    protected int blockDestroyDamage = 1;
    protected int entityHitDamage = 1;

    public ItemModularHandheld(Item.Properties properties) {
        super(properties);
    }

    public static boolean canDenail(BlockState blockState) {
        return blockState.m_204336_(nailedTag);
    }

    public static void handleChargedAbility(Player player, InteractionHand hand, @Nullable LivingEntity target, @Nullable BlockPos targetPos, @Nullable Vec3 hitVec, int ticksUsed) {
        ItemStack activeStack = player.m_21120_(hand);
        if (!activeStack.m_41619_() && activeStack.m_41720_() instanceof ItemModularHandheld) {
            ItemModularHandheld item = (ItemModularHandheld)activeStack.m_41720_();
            Arrays.stream(abilities).filter(ability -> ability.canPerform(player, item, activeStack, target, targetPos, ticksUsed)).findFirst().ifPresent(ability -> ability.perform(player, hand, item, activeStack, target, targetPos, hitVec, ticksUsed));
            player.m_5810_();
        }
    }

    public static void handleSecondaryAbility(Player player, InteractionHand hand, @Nullable LivingEntity target) {
        Item item;
        ItemStack activeStack = player.m_21120_(hand);
        if (!activeStack.m_41619_() && (item = activeStack.m_41720_()) instanceof ItemModularHandheld) {
            ItemModularHandheld item2 = (ItemModularHandheld)item;
            if (target != null) {
                item2.itemInteractionForEntitySecondary(activeStack, player, target, hand);
                player.m_5810_();
                player.m_36335_().m_41524_((Item)item2, (int)Math.round(item2.getCooldownBase(activeStack) * 20.0 * 1.5));
                player.m_6674_(hand);
            }
        }
    }

    public static double getCounterWeightBonus(int counterWeightLevel, int integrityCost) {
        return Math.max(0.0, 0.15 - (double)Math.abs(counterWeightLevel - integrityCost) * 0.05);
    }

    public static double getAttackSpeedHarvestModifier(double attackSpeed) {
        return attackSpeed * 0.5 + 0.5;
    }

    public static double getEfficiencyEnchantmentBonus(int level) {
        if (level > 0) {
            return level * level + 1;
        }
        return 0.0;
    }

    public int getBlockDestroyDamage() {
        return this.blockDestroyDamage;
    }

    public int getEntityHitDamage() {
        return this.entityHitDamage;
    }

    public boolean isDamageable(ItemStack stack) {
        return this.getMaxDamage(stack) > 0;
    }

    public boolean m_6813_(ItemStack itemStack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.m_60800_((BlockGetter)world, pos) > 0.0f) {
            this.applyDamage(this.blockDestroyDamage, itemStack, entity);
            if (!this.isBroken(itemStack)) {
                this.applyUsageEffects(entity, itemStack, 1.0);
            }
        }
        this.applyBlockBreakEffects(itemStack, world, state, pos, entity);
        if (!world.f_46443_ && !this.isBroken(itemStack)) {
            int unboundExtractionLevel;
            int extractorLevel;
            if (this.getEffectLevel(itemStack, ItemEffect.piercingHarvest) > 0) {
                PiercingEffect.pierceBlocks(this, itemStack, this.getEffectLevel(itemStack, ItemEffect.piercing), (ServerLevel)world, state, pos, entity);
            }
            if ((extractorLevel = this.getEffectLevel(itemStack, ItemEffect.extraction)) > 0) {
                ExtractionEffect.breakBlocks(this, itemStack, extractorLevel, (ServerLevel)world, state, pos, entity);
            }
            if ((unboundExtractionLevel = this.getEffectLevel(itemStack, ItemEffect.unboundExtraction)) > 0) {
                UnboundExtractionEffect.breakBlocks(this, itemStack, unboundExtractionLevel, (ServerLevel)world, state, pos, entity);
            }
            CritEffect.onBlockBreak(entity);
        }
        return true;
    }

    public void applyBlockBreakEffects(ItemStack itemStack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!world.f_46443_) {
            int skulkTaintLevel;
            int jankLevel;
            int xp;
            int intuitLevel = this.getEffectLevel(itemStack, ItemEffect.intuit);
            if (intuitLevel > 0 && (xp = state.getExpDrop((LevelReader)world, world.m_213780_(), pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)itemStack), EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)itemStack))) > 0) {
                this.tickHoningProgression(entity, itemStack, xp * intuitLevel);
            }
            if ((jankLevel = this.getEffectLevel(itemStack, ItemEffect.janking)) > 0) {
                JankEffect.jankItemsDelayed((ServerLevel)world, pos, jankLevel, this.getEffectEfficiency(itemStack, ItemEffect.janking), (Entity)entity);
            }
            if ((skulkTaintLevel = this.getEffectLevel(itemStack, ItemEffect.sculkTaint)) > 0) {
                SculkTaintEffect.perform((ServerLevel)world, pos, skulkTaintLevel, this.getEffectEfficiency(itemStack, ItemEffect.sculkTaint));
            }
        }
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        this.applyDamage(this.entityHitDamage, itemStack, attacker);
        if (!this.isBroken(itemStack)) {
            int skulkTaintLevel;
            float attackStrength = CastOptional.cast((Object)attacker, Player.class).map(EffectHelper::getCooledAttackStrength).orElse(Float.valueOf(1.0f)).floatValue();
            if ((double)attackStrength > 0.9) {
                int howlingLevel;
                int sweepingLevel = SweepingEffect.getSweepingLevel(itemStack);
                if (sweepingLevel > 0 && attacker.m_20096_() && !EffectHelper.getSprinting(attacker)) {
                    SweepingEffect.sweepAttack(itemStack, target, attacker, sweepingLevel);
                }
                if ((howlingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.howling)) > 0) {
                    HowlingEffect.trigger(itemStack, attacker, howlingLevel);
                }
                ItemEffectHandler.applyHitEffects(itemStack, target, attacker);
                this.applyPositiveUsageEffects(attacker, itemStack, 1.0);
            }
            if ((skulkTaintLevel = this.getEffectLevel(itemStack, ItemEffect.sculkTaint)) > 0) {
                SculkTaintEffect.perform((ServerLevel)target.m_9236_(), target.m_20183_(), skulkTaintLevel, this.getEffectEfficiency(itemStack, ItemEffect.sculkTaint));
            }
            this.applyNegativeUsageEffects(attacker, itemStack, 1.0);
        }
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean canChannel;
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        ItemStack itemStack = player.m_21120_(hand);
        BlockState blockState = world.m_8055_(pos);
        if (this.isBroken(itemStack)) {
            return InteractionResult.PASS;
        }
        boolean bl = canChannel = this.m_8105_(itemStack) > 0;
        if (!canChannel || player.m_6047_()) {
            ToolData toolData = this.getToolData(itemStack);
            Collection tools = toolData.getValues().stream().filter(tool -> toolData.getLevel(tool) > 0).sorted(player.m_6047_() ? Comparator.comparing(ToolAction::name).reversed() : Comparator.comparing(ToolAction::name)).collect(Collectors.toList());
            for (ToolAction tool2 : tools) {
                BlockState block = blockState.getToolModifiedState(context, tool2, false);
                if (block == null) continue;
                if (ToolActions.AXE_STRIP.equals(tool2)) {
                    world.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (ToolActions.AXE_SCRAPE.equals(tool2)) {
                    world.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.m_5898_(player, 3005, pos, 0);
                } else if (ToolActions.AXE_WAX_OFF.equals(tool2)) {
                    world.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    world.m_5898_(player, 3005, pos, 0);
                } else if (ToolActions.HOE_DIG.equals(tool2)) {
                    world.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else if (ToolActions.SHOVEL_DIG.equals(tool2)) {
                    world.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    SoundEvent sound = blockState.getSoundType((LevelReader)world, pos, (Entity)player).m_56778_();
                    world.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (!world.f_46443_) {
                    world.m_7731_(pos, block, 11);
                    this.applyDamage(this.blockDestroyDamage, context.m_43722_(), (LivingEntity)player);
                    this.applyUsageEffects((LivingEntity)player, itemStack, 2.0);
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (tools.contains(TetraToolActions.dowse) && this.dowseBlock(player, world, blockState, pos)) {
                this.applyDamage(this.blockDestroyDamage, itemStack, (LivingEntity)player);
                this.applyUsageEffects((LivingEntity)player, itemStack, 2.0);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            int denailingLevel = this.getEffectLevel(itemStack, ItemEffect.denailing);
            if (denailingLevel > 0 && (double)player.m_36403_(0.0f) > 0.9 && this.denailBlock(player, world, pos, hand, facing)) {
                this.applyDamage(this.blockDestroyDamage, itemStack, (LivingEntity)player);
                this.applyUsageEffects((LivingEntity)player, itemStack, 2.0);
                player.m_36334_();
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        int jabLevel;
        ItemStack itemStack = player.m_21120_(hand);
        if (this.m_8105_(itemStack) > 0) {
            player.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        if (InteractionHand.OFF_HAND.equals((Object)hand) && (jabLevel = this.getEffectLevel(itemStack, ItemEffect.jab)) > 0) {
            if (!world.f_46443_) {
                int howlingLevel;
                if (this.getEffectLevel(itemStack, ItemEffect.truesweep) > 0 && player.m_20096_() && !player.m_20142_()) {
                    SweepingEffect.truesweep(itemStack, (LivingEntity)player, true);
                }
                if ((howlingLevel = this.getEffectLevel(itemStack, ItemEffect.howling)) > 0) {
                    HowlingEffect.trigger(itemStack, (LivingEntity)player, howlingLevel);
                }
            }
            player.m_36335_().m_41524_((Item)this, (int)Math.round(this.getCooldownBase(itemStack) * 20.0));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity target, InteractionHand hand) {
        if (!(player.m_36335_().m_41519_((Item)this) || this.isBroken(itemStack) || this.m_8105_(itemStack) != 0 && !player.m_6047_())) {
            int jabLevel;
            int bashingLevel = this.getEffectLevel(itemStack, ItemEffect.bashing);
            if (bashingLevel > 0) {
                this.bashEntity(itemStack, bashingLevel, player, target);
                this.tickProgression((LivingEntity)player, itemStack, 2);
                this.applyDamage(2, itemStack, (LivingEntity)player);
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
            int pryLevel = this.getEffectLevel(itemStack, ItemEffect.pry);
            if (pryLevel > 0) {
                PryEffect.perform(player, hand, this, itemStack, pryLevel, target);
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
            if (InteractionHand.OFF_HAND.equals((Object)hand) && (jabLevel = this.getEffectLevel(itemStack, ItemEffect.jab)) > 0) {
                this.jabEntity(itemStack, jabLevel, player, target);
                if (!player.m_9236_().f_46443_) {
                    int howlingLevel;
                    if (this.getEffectLevel(itemStack, ItemEffect.truesweep) > 0 && player.m_20096_() && !player.m_20142_()) {
                        SweepingEffect.truesweep(itemStack, (LivingEntity)player, true);
                    }
                    if ((howlingLevel = this.getEffectLevel(itemStack, ItemEffect.howling)) > 0) {
                        HowlingEffect.trigger(itemStack, (LivingEntity)player, howlingLevel);
                    }
                }
                this.tickProgression((LivingEntity)player, itemStack, 2);
                this.applyDamage(2, itemStack, (LivingEntity)player);
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public boolean itemInteractionForEntitySecondary(ItemStack itemStack, Player player, LivingEntity target, InteractionHand hand) {
        int bashingLevel = this.getEffectLevel(itemStack, ItemEffect.bashing);
        if (bashingLevel > 0) {
            this.bashEntity(itemStack, bashingLevel, player, target);
            this.tickProgression((LivingEntity)player, itemStack, 2);
            this.applyDamage(2, itemStack, (LivingEntity)player);
            return true;
        }
        return false;
    }

    public AbilityUseResult hitEntity(ItemStack itemStack, Player player, LivingEntity target, double damageMultiplier, float knockbackBase, float knockbackMultiplier) {
        return this.hitEntity(itemStack, player, target, damageMultiplier, 0.0, knockbackBase, knockbackMultiplier);
    }

    public AbilityUseResult hitEntity(ItemStack itemStack, Player player, LivingEntity target, double damageMultiplier, double damageBonus, float knockbackBase, float knockbackMultiplier) {
        float targetModifier = EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)target.m_6336_());
        float critMultiplier = Optional.ofNullable(ForgeHooks.getCriticalHit((Player)player, (Entity)target, (boolean)false, (float)1.5f)).map(CriticalHitEvent::getDamageModifier).orElse(Float.valueOf(1.0f)).floatValue();
        double damage = (1.0 + this.getAbilityBaseDamage(itemStack) + (double)targetModifier) * (double)critMultiplier * damageMultiplier + damageBonus;
        boolean success = target.m_6469_(player.m_269291_().m_269075_(player), (float)damage);
        if (success) {
            EnchantmentHelper.m_44823_((LivingEntity)target, (Entity)player);
            EffectHelper.applyEnchantmentHitEffects(itemStack, target, (LivingEntity)player);
            ItemEffectHandler.applyHitEffects(itemStack, target, (LivingEntity)player);
            float knockbackFactor = knockbackBase + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)itemStack);
            target.m_147240_((double)(knockbackFactor * knockbackMultiplier), player.m_20185_() - target.m_20185_(), player.m_20189_() - target.m_20189_());
            if (targetModifier > 1.0f) {
                player.m_5700_((Entity)target);
                return AbilityUseResult.magicCrit;
            }
            if (critMultiplier > 1.0f) {
                player.m_5704_((Entity)target);
                return AbilityUseResult.crit;
            }
            return AbilityUseResult.hit;
        }
        return AbilityUseResult.fail;
    }

    public void jabEntity(ItemStack itemStack, int jabLevel, Player player, LivingEntity target) {
        AbilityUseResult result = this.hitEntity(itemStack, player, target, (float)jabLevel / 100.0f, 0.5f, 0.2f);
        if (result == AbilityUseResult.crit) {
            player.m_20193_().m_5594_(player, target.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.3f);
        } else {
            player.m_20193_().m_5594_(player, target.m_20183_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.3f);
        }
        player.m_36335_().m_41524_((Item)this, (int)Math.round(this.getCooldownBase(itemStack) * 20.0));
    }

    public void bashEntity(ItemStack itemStack, int bashingLevel, Player player, LivingEntity target) {
        AbilityUseResult result = this.hitEntity(itemStack, player, target, 1.0, bashingLevel + (player.m_20142_() ? 1 : 0), 0.5f);
        if (result != AbilityUseResult.fail) {
            double stunDuration = this.getEffectEfficiency(itemStack, ItemEffect.bashing);
            if (stunDuration > 0.0) {
                target.m_7292_(new MobEffectInstance((MobEffect)StunPotionEffect.instance, (int)Math.round(stunDuration * 20.0), 0, false, false));
            }
            player.m_20193_().m_5594_(player, target.m_20183_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 0.7f);
        } else {
            player.m_20193_().m_5594_(player, target.m_20183_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 0.7f);
        }
        player.m_36335_().m_41524_((Item)this, (int)Math.round(this.getCooldownBase(itemStack) * 20.0));
    }

    public void throwItem(Player player, ItemStack stack, int riptideLevel, float cooldownBase) {
        Level world = player.m_9236_();
        if (!world.f_46443_) {
            this.applyDamage(1, stack, (LivingEntity)player);
            this.applyUsageEffects((LivingEntity)player, stack, 1.0);
            ThrownModularItemEntity projectileEntity = new ThrownModularItemEntity(world, player, stack);
            if (player.m_150110_().f_35937_) {
                projectileEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            } else {
                player.m_150109_().m_36057_(stack);
            }
            projectileEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.5f + (float)riptideLevel * 0.5f, 1.0f);
            world.m_7967_((Entity)projectileEntity);
            if (this instanceof ModularSingleHeadedItem) {
                world.m_6269_(null, (Entity)projectileEntity, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (this instanceof ModularShieldItem) {
                world.m_6269_(null, (Entity)projectileEntity, SoundEvents.f_11798_, SoundSource.PLAYERS, 1.0f, 2.0f);
            } else {
                world.m_6269_(null, (Entity)projectileEntity, SoundEvents.f_11941_, SoundSource.PLAYERS, 1.0f, 0.7f);
            }
        }
        player.m_36335_().m_41524_((Item)this, Math.round(cooldownBase * 20.0f));
    }

    public void causeRiptideEffect(Player player, int riptideLevel) {
        float yaw = player.m_146908_();
        float pitch = player.m_146909_();
        float x = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float y = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float velocityMultiplier = 3.0f * ((1.0f + (float)riptideLevel) / 4.0f);
        player.m_5997_((double)(x *= velocityMultiplier), (double)(y *= velocityMultiplier), (double)(z *= velocityMultiplier));
        player.m_204079_(20);
        if (player.m_20096_()) {
            player.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999, 0.0));
        }
        SoundEvent soundEvent = riptideLevel >= 3 ? SoundEvents.f_12519_ : (riptideLevel == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
        player.m_9236_().m_6269_(null, (Entity)player, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
    }

    public boolean dowseBlock(Player player, Level world, BlockState blockState, BlockPos pos) {
        if (blockState.m_60734_() instanceof CampfireBlock && ((Boolean)blockState.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            CampfireBlock.m_152749_((Entity)player, (LevelAccessor)world, (BlockPos)pos, (BlockState)blockState);
            if (!world.m_5776_()) {
                world.m_5898_(null, 1009, pos, 0);
                world.m_7731_(pos, (BlockState)blockState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), 11);
            }
            return true;
        }
        return false;
    }

    public boolean denailBlock(Player player, Level world, BlockPos pos, InteractionHand hand, Direction facing) {
        boolean success;
        ItemStack itemStack = player.m_21120_(hand);
        if (!player.m_36204_(pos.m_121945_(facing), facing, itemStack)) {
            return false;
        }
        BlockState blockState = world.m_8055_(pos);
        if (ItemModularHandheld.canDenail(blockState) && (success = EffectHelper.breakBlock(world, player, player.m_21120_(hand), pos, blockState, true, false))) {
            player.m_36334_();
            return true;
        }
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        if (this.getEffectLevel(stack, ItemEffect.blocking) > 0) {
            return UseAnim.BLOCK;
        }
        if (this.getEffectLevel(stack, ItemEffect.throwable) > 0 || EnchantmentHelper.m_44932_((ItemStack)stack) > 0) {
            return UseAnim.SPEAR;
        }
        ChargedAbilityEffect ability = this.getChargeableAbility(stack);
        if (ability != null) {
            return ability.getPose();
        }
        return super.m_6164_(stack);
    }

    public float getBlockProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        int blockingLevel = this.getEffectLevel(itemStack, ItemEffect.blocking);
        if (blockingLevel > 0 && blockingLevel < 16) {
            return Optional.ofNullable(entity).filter(e -> e.m_21212_() > 0).filter(e -> itemStack.equals(e.m_21211_())).map(e -> Float.valueOf((float)e.m_21212_() * 1.0f / (float)this.m_8105_(itemStack))).orElse(Float.valueOf(0.0f)).floatValue();
        }
        return 0.0f;
    }

    public boolean isThrowing(ItemStack itemStack, @Nullable LivingEntity entity) {
        return UseAnim.SPEAR.equals((Object)this.m_6164_(itemStack)) && Optional.ofNullable(entity).filter(e -> itemStack.equals(e.m_21211_())).map(e -> e.m_21212_() > 0).orElse(false) != false;
    }

    public boolean isBlocking(ItemStack itemStack, @Nullable LivingEntity entity) {
        return UseAnim.BLOCK.equals((Object)this.m_6164_(itemStack)) && Optional.ofNullable(entity).filter(e -> itemStack.equals(e.m_21211_())).map(e -> e.m_21212_() > 0).orElse(false) != false;
    }

    public boolean isShield(ItemStack itemStack) {
        return this.getEffectLevel(itemStack, ItemEffect.blocking) > 0;
    }

    public void onShieldDisabled(Player player, ItemStack itemStack) {
        player.m_36335_().m_41524_((Item)this, (int)(this.getCooldownBase(itemStack) * 20.0 * 0.75));
    }

    public boolean canDisableShield(ItemStack itemStack, ItemStack shieldStack, LivingEntity target, LivingEntity attacker) {
        return this.getEffectLevel(itemStack, ItemEffect.shieldbreaker) > 0;
    }

    public int m_8105_(ItemStack itemStack) {
        int blockingLevel = this.getEffectLevel(itemStack, ItemEffect.blocking);
        if (blockingLevel > 0) {
            int duration = blockingLevel * 20;
            return blockingLevel < 16 ? duration : 72000;
        }
        if (this.getEffectLevel(itemStack, ItemEffect.throwable) > 0 || EnchantmentHelper.m_44932_((ItemStack)itemStack) > 0 || Arrays.stream(abilities).anyMatch(ability -> ability.isAvailable(this, itemStack))) {
            return 72000;
        }
        return 0;
    }

    public ItemStack m_5922_(ItemStack itemStack, Level world, LivingEntity entity) {
        CastOptional.cast((Object)entity, Player.class).ifPresent(player -> {
            int blockingLevel = this.getEffectLevel(itemStack, ItemEffect.blocking);
            if (blockingLevel > 0) {
                double blockingCooldown = this.getEffectEfficiency(itemStack, ItemEffect.blocking);
                if (blockingCooldown > 0.0) {
                    player.m_36335_().m_41524_((Item)this, (int)Math.round(blockingCooldown * this.getCooldownBase(itemStack) * 20.0));
                }
                if (player.m_6047_() && world.f_46443_) {
                    this.onPlayerStoppedUsingSecondary(itemStack, world, entity, 0);
                }
            }
        });
        return super.m_5922_(itemStack, world, entity);
    }

    public void m_5551_(ItemStack itemStack, Level world, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int ticksUsed = this.m_8105_(itemStack) - timeLeft;
            double cooldownBase = this.getCooldownBase(itemStack);
            int blockingLevel = this.getEffectLevel(itemStack, ItemEffect.blocking);
            int throwingLevel = this.getEffectLevel(itemStack, ItemEffect.throwable);
            int riptideLevel = EnchantmentHelper.m_44932_((ItemStack)itemStack);
            if (blockingLevel > 0) {
                double blockingCooldown = this.getEffectEfficiency(itemStack, ItemEffect.blocking);
                if (blockingCooldown > 0.0) {
                    player.m_36335_().m_41524_((Item)this, (int)Math.round(blockingCooldown * cooldownBase * 20.0));
                }
                if (player.m_6047_()) {
                    if (ticksUsed >= 10 && riptideLevel > 0 && player.m_20070_()) {
                        this.causeRiptideEffect(player, riptideLevel);
                    } else if (ticksUsed >= 10 && throwingLevel > 0) {
                        this.throwItem(player, itemStack, riptideLevel, (float)cooldownBase);
                    } else if (world.f_46443_) {
                        this.onPlayerStoppedUsingSecondary(itemStack, world, entityLiving, timeLeft);
                    }
                }
            } else {
                if (riptideLevel > 0 && ticksUsed >= 10 && player.m_20070_()) {
                    this.causeRiptideEffect(player, riptideLevel);
                } else if (throwingLevel > 0 && ticksUsed >= 10) {
                    this.throwItem(player, itemStack, riptideLevel, (float)cooldownBase);
                }
                if (world.f_46443_) {
                    this.triggerChargedAbility(itemStack, world, entityLiving, ticksUsed);
                }
            }
        }
    }

    public ChargedAbilityEffect getChargeableAbility(ItemStack itemStack) {
        return Arrays.stream(abilities).filter(ability -> ability.canCharge(this, itemStack)).findFirst().orElse(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void triggerChargedAbility(ItemStack itemStack, Level world, LivingEntity entity, int ticksUsed) {
        if (entity instanceof Player) {
            HitResult rayTrace = Minecraft.m_91087_().f_91077_;
            LivingEntity target = Optional.ofNullable(rayTrace).filter(rayTraceResult -> rayTraceResult.m_6662_() == HitResult.Type.ENTITY).map(rayTraceResult -> ((EntityHitResult)rayTraceResult).m_82443_()).flatMap(hitEntity -> CastOptional.cast((Object)hitEntity, LivingEntity.class)).orElse(null);
            BlockPos targetPos = Optional.ofNullable(rayTrace).filter(rayTraceResult -> rayTraceResult.m_6662_() == HitResult.Type.BLOCK).map(rayTraceResult -> ((BlockHitResult)rayTraceResult).m_82425_()).orElse(null);
            Vec3 hitVec = Optional.ofNullable(rayTrace).map(HitResult::m_82450_).orElse(null);
            InteractionHand activeHand = entity.m_7655_();
            TetraMod.packetHandler.sendToServer((AbstractPacket)new ChargedAbilityPacket(target, targetPos, hitVec, activeHand, ticksUsed));
            ItemModularHandheld.handleChargedAbility((Player)entity, activeHand, target, targetPos, hitVec, ticksUsed);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerStoppedUsingSecondary(ItemStack itemStack, Level world, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            LivingEntity target = Optional.ofNullable(Minecraft.m_91087_().f_91077_).filter(rayTraceResult -> rayTraceResult.m_6662_() == HitResult.Type.ENTITY).map(rayTraceResult -> ((EntityHitResult)rayTraceResult).m_82443_()).flatMap(hitEntity -> CastOptional.cast((Object)hitEntity, LivingEntity.class)).orElse(null);
            InteractionHand activeHand = entity.m_7655_();
            TetraMod.packetHandler.sendToServer((AbstractPacket)new SecondaryAbilityPacket(target, activeHand));
            ItemModularHandheld.handleSecondaryAbility(player, activeHand, target);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        EffectHelper.setCooledAttackStrength(player, player.m_36403_(0.5f));
        EffectHelper.setSprinting((LivingEntity)player, player.m_20142_());
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return AttributeHelper.emptyMap;
        }
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getAttributeModifiersCached(itemStack);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return (Multimap)this.getAttributeModifiersCached(itemStack).entries().stream().filter(entry -> ((Attribute)entry.getKey()).equals(Attributes.f_22284_) || ((Attribute)entry.getKey()).equals(Attributes.f_22285_)).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, ArrayListMultimap::create));
        }
        return AttributeHelper.emptyMap;
    }

    public double getAbilityBaseDamage(ItemStack itemStack) {
        return this.getAttributeValue(itemStack, Attributes.f_22281_) + 1.0;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getEffectAttributes(ItemStack itemStack) {
        ArrayListMultimap result = ArrayListMultimap.create();
        Optional.of(this.getCounterWeightBonus(itemStack)).filter(bonus -> bonus > 0.0).map(bonus -> new AttributeModifier("counterweight", bonus.doubleValue(), AttributeModifier.Operation.ADDITION)).ifPresent(arg_0 -> ItemModularHandheld.lambda$getEffectAttributes$24((Multimap)result, arg_0));
        return result;
    }

    public double getCounterWeightBonus(ItemStack itemStack) {
        int counterWeightLevel = this.getEffectLevel(itemStack, ItemEffect.counterweight);
        if (counterWeightLevel > 0) {
            int integrityCost = IModularItem.getIntegrityCost(itemStack);
            return ItemModularHandheld.getCounterWeightBonus(counterWeightLevel, integrityCost);
        }
        return 0.0;
    }

    public double getCooldownBase(ItemStack itemStack) {
        return 1.0 / Math.max(0.1, this.getAttributeValue(itemStack, Attributes.f_22283_, 4.0) + this.getCounterWeightBonus(itemStack));
    }

    public Set<ToolAction> getToolActions(ItemStack stack) {
        if (!this.isBroken(stack)) {
            return this.getToolLevels(stack).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
        }
        return Collections.emptySet();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        if (this.getToolActions(stack).contains(toolAction)) {
            return true;
        }
        if (ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction) && this.isShield(stack)) {
            return true;
        }
        return super.canPerformAction(stack, toolAction);
    }

    public int getHarvestTier(ItemStack stack, ToolAction tool) {
        int toolTier;
        if (!this.isBroken(stack) && (toolTier = this.getToolLevel(stack, tool)) > 0) {
            return toolTier - 1;
        }
        return -1;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (!state.m_60834_()) {
            return true;
        }
        return ToolActionHelper.getAppropriateTools(state).stream().map(requiredTool -> this.getHarvestTier(stack, (ToolAction)requiredTool)).map(TierHelper::getTier).filter(Objects::nonNull).anyMatch(tier -> TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state));
    }

    public float m_8102_(ItemStack itemStack, BlockState blockState) {
        if (!this.isBroken(itemStack)) {
            float speed = (float)ItemModularHandheld.getAttackSpeedHarvestModifier(this.getAttributeValue(itemStack, Attributes.f_22283_, 4.0));
            Set<ToolAction> appropriateTools = ToolActionHelper.getAppropriateTools(blockState);
            speed = !appropriateTools.isEmpty() ? (speed *= (float)appropriateTools.stream().mapToDouble(tool -> this.getToolEfficiency(itemStack, (ToolAction)tool)).max().orElse(0.0)) : (speed *= this.getToolActions(itemStack).stream().filter(toolAction -> ToolActionHelper.isEffectiveOn(toolAction, blockState)).map(toolAction -> Float.valueOf(this.getToolEfficiency(itemStack, (ToolAction)toolAction))).max(Comparator.naturalOrder()).orElse(Float.valueOf(0.0f)).floatValue());
            if (this.getToolLevel(itemStack, TetraToolActions.cut) > 0) {
                if (blockState.m_60734_().equals(Blocks.f_50033_)) {
                    speed *= 10.0f;
                }
                if (blockState.m_60734_().equals(Blocks.f_50571_)) {
                    speed = 30.0f;
                }
            }
            if (speed < 1.0f) {
                return 1.0f;
            }
            return speed;
        }
        return 1.0f;
    }

    @Override
    public ItemStack onCraftConsume(ItemStack providerStack, ItemStack targetStack, Player player, ToolAction tool, int toolLevel, boolean consumeResources) {
        if (consumeResources) {
            this.applyDamage(toolLevel, providerStack, (LivingEntity)player);
            this.applyUsageEffects((LivingEntity)player, providerStack, 10 + toolLevel * 5);
        }
        return super.onCraftConsume(providerStack, targetStack, player, tool, toolLevel, consumeResources);
    }

    @Override
    public ItemStack onActionConsume(ItemStack providerStack, ItemStack targetStack, Player player, ToolAction tool, int toolLevel, boolean consumeResources) {
        if (consumeResources) {
            this.applyDamage(toolLevel, providerStack, (LivingEntity)player);
            this.applyUsageEffects((LivingEntity)player, providerStack, 4 + toolLevel * 3);
        }
        return super.onCraftConsume(providerStack, targetStack, player, tool, toolLevel, consumeResources);
    }

    private static /* synthetic */ void lambda$getEffectAttributes$24(Multimap result, AttributeModifier modifier) {
        result.put((Object)Attributes.f_22283_, (Object)modifier);
    }
}

