/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.hammer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseRenderer;
import se.mickelus.tetra.blocks.forged.hammer.HammerEffect;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlock;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.salvage.InteractiveBlockOverlay;
import se.mickelus.tetra.blocks.salvage.TileBlockInteraction;
import se.mickelus.tetra.items.cell.ThermalCellItem;
import se.mickelus.tetra.module.ItemModuleMajor;

@ParametersAreNonnullByDefault
public class HammerBaseBlock
extends TetraBlock
implements IInteractiveBlock,
EntityBlock {
    public static final String identifier = "hammer_base";
    public static final DirectionProperty facingProp = HorizontalDirectionalBlock.f_54117_;
    public static final String qualityImprovementKey = "quality";
    public static final BlockInteraction[] interactions = new BlockInteraction[]{new TileBlockInteraction<HammerBaseBlockEntity>(TetraToolActions.pry, 1, Direction.EAST, 5.0f, 11.0f, 10.0f, 12.0f, HammerBaseBlockEntity.class, tile -> tile.getEffect(true) != null, (world, pos, blockState, player, hand, hitFace) -> HammerBaseBlock.removeModule(world, pos, blockState, player, hand, hitFace, true)), new TileBlockInteraction<HammerBaseBlockEntity>(TetraToolActions.pry, 1, Direction.WEST, 5.0f, 11.0f, 10.0f, 12.0f, HammerBaseBlockEntity.class, tile -> tile.getEffect(false) != null, (world, pos, blockState, player, hand, hitFace) -> HammerBaseBlock.removeModule(world, pos, blockState, player, hand, hitFace, false))};
    @ObjectHolder(registryName="block", value="tetra:hammer_base")
    public static HammerBaseBlock instance;

    public HammerBaseBlock() {
        super(ForgedBlockCommon.propertiesNotSolid);
    }

    public static boolean removeModule(Level world, BlockPos pos, BlockState blockState, @Nullable Player player, @Nullable InteractionHand hand, Direction hitFace, boolean isA) {
        ItemStack moduleStack = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).map(te -> te.removeModule(isA)).map(ItemStack::new).orElse(null);
        if (moduleStack != null && !world.f_46443_) {
            if (player != null && player.m_150109_().m_36054_(moduleStack)) {
                player.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
            } else {
                HammerBaseBlock.m_49840_((Level)world, (BlockPos)pos.m_121945_(hitFace), (ItemStack)moduleStack);
            }
        }
        world.m_5594_(player, pos, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.5f, 0.6f);
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{facingProp});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)HammerBaseBlockEntity.type.get()), HammerBaseRenderer::new);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add(ForgedBlockCommon.locationTooltip);
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"block.multiblock_hint.1x2x1").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public boolean isFunctional(Level world, BlockPos pos) {
        return TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).map(HammerBaseBlockEntity::isFunctional).orElse(false);
    }

    public void consumeFuel(Level world, BlockPos pos) {
        TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).ifPresent(HammerBaseBlockEntity::consumeFuel);
    }

    public int getHammerLevel(Level world, BlockPos pos) {
        return TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).map(HammerBaseBlockEntity::getHammerLevel).orElse(0);
    }

    public ItemStack applyCraftEffects(Level world, BlockPos pos, BlockState blockState, ItemStack targetStack, String slot, boolean isReplacing, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        int preciseLevel;
        if (consumeResources) {
            this.consumeFuel(world, pos);
        }
        if (isReplacing && (preciseLevel = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).map(te -> te.getEffectLevel(HammerEffect.precise)).orElse(0).intValue()) > 0) {
            ItemStack upgradedStack = targetStack.m_41777_();
            ItemModuleMajor.addImprovement(upgradedStack, slot, qualityImprovementKey, preciseLevel);
            return upgradedStack;
        }
        return targetStack;
    }

    public ItemStack applyActionEffects(Level world, BlockPos pos, BlockState blockState, ItemStack targetStack, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        if (consumeResources) {
            this.consumeFuel(world, pos);
        }
        return targetStack;
    }

    private Map<String, String> getAdvancementData(Level world, BlockPos pos) {
        return TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).map(tile -> {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("functional", String.valueOf(tile.isFunctional()));
            Optional.ofNullable(tile.getEffect(true)).ifPresent(module -> result.put("moduleA", module.toString()));
            Optional.ofNullable(tile.getEffect(false)).ifPresent(module -> result.put("moduleB", module.toString()));
            return result;
        }).orElseGet(Collections::emptyMap);
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        Direction blockFacing = (Direction)blockState.m_61143_((Property)facingProp);
        HammerBaseBlockEntity te = TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).orElse(null);
        ItemStack heldStack = player.m_21120_(hand);
        Direction facing = rayTraceResult.m_82434_();
        if (te == null) {
            return InteractionResult.FAIL;
        }
        if (blockFacing.m_122434_().equals((Object)facing.m_122434_())) {
            int slotIndex;
            int n = slotIndex = blockFacing.equals((Object)facing) ? 0 : 1;
            if (te.hasCellInSlot(slotIndex)) {
                ItemStack cell = te.removeCellFromSlot(slotIndex);
                if (player.m_150109_().m_36054_(cell)) {
                    player.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                } else {
                    HammerBaseBlock.m_49840_((Level)world, (BlockPos)pos.m_121945_(facing), (ItemStack)cell);
                }
                world.m_5594_(player, pos, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.5f, 0.6f);
                if (!player.m_9236_().f_46443_) {
                    BlockUseCriterion.trigger((ServerPlayer)player, world.m_8055_(pos), ItemStack.f_41583_, this.getAdvancementData(world, pos));
                }
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
            if (heldStack.m_41720_() instanceof ThermalCellItem) {
                te.putCellInSlot(heldStack, slotIndex);
                player.m_21008_(hand, ItemStack.f_41583_);
                world.m_5594_(player, pos, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.5f, 0.5f);
                if (!player.m_9236_().f_46443_) {
                    BlockUseCriterion.trigger((ServerPlayer)player, world.m_8055_(pos), heldStack, this.getAdvancementData(world, pos));
                }
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
        } else {
            boolean success;
            boolean isA = Rotation.CLOCKWISE_90.m_55954_(blockFacing).equals((Object)facing);
            if (te.getEffect(isA) == null && (success = te.setModule(isA, heldStack.m_41720_()))) {
                if (!player.m_9236_().f_46443_) {
                    BlockUseCriterion.trigger((ServerPlayer)player, world.m_8055_(pos), heldStack, this.getAdvancementData(world, pos));
                }
                world.m_5594_(player, pos, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.5f, 0.5f);
                heldStack.m_41774_(1);
                if (world.f_46443_) {
                    InteractiveBlockOverlay.markDirty();
                }
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
        }
        return BlockInteraction.attemptInteraction(world, world.m_8055_(pos), pos, player, hand, rayTraceResult);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.m_60734_())) {
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).ifPresent(tile -> {
                for (int i = 0; i < 2; ++i) {
                    if (!tile.hasCellInSlot(i)) continue;
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tile.getStackInSlot(i).m_41777_());
                }
                Stream.of(tile.getEffect(true), tile.getEffect(false)).filter(Objects::nonNull).map(HammerEffect::getItem).map(ItemStack::new).forEach(stack -> Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack));
            });
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).ifPresent(BlockEntity::m_7651_);
        }
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState state, Direction face, Collection<ToolAction> tools) {
        return (BlockInteraction[])Arrays.stream(interactions).filter(interaction -> interaction.isPotentialInteraction(world, pos, state, (Direction)state.m_61143_((Property)facingProp), face, tools)).toArray(BlockInteraction[]::new);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        TileEntityOptional.from((BlockGetter)world, (BlockPos)currentPos, HammerBaseBlockEntity.class).ifPresent(HammerBaseBlockEntity::updateRedstonePower);
        if (Direction.DOWN.equals((Object)facing) && !HammerHeadBlock.instance.equals(facingState.m_60734_())) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState headState = (BlockState)HammerHeadBlock.instance.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos.m_7495_()).m_76152_() == Fluids.f_76193_));
        world.m_7731_(pos.m_7495_(), headState, 3);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_((Property)facingProp, (Comparable)context.m_8125_().m_122424_());
        }
        return null;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, HammerBaseBlockEntity.class).ifPresent(HammerBaseBlockEntity::updateRedstonePower);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)facingProp, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)facingProp)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)facingProp)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HammerBaseBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return HammerBaseBlock.getTicker(entityType, (BlockEntityType)HammerBaseBlockEntity.type.get(), (lvl, pos, blockState, tile) -> tile.tick(lvl, pos, blockState));
    }
}

