/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketRelicTweak {
    private final BlockPos pos;
    private final String ability;
    private final Operation operation;

    public PacketRelicTweak(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.ability = buf.m_130277_();
        this.operation = (Operation)buf.m_130066_(Operation.class);
    }

    public PacketRelicTweak(BlockPos pos, String ability, Operation operation) {
        this.pos = pos;
        this.ability = ability;
        this.operation = operation;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.ability);
        buf.m_130068_((Enum)this.operation);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            BlockEntity patt1561$temp = world.m_7702_(this.pos);
            if (!(patt1561$temp instanceof ResearchingTableTile)) {
                return;
            }
            ResearchingTableTile tile = (ResearchingTableTile)patt1561$temp;
            ItemStack stack = tile.getStack();
            Item patt1712$temp = stack.m_41720_();
            if (!(patt1712$temp instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)patt1712$temp;
            AbilityData entry = relic.getAbilityData(this.ability);
            if (entry == null) {
                return;
            }
            switch (this.operation) {
                case INCREASE: {
                    if (!relic.mayPlayerUpgrade((Player)player, stack, this.ability)) break;
                    player.m_6756_(-relic.getUpgradeRequiredExperience(stack, this.ability));
                    relic.setAbilityPoints(stack, this.ability, relic.getAbilityPoints(stack, this.ability) + 1);
                    relic.addPoints(stack, -entry.getRequiredPoints());
                    break;
                }
                case REROLL: {
                    if (!relic.mayPlayerReroll((Player)player, stack, this.ability)) break;
                    player.m_6756_(-relic.getRerollRequiredExperience(this.ability));
                    relic.randomizeStats(stack, this.ability);
                    break;
                }
                case RESET: {
                    if (!relic.mayPlayerReset((Player)player, stack, this.ability)) break;
                    player.m_6756_(-relic.getResetRequiredExperience(stack, this.ability));
                    relic.addPoints(stack, relic.getAbilityPoints(stack, this.ability) * entry.getRequiredPoints());
                    relic.setAbilityPoints(stack, this.ability, 0);
                }
            }
            tile.setStack(stack);
            tile.m_6596_();
            world.m_7260_(this.pos, world.m_8055_(this.pos), world.m_8055_(this.pos), 3);
        });
        return true;
    }

    public static enum Operation {
        RESET,
        INCREASE,
        REROLL;

    }
}

