/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.entities.LifeEssenceEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class HolyLocketItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("steal").stat(StatData.builder("radius").initialValue(2.0, 6.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("amount").initialValue(0.1, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().build()).loot(LootData.builder().entry(LootCollections.DESERT).build()).build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        model.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        model.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        model.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85841_(2.0f, 2.0f, 2.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.m_171576_().m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-8.0f, -1.15f, -4.15f, 16.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)1.15f, (float)0.0f));
        bone.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.6096f, -0.8646f, -0.2f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0571f, (float)6.6447f, (float)-4.9f, (float)0.0f, (float)0.0f, (float)0.2568f));
        bone.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(12, 18).m_171488_(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.15f)), PartPose.m_171423_((float)0.0877f, (float)6.2393f, (float)-5.2f, (float)0.0f, (float)0.0f, (float)0.7854f));
        bone.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0322f, -2.5947f, -0.225f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.05f)), PartPose.m_171423_((float)0.0571f, (float)6.6447f, (float)-4.9f, (float)0.0f, (float)0.0f, (float)-0.004f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @Mod.EventBusSubscriber
    static class Events {
        Events() {
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHealEvent event) {
            LivingEntity entity = event.getEntity();
            Level level = entity.m_20193_();
            for (Player player : level.m_45976_(Player.class, entity.m_20191_().m_82400_(32.0))) {
                IRelicItem relic;
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get());
                Item item = stack.m_41720_();
                if (!(item instanceof IRelicItem) || (relic = (IRelicItem)item).getAbilityValue(stack, "steal", "radius") < player.m_20182_().m_82554_(entity.m_20182_()) || entity.m_20149_().equals(player.m_20149_())) continue;
                float amount = (float)((double)event.getAmount() * relic.getAbilityValue(stack, "steal", "amount"));
                LifeEssenceEntity essence = new LifeEssenceEntity((LivingEntity)player, amount);
                essence.m_146884_(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
                essence.m_5602_((Entity)player);
                level.m_7967_((Entity)essence);
                if (event.getAmount() >= 1.0f) {
                    relic.spreadExperience((LivingEntity)player, stack, 1 + Math.round(amount));
                }
                event.setAmount(event.getAmount() - amount);
            }
        }
    }
}

