/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.SlotContext;

public class MagicMirrorItem
extends RelicItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("teleport").stat(StatData.builder("distance").initialValue(500.0, 1000.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("cooldown").initialValue(60.0, 120.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).style(StyleData.builder().background(Backgrounds.CAVE).build()).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_36335_().m_41519_((Item)ItemRegistry.MAGIC_MIRROR.get()) || worldIn.m_5776_()) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)playerIn;
        Pair<ServerLevel, Vec3> data = this.getHomePos(serverPlayer, false);
        if (!this.canTeleport(serverPlayer, data, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        if (world.m_5776_() || !(entity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entity;
        Pair<ServerLevel, Vec3> data = this.getHomePos(player, true);
        if (!this.canTeleport(player, data, stack)) {
            return stack;
        }
        Vec3 pos = (Vec3)data.getRight();
        this.spreadExperience((LivingEntity)player, stack, (int)(1L + Math.round(player.m_20182_().m_82554_(new Vec3(pos.m_7096_(), player.m_20186_(), pos.m_7094_())) * DimensionType.m_63908_((DimensionType)player.m_9236_().m_6042_(), (DimensionType)((ServerLevel)data.getLeft()).m_6042_())) / 50L));
        player.m_8999_((ServerLevel)data.getLeft(), pos.m_7096_() + 0.5, pos.m_7098_() + 1.0, pos.m_7094_() + 0.5, player.m_146908_(), player.m_146909_());
        if (!player.m_7500_()) {
            player.m_36335_().m_41524_(stack.m_41720_(), (int)Math.round(this.getAbilityValue(stack, "teleport", "cooldown") * 20.0));
        }
        world.m_5594_(null, player.m_20183_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return stack;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float radius = (float)count * 0.075f;
        double extraY = entity.m_20186_() + 1.5 - Math.log(((float)count + (float)this.m_8105_(stack) * 0.075f) * 0.1f);
        RandomSource random = level.m_213780_();
        Color color = switch (level.m_46472_().m_135782_().m_135815_()) {
            case "overworld" -> new Color(75, 150, 255);
            case "the_nether" -> new Color(150, 0, 0);
            case "the_end" -> new Color(100, 0, 200);
            default -> new Color(50, 150, 0);
        };
        for (int i = 0; i < 5; ++i) {
            float angle = 0.01f * (float)(count * 3 + i * 125);
            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + entity.m_20185_();
            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + entity.m_20189_();
            serverLevel.m_8767_((ParticleOptions)ParticleUtils.constructSimpleSpark(color, Math.max(0.2f, (float)(this.m_8105_(stack) - count) * 0.015f), 40, 0.92f), extraX, extraY, extraZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        serverLevel.m_8767_((ParticleOptions)ParticleUtils.constructSimpleSpark(color, (float)(this.m_8105_(stack) - count) * 0.005f, 10 + random.m_188503_(50), 0.95f), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() * 0.5f), entity.m_20189_(), (int)((float)(this.m_8105_(stack) - count) * 0.5f), 0.25, (double)(entity.m_20206_() * 0.4f), 0.25, (double)0.025f);
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack pStack) {
        return 40;
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    @Nullable
    private Pair<ServerLevel, Vec3> getHomePos(ServerPlayer player, boolean useAnchor) {
        if (player.m_9236_().m_5776_()) {
            return null;
        }
        BlockPos pos = player.m_8961_();
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return null;
        }
        ServerLevel world = player.m_20194_().m_129880_(player.m_8963_());
        if (world == null || pos == null) {
            return null;
        }
        return Player.m_36130_((ServerLevel)world, (BlockPos)pos, (float)player.m_8962_(), (boolean)true, (!useAnchor ? 1 : 0) != 0).map(vec3 -> Pair.of((Object)world, (Object)vec3)).orElse(null);
    }

    private boolean canTeleport(ServerPlayer player, Pair<ServerLevel, Vec3> data, ItemStack stack) {
        if (data == null) {
            return false;
        }
        Vec3 pos = (Vec3)data.getRight();
        ServerLevel level = (ServerLevel)data.getLeft();
        return !(player.m_20182_().m_82554_(new Vec3(pos.m_7096_(), player.m_20186_(), pos.m_7094_())) * DimensionType.m_63908_((DimensionType)player.m_9236_().m_6042_(), (DimensionType)level.m_6042_()) > this.getAbilityValue(stack, "teleport", "distance"));
    }

    @Mod.EventBusSubscriber
    public static class ServerEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Player player;
            Item item = (Item)ItemRegistry.MAGIC_MIRROR.get();
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || !(player = (Player)livingEntity).m_6117_() || player.m_21205_().m_41720_() != item && player.m_21206_().m_41720_() != item) {
                return;
            }
            player.m_5810_();
            player.m_36335_().m_41524_(item, 20);
        }
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onFovUpdate(ComputeFovModifierEvent event) {
            Player player = event.getPlayer();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (stack.m_41720_() != ItemRegistry.MAGIC_MIRROR.get() || !player.m_6117_()) {
                return;
            }
            int time = player.m_21252_();
            if (time > 0) {
                event.setNewFovModifier(event.getNewFovModifier() - (float)time * 0.02f);
            }
        }
    }
}

