/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;

public class SolidSnowballEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> SIZE = SynchedEntityData.m_135353_(SolidSnowballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public void setSize(int amount) {
        this.m_20088_().m_135381_(SIZE, (Object)amount);
    }

    public int getSize() {
        return (Integer)this.m_20088_().m_135370_(SIZE);
    }

    public SolidSnowballEntity(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SolidSnowballEntity(Level level) {
        super((EntityType)EntityRegistry.SOLID_SNOWBALL.get(), level);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.f_19797_ > 300) {
            this.m_146870_();
        }
        if ((level = this.m_9236_()).m_5776_()) {
            return;
        }
        float scale = (float)this.getSize() * 0.0035f;
        ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_175821_, this.f_19854_, this.f_19855_ + (double)(this.m_20206_() / 2.0f), this.f_19856_, 3, (double)scale, (double)scale, (double)scale, (double)0.025f);
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos pos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_280555_()) {
            return;
        }
        this.m_146870_();
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity entity;
        block11: {
            block10: {
                Entity entity2;
                if (this.m_9236_().m_5776_() || !((entity2 = result.m_82443_()) instanceof LivingEntity)) break block10;
                entity = (LivingEntity)entity2;
                if (this.m_19749_() == null || !entity.m_20149_().equals(this.m_19749_().m_20149_())) break block11;
            }
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio(this.m_19749_(), (Item)ItemRegistry.WOOL_MITTEN.get());
        Item item = stack.m_41720_();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            boolean mayContinue = false;
            float damage = (float)((double)this.getSize() * relic.getAbilityValue(stack, "mold", "damage"));
            Entity entity3 = this.m_19749_();
            if (entity3 instanceof Player) {
                Player player = (Player)entity3;
                if (EntityUtils.hurt(entity, this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)player), damage)) {
                    mayContinue = true;
                }
            } else if (entity.m_6469_(this.m_9236_().m_269111_().m_269425_(), damage)) {
                mayContinue = true;
            }
            if (mayContinue) {
                entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.STUN.get(), (int)Math.round((double)this.getSize() * relic.getAbilityValue(stack, "mold", "stun")) * 20, 0, true, false));
            }
        }
        this.m_146870_();
    }

    public void onRemovedFromWorld() {
        ParticleUtils.createBall((ParticleOptions)ParticleTypes.f_175821_, this.m_20182_(), this.m_9236_(), 1 + this.getSize() / 10, 0.1f + (float)this.getSize() * 0.005f);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio(owner, (Item)ItemRegistry.WOOL_MITTEN.get());
        Item item = stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)((float)this.getSize() / 15.0f)))) {
            if (entity.m_20149_().equals(owner.m_20149_())) continue;
            entity.m_146917_((int)(100L + Math.round((double)this.getSize() * relic.getAbilityValue(EntityUtils.findEquippedCurio(owner, (Item)ItemRegistry.WOOL_MITTEN.get()), "mold", "freeze"))));
        }
        if (owner instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)owner;
            relic.spreadExperience(entity, stack, (int)Math.floor((float)this.getSize() / 5.0f));
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12474_, SoundSource.MASTER, 1.0f, 0.5f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIZE, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setSize(compound.m_128451_("Size"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("Size", (float)this.getSize());
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

