/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class ShadowGlaiveEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.m_135353_(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TARGET = SynchedEntityData.m_135353_(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> BOUNCED_ENTITIES = SynchedEntityData.m_135353_(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String TAG_BOUNCES_AMOUNT = "bounces";
    private static final String TAG_TARGET_UUID = "target";
    private static final String TAG_BOUNCED_ENTITIES = "entities";
    private boolean isBounced = false;
    private LivingEntity target;
    private ItemStack stack = ItemStack.f_41583_;

    public ShadowGlaiveEntity(EntityType<? extends ShadowGlaiveEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public ShadowGlaiveEntity(Level world, LivingEntity throwerIn) {
        super((EntityType)EntityRegistry.SHADOW_GLAIVE.get(), throwerIn, world);
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
        if (target != null) {
            this.f_19804_.m_135381_(TARGET, (Object)target.m_20148_().toString());
        }
    }

    private void locateNearestTarget() {
        Item item = this.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        if ((double)((Integer)this.f_19804_.m_135370_(BOUNCES)).intValue() >= relic.getAbilityValue(this.stack, "glaive", TAG_BOUNCES_AMOUNT)) {
            this.m_146870_();
            return;
        }
        List<String> bouncedEntities = Arrays.asList(((String)this.f_19804_.m_135370_(BOUNCED_ENTITIES)).split(","));
        List entitiesAround = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(relic.getAbilityValue(this.stack, "glaive", "radius")));
        if ((entitiesAround = entitiesAround.stream().filter(entity -> !bouncedEntities.contains(entity.m_20148_().toString())).filter(EntitySelector.f_20406_).filter(entity -> {
            Entity patt3476$temp = this.m_19749_();
            if (!(patt3476$temp instanceof Player)) {
                return false;
            }
            Player player = (Player)patt3476$temp;
            return !entity.m_20149_().equals(player.m_20149_()) && !EntityUtils.isAlliedTo((Entity)player, (Entity)entity);
        }).filter(entity -> entity.m_142582_((Entity)this)).sorted(Comparator.comparing(entity -> entity.m_20182_().m_82554_(this.m_20182_()))).collect(Collectors.toList())).isEmpty()) {
            if (this.isBounced) {
                this.m_146870_();
            }
            return;
        }
        LivingEntity target = null;
        for (LivingEntity entity2 : entitiesAround) {
            if (entity2 == null || !entity2.m_6084_()) continue;
            target = entity2;
            break;
        }
        if (target == null || !target.m_6084_()) {
            this.m_146870_();
            return;
        }
        this.setTarget(target);
    }

    public void m_8119_() {
        super.m_8119_();
        Item item = this.stack.m_41720_();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        for (int i = 0; i < 3; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleUtils.constructSimpleSpark(new Color(255, this.f_19796_.m_188503_(100), 255), 0.2f, 30, 0.99f), this.f_19854_, this.f_19855_, this.f_19856_, (double)(MathUtils.randomFloat(this.f_19796_) * 0.01f), 0.0, (double)(MathUtils.randomFloat(this.f_19796_) * 0.01f));
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!this.isBounced && this.target == null && this.f_19797_ > 30) {
            this.m_146870_();
        }
        if (this.f_19797_ > 300) {
            this.m_146870_();
        }
        if (this.target == null && this.f_19797_ > 10 && this.f_19797_ % 2 == 0) {
            this.locateNearestTarget();
            return;
        }
        if (this.target != null && this.target.m_6084_()) {
            EntityUtils.moveTowardsPosition((Entity)this, this.target.m_20182_().m_82520_(0.0, (double)this.target.m_20206_() * 0.5, 0.0), 0.75);
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.3, 3.0, 0.3))) {
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof Player) {
                    Player player = (Player)entity2;
                    if (entity.m_20149_().equals(player.m_20149_())) continue;
                }
                String bouncedEntitiesString = (String)this.f_19804_.m_135370_(BOUNCED_ENTITIES);
                List<String> bouncedEntities = Arrays.asList(bouncedEntitiesString.split(","));
                float damage = (float)relic.getAbilityValue(this.stack, "glaive", "damage");
                Entity entity3 = this.m_19749_();
                if (entity3 instanceof Player) {
                    Player player = (Player)entity3;
                    if (EntityUtils.hurt(entity, this.m_9236_().m_269111_().m_269390_((Entity)this, (Entity)player), damage)) {
                        relic.spreadExperience((LivingEntity)player, this.stack, 1);
                    }
                } else {
                    entity.m_6469_(this.m_9236_().m_269111_().m_269425_(), damage);
                }
                if (!bouncedEntities.contains(entity.m_20148_().toString())) {
                    this.f_19804_.m_135381_(BOUNCED_ENTITIES, (Object)(bouncedEntitiesString + "," + entity.m_20148_()));
                    this.f_19804_.m_135381_(BOUNCES, (Object)((Integer)this.f_19804_.m_135370_(BOUNCES) + 1));
                    this.isBounced = true;
                }
                this.locateNearestTarget();
                break;
            }
        } else {
            this.locateNearestTarget();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BOUNCES, (Object)0);
        this.f_19804_.m_135372_(TARGET, (Object)"");
        this.f_19804_.m_135372_(BOUNCED_ENTITIES, (Object)"");
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128405_(TAG_BOUNCES_AMOUNT, ((Integer)this.f_19804_.m_135370_(BOUNCES)).intValue());
        tag.m_128359_(TAG_TARGET_UUID, (String)this.f_19804_.m_135370_(TARGET));
        tag.m_128359_(TAG_BOUNCED_ENTITIES, (String)this.f_19804_.m_135370_(BOUNCED_ENTITIES));
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        this.f_19804_.m_135381_(BOUNCES, (Object)tag.m_128451_(TAG_BOUNCES_AMOUNT));
        this.f_19804_.m_135381_(TARGET, (Object)tag.m_128461_(TAG_TARGET_UUID));
        this.f_19804_.m_135381_(BOUNCED_ENTITIES, (Object)tag.m_128461_(TAG_BOUNCED_ENTITIES));
        super.m_7378_(tag);
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_7139_() {
        return 0.0f;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }
}

