/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.back.ArrowQuiverItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;

public class ArrowRainEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(ArrowRainEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int delay;
    private int duration;
    private ItemStack quiver;

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.m_20088_().m_135381_(RADIUS, (Object)Float.valueOf(radius));
    }

    public ArrowRainEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        Entity arrow2;
        super.m_8119_();
        RandomSource random = this.m_9236_().m_213780_();
        ParticleUtils.createCyl((ParticleOptions)ParticleUtils.constructSimpleSpark(new Color(255, 255, 255), 0.2f, 1, 1.0f), this.m_20182_(), this.m_9236_(), this.getRadius(), 0.2f);
        if (!this.m_9236_().m_5776_() && (this.getDelay() == 0 || this.getRadius() == 0.0f || this.quiver.m_41619_() || this.getDuration() < this.f_19797_)) {
            this.m_146870_();
            return;
        }
        AABB area = this.m_20191_().m_82377_((double)this.getRadius(), (double)(this.getRadius() * 2.0f), (double)this.getRadius());
        for (Entity arrow2 : this.m_9236_().m_45976_(AbstractArrow.class, area)) {
            List<LivingEntity> entities;
            if (arrow2.m_20096_() || (entities = this.m_9236_().m_45976_(LivingEntity.class, area).stream().filter(arg_0 -> ArrowRainEntity.lambda$tick$0((AbstractArrow)arrow2, arg_0)).filter(entry -> entry.m_20182_().m_82554_(this.m_20182_()) <= (double)this.getRadius()).filter(entry -> !EntityUtils.isAlliedTo(this.m_19749_(), (Entity)entry)).sorted(Comparator.comparing(arg_0 -> ArrowRainEntity.lambda$tick$3((AbstractArrow)arrow2, arg_0))).toList()).isEmpty()) continue;
            LivingEntity target = entities.get(0);
            Vec3 motion = target.m_20182_().m_82546_(arrow2.m_20182_()).m_82541_().m_82490_((double)0.1f);
            arrow2.m_20256_(arrow2.m_20184_().m_82520_(motion.m_7096_(), 0.0, motion.m_7094_()));
        }
        arrow2 = this.m_19749_();
        if (!(arrow2 instanceof Player)) {
            return;
        }
        Player player = (Player)arrow2;
        if (this.f_19797_ % this.getDelay() == 0) {
            List<ItemStack> arrows = ArrowQuiverItem.getArrows(this.quiver);
            if (arrows.isEmpty()) {
                this.m_146870_();
                return;
            }
            int i = 0;
            while ((double)i < Math.ceil(this.getRadius() / 5.0f)) {
                ItemStack arrow3 = arrows.get(random.m_188503_(arrows.size()));
                Item item = arrow3.m_41720_();
                if (item instanceof ArrowItem) {
                    ArrowItem item2 = (ArrowItem)item;
                    AbstractArrow entity = item2.m_6394_(this.m_9236_(), arrow3, (LivingEntity)player);
                    double theta = (double)(MathUtils.randomFloat(random) * 2.0f) * Math.PI;
                    double r = random.m_188501_() * this.getRadius();
                    double xOff = r * Math.cos(theta);
                    double zOff = r * Math.sin(theta);
                    entity.m_6034_(this.m_20185_() + xOff, this.m_20186_() + 15.0 + (double)this.getRadius(), this.m_20189_() + zOff);
                    entity.getPersistentData().m_128379_("relics_arrow_rain", true);
                    entity.m_20334_(0.0, -0.5, 0.0);
                    entity.m_5602_((Entity)player);
                    entity.f_36697_ = 1100;
                    entity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    this.m_9236_().m_7967_((Entity)entity);
                    if (!this.m_9236_().m_5776_()) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 5, 0.0, 0.0, 0.0, (double)0.1f);
                    }
                    this.m_9236_().m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.ARROW_RAIN.get(), SoundSource.MASTER, 2.0f, 1.0f + random.m_188501_() * 0.25f);
                }
                ++i;
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(5.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.setRadius(compound.m_128457_("radius"));
        this.setDelay(compound.m_128451_("delay"));
        this.setDuration(compound.m_128451_("duration"));
        this.quiver = ItemStack.m_41712_((CompoundTag)compound.m_128469_("quiver"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("radius", this.getRadius());
        compound.m_128350_("delay", (float)this.getDelay());
        compound.m_128350_("duration", (float)this.getDuration());
        this.quiver.m_41739_(compound.m_128469_("quiver"));
    }

    protected float m_7139_() {
        return 0.0f;
    }

    public boolean m_6063_() {
        return false;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public ItemStack getQuiver() {
        return this.quiver;
    }

    public void setQuiver(ItemStack quiver) {
        this.quiver = quiver;
    }

    private static /* synthetic */ Double lambda$tick$3(AbstractArrow arrow, LivingEntity entry) {
        return entry.m_20182_().m_82554_(arrow.m_20182_());
    }

    private static /* synthetic */ boolean lambda$tick$0(AbstractArrow arrow, LivingEntity entry) {
        return entry.m_142582_((Entity)arrow);
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onProjectileImpact(ProjectileImpactEvent event) {
            block3: {
                block2: {
                    LivingEntity entity;
                    EntityHitResult result;
                    AbstractArrow arrow;
                    Entity entity2 = event.getEntity();
                    if (!(entity2 instanceof AbstractArrow) || !(arrow = (AbstractArrow)entity2).getPersistentData().m_128471_("relics_arrow_rain") || !((entity2 = arrow.m_19749_()) instanceof Player)) break block2;
                    Player player = (Player)entity2;
                    entity2 = event.getRayTraceResult();
                    if (entity2 instanceof EntityHitResult && (entity2 = (result = (EntityHitResult)entity2).m_82443_()) instanceof LivingEntity && EntityUtils.isAlliedTo((Entity)player, (Entity)(entity = (LivingEntity)entity2))) break block3;
                }
                return;
            }
            event.setCanceled(true);
        }
    }
}

