/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.VoidVortex;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VoidVortexSpell
extends Spell {
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(((Double)GCSpellConfig.VoidVortexRadius.get()).doubleValue());
    }

    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.VoidVortexCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.VoidVortexDuration.get();
    }

    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)GoetySounds.VOID_PREPARE_SPELL.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.VoidVortexCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        float radius = (float)spellStat.getRadius();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            range += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RANGE.get()), (LivingEntity)caster);
            radius += (float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RADIUS.get()), (LivingEntity)caster) / 2.0f;
        }
        HitResult hitResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        Vec3 vec3 = hitResult.m_82450_();
        LivingEntity target = this.getTarget(caster);
        if (target != null) {
            vec3 = target.m_20182_();
        }
        double tx = vec3.f_82479_;
        double ty = vec3.f_82480_;
        double tz = vec3.f_82481_;
        double minY = Math.min(ty, caster.m_20186_());
        double maxY = Math.max(ty, caster.m_20186_()) + 1.0;
        float angle = (float)Mth.m_14136_((double)(tz - caster.m_20189_()), (double)(tx - caster.m_20185_()));
        this.spawnVortex(caster, tx, tz, minY, maxY, angle, radius);
    }

    private void spawnVortex(LivingEntity caster, double x, double z, double minY, double maxY, float rotation, float radius) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = caster.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)caster.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!caster.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = caster.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)caster.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            VoidVortex voidVortex = new VoidVortex(caster.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, caster, 300);
            voidVortex.setRadius(radius);
            caster.m_9236_().m_7967_((Entity)voidVortex);
        }
    }
}

