/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.AbyssOrb;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AbyssalOrbsSpell
extends Spell {
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(((Double)GCSpellConfig.AbyssalOrbsRadius.get()).doubleValue());
    }

    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.AbyssalOrbsCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.AbyssalOrbsDuration.get();
    }

    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)CataclysmSounds.LEVIATHAN_IDLE.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.AbyssalOrbsCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        Vec3 motion;
        int i;
        int potency = spellStat.getPotency();
        float radius = (float)spellStat.getRadius();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.POTENCY.get()), (LivingEntity)caster);
            radius += (float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RADIUS.get()), (LivingEntity)caster) / 2.0f;
        }
        for (i = 0; i < 3; ++i) {
            motion = new Vec3(0.5, -1.25, 0.5).m_82524_(-((float)(120 * i)) * ((float)Math.PI / 180));
            this.shootAbyssOrb(caster, motion.f_82479_, motion.f_82480_, motion.f_82481_, potency, radius);
        }
        for (i = 0; i < 6; ++i) {
            motion = new Vec3(1.0, -0.75, 1.0).m_82524_(-((float)(60 * i)) * ((float)Math.PI / 180));
            this.shootAbyssOrb(caster, motion.f_82479_, motion.f_82480_, motion.f_82481_, potency, radius);
        }
        if (this.rightStaff(staff)) {
            for (i = 0; i < 6; ++i) {
                motion = new Vec3(1.0, 0.0, 1.0).m_82524_(-((float)(60 * i)) * ((float)Math.PI / 180));
                this.shootAbyssOrb(caster, motion.f_82479_, motion.f_82480_, motion.f_82481_, potency, radius);
            }
            for (i = 0; i < 6; ++i) {
                motion = new Vec3(1.0, 0.75, 1.0).m_82524_(-((float)(60 * i)) * ((float)Math.PI / 180));
                this.shootAbyssOrb(caster, motion.f_82479_, motion.f_82480_, motion.f_82481_, potency, radius);
            }
            for (i = 0; i < 3; ++i) {
                motion = new Vec3(0.5, 1.25, 0.5).m_82524_(-((float)(120 * i)) * ((float)Math.PI / 180));
                this.shootAbyssOrb(caster, motion.f_82479_, motion.f_82480_, motion.f_82481_, potency, radius);
            }
        }
        worldIn.m_6269_(null, (Entity)caster, (SoundEvent)CataclysmSounds.LEVIATHAN_STUN_ROAR.get(), this.getSoundSource(), 2.0f, 0.8f);
    }

    public void shootAbyssOrb(LivingEntity caster, double xMotion, double yMotion, double zMotion, int potency, float radius) {
        AbyssOrb fireball = this.getTarget(caster) != null ? new AbyssOrb(caster, xMotion, yMotion, zMotion, caster.m_9236_(), ((Double)GCSpellConfig.AbyssalOrbsDamage.get()).floatValue() + (float)potency, this.getTarget(caster)) : new AbyssOrb(caster, xMotion, yMotion, zMotion, caster.m_9236_(), ((Double)GCSpellConfig.AbyssalOrbsDamage.get()).floatValue() + (float)potency, null);
        fireball.setRadius(radius);
        fireball.m_6034_(fireball.m_20185_(), caster.m_20188_(), fireball.m_20189_());
        fireball.setUp(40);
        if (!caster.m_9236_().f_46443_) {
            caster.m_9236_().m_7967_((Entity)fireball);
        }
    }
}

