/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.projectiles;

import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.client.particle.StormParticle;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Sandstorm
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> CREATOR_ID = SynchedEntityData.m_135353_(Sandstorm.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(Sandstorm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> OFFSET = SynchedEntityData.m_135353_(Sandstorm.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.m_135353_(Sandstorm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Sandstorm.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> EXTRA_DAMAGE = SynchedEntityData.m_135353_(Sandstorm.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public AnimationState SpawnAnimationState = new AnimationState();
    public AnimationState DespawnAnimationState = new AnimationState();

    public Sandstorm(EntityType<? extends Sandstorm> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public Sandstorm(Level worldIn, double x, double y, double z, int lifespan, float offset, UUID casterIn) {
        this((EntityType<? extends Sandstorm>)((EntityType)GCEntityType.SANDSTORM.get()), worldIn);
        this.setCreatorEntityUUID(casterIn);
        this.setLifespan(lifespan);
        this.m_6034_(x, y, z);
        this.setState(1);
        this.setOffset(offset);
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntities.SANDSTORM.get()).m_20676_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        this.updateMotion();
        Entity owner = this.getCreatorEntity();
        if (owner != null && !owner.m_6084_()) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_) {
            float ran = 0.04f;
            float r = 0.89f + this.f_19796_.m_188501_() * ran;
            float g = 0.85f + this.f_19796_.m_188501_() * ran;
            float b = 0.69f + this.f_19796_.m_188501_() * ran * 1.5f;
            this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.75f + this.f_19796_.m_188501_() * 0.6f, 3.75f + this.f_19796_.m_188501_() * 0.6f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.5f + this.f_19796_.m_188501_() * 0.45f, 3.0f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.25f + this.f_19796_.m_188501_() * 0.45f, 2.25f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 1.25f + this.f_19796_.m_188501_() * 0.45f, 1.25f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            if (this.getState() == 1 && this.getLifespan() < 295) {
                this.setState(0);
            }
            if (this.getState() == 0 && this.getLifespan() < 10) {
                this.setState(2);
            }
        }
        if (!this.m_20067_() && this.m_9236_().f_46443_) {
            Cataclysm.PROXY.playWorldSound((Object)this, (byte)2);
        }
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
            MobEffectInstance effectinstance;
            if (entity == owner || !entity.m_6084_() || entity.m_20147_()) continue;
            float damage = ((Double)GCSpellConfig.SandstormDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue() + this.getExtraDamage();
            if (this.f_19797_ % 3 != 0) continue;
            if (owner == null) {
                boolean flag = entity.m_6469_(this.m_269291_().m_269425_(), damage);
                if (!flag) continue;
                effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTCURSE_OF_DESERT.get(), 200, 0);
                entity.m_7292_(effectinstance);
                continue;
            }
            if (MobUtil.areAllies((Entity)owner, (Entity)entity)) {
                return;
            }
            boolean flag = entity.m_6469_(this.m_269291_().m_269104_((Entity)this, owner), damage);
            if (!flag) continue;
            effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTCURSE_OF_DESERT.get(), 200, 0);
            entity.m_7292_(effectinstance);
        }
        this.setLifespan(this.getLifespan() - 1);
        if (this.getLifespan() <= 0) {
            Cataclysm.PROXY.clearSoundCacheFor((Entity)this);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)i);
    }

    public float getOffset() {
        return ((Float)this.f_19804_.m_135370_(OFFSET)).floatValue();
    }

    public void setOffset(float i) {
        this.f_19804_.m_135381_(OFFSET, (Object)Float.valueOf(i));
    }

    public float getExtraDamage() {
        return ((Float)this.f_19804_.m_135370_(EXTRA_DAMAGE)).floatValue();
    }

    public void setExtraDamage(float pDamage) {
        this.f_19804_.m_135381_(EXTRA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public UUID getCreatorEntityUUID() {
        return ((Optional)this.f_19804_.m_135370_(CREATOR_ID)).orElse(null);
    }

    public void setCreatorEntityUUID(UUID id) {
        this.f_19804_.m_135381_(CREATOR_ID, Optional.ofNullable(id));
    }

    public Entity getCreatorEntity() {
        Level level;
        UUID uuid = this.getCreatorEntityUUID();
        if (uuid != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_8791_(uuid);
        }
        return null;
    }

    private void updateMotion() {
        Entity owner = this.getCreatorEntity();
        if (owner != null) {
            Vec3 center = owner.m_20182_().m_82520_(0.0, 0.0, 0.0);
            float radius = 6.0f;
            float speed = (float)this.f_19797_ * 0.04f;
            float offset = this.getOffset();
            Vec3 orbit = new Vec3(center.f_82479_ + Math.cos(speed + offset) * (double)radius, center.f_82480_, center.f_82481_ + Math.sin(speed + offset) * (double)radius);
            this.m_20219_(orbit);
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CREATOR_ID, Optional.empty());
        this.f_19804_.m_135372_(LIFESPAN, (Object)300);
        this.f_19804_.m_135372_(OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(EXTRA_DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "spawn")) {
            return this.SpawnAnimationState;
        }
        if (Objects.equals(input, "despawn")) {
            return this.DespawnAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.SpawnAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.DespawnAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.DespawnAnimationState.m_216973_();
        this.SpawnAnimationState.m_216973_();
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLifespan(compound.m_128451_("Lifespan"));
        if (compound.m_128403_("Owner")) {
            this.setCreatorEntityUUID(compound.m_128342_("Owner"));
        }
        if (compound.m_128441_("ExtraDamage")) {
            this.setExtraDamage(compound.m_128457_("ExtraDamage"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Lifespan", this.getLifespan());
        if (this.getCreatorEntityUUID() != null) {
            compound.m_128362_("Owner", this.getCreatorEntityUUID());
        }
        compound.m_128350_("ExtraDamage", this.getExtraDamage());
    }
}

