/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.projectiles;

import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.AbstractIgnisFireball;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.util.CustomExplosion.IgnisExplosion;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.PartEntity;

public class IgnisFireball
extends AbstractIgnisFireball {
    private static final EntityDataAccessor<Boolean> SOUL = SynchedEntityData.m_135353_(IgnisFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public IgnisFireball(EntityType<? extends IgnisFireball> type, Level level) {
        super(type, level);
    }

    public IgnisFireball(Level level, LivingEntity entity, double x, double y, double z) {
        super((EntityType<? extends AbstractHurtingProjectile>)((EntityType)GCEntityType.IGNIS_FIREBALL.get()), entity, x, y, z, level);
    }

    public IgnisFireball(Level worldIn, LivingEntity owner, @Nullable LivingEntity target) {
        this((EntityType<? extends IgnisFireball>)((EntityType)GCEntityType.IGNIS_FIREBALL.get()), worldIn);
        this.setOwner(owner);
        this.setTarget(target);
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntities.IGNIS_FIREBALL.get()).m_20676_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.timer == 0 || this.timer == -40) {
            if (this.getTarget() != null) {
                LivingEntity target = this.getTarget();
                float speed = this.isSoul() ? 0.25f : 0.2f;
                double dx = target.m_20185_() - this.m_20185_();
                double dy = target.m_20186_() + (double)(target.m_20206_() * 0.5f) - this.m_20186_();
                double dz = target.m_20189_() - this.m_20189_();
                double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                this.f_36813_ = (dx /= d) * (double)speed;
                this.f_36814_ = (dy /= d) * (double)speed;
                this.f_36815_ = (dz /= d) * (double)speed;
            } else {
                ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
                for (Entity entity1 : this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(16.0))) {
                    PartEntity partEntity;
                    Entity entity;
                    LivingEntity livingEntity = null;
                    if (entity1 instanceof PartEntity && (entity = (partEntity = (PartEntity)entity1).getParent()) instanceof LivingEntity) {
                        LivingEntity living;
                        livingEntity = living = (LivingEntity)entity;
                    } else if (entity1 instanceof LivingEntity) {
                        LivingEntity living;
                        livingEntity = living = (LivingEntity)entity1;
                    }
                    if (livingEntity == null || !MobUtil.ownedPredicate((Entity)this).test(livingEntity)) continue;
                    list.add(livingEntity);
                }
                list.sort(Comparator.comparingDouble(arg_0 -> ((IgnisFireball)this).m_20270_(arg_0)));
                if (list.stream().findFirst().isPresent()) {
                    LivingEntity livingEntity = (LivingEntity)list.stream().findFirst().get();
                    this.setTarget(livingEntity);
                }
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        LivingEntity shooter = this.getOwner();
        if (!this.m_9236_().f_46443_ && this.getFired()) {
            boolean flag;
            Entity entity = result.m_82443_();
            if (shooter instanceof LivingEntity) {
                LivingEntity owner = shooter;
                float damage = this.isSoul() ? 8.0f : 6.0f;
                damage += this.getExtraDamage();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    flag = entity.m_6469_(this.m_269291_().m_269299_((Entity)this, owner), damage + livingEntity.m_21233_() * 0.07f);
                } else {
                    flag = entity.m_6469_(this.m_269291_().m_269299_((Entity)this, owner), damage);
                }
                if (flag) {
                    this.m_19970_(owner, entity);
                    if (entity instanceof LivingEntity) {
                        owner.m_5634_(5.0f);
                    }
                }
            } else {
                flag = entity.m_6469_(this.m_269291_().m_269425_(), 6.0f + this.getExtraDamage());
            }
            IgnisExplosion explosion = new IgnisExplosion(this.m_9236_(), (Entity)this, null, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, true, Explosion.BlockInteraction.KEEP);
            explosion.m_46061_();
            explosion.finalizeExplosion(this.isSoul() ? 2 : 1, 0.35);
            this.m_146870_();
            if (flag && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                MobEffectInstance effectinstance1 = livingEntity.m_21124_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                int i = 1;
                if (effectinstance1 != null) {
                    i += effectinstance1.m_19564_();
                    livingEntity.m_6234_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
                } else {
                    --i;
                }
                i = Mth.m_14045_((int)i, (int)0, (int)4);
                MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), 200, i, false, false, true);
                livingEntity.m_7292_(effectinstance);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (!this.m_9236_().f_46443_ && this.getFired()) {
            IgnisExplosion explosion = new IgnisExplosion(this.m_9236_(), (Entity)this, (DamageSource)null, (ExplosionDamageCalculator)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, true, Explosion.BlockInteraction.KEEP);
            explosion.m_46061_();
            explosion.finalizeExplosion(this.isSoul() ? 2 : 1, 0.35);
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult ray) {
        HitResult.Type raytraceresult$type = ray.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)ray);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)ray);
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource p_37616_, float p_37617_) {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SOUL, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_soul", this.isSoul());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSoul(compound.m_128471_("is_soul"));
    }

    public boolean isSoul() {
        return (Boolean)this.f_19804_.m_135370_(SOUL);
    }

    public void setSoul(boolean IsSoul) {
        this.f_19804_.m_135381_(SOUL, (Object)IsSoul);
    }
}

