/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.undead.draugr;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.entity.etc.IShieldEntity;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;

public class RoyalDraugrServant
extends Summoned
implements IShieldEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    private int shieldCooldownTime = 0;

    public RoyalDraugrServant(EntityType<? extends Summoned> entity, Level world) {
        super(entity, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new Royal_DraugrAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WanderGoal((PathfinderMob)this, 1.0, 80.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.27f).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.RoyalDraugrDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.RoyalDraugrHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.RoyalDraugrArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, (double)0.1f);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.RoyalDraugrHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.RoyalDraugrArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.RoyalDraugrDamage.get()));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof RoyalDraugrServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.RoyalDraugrLimit.get();
    }

    public int xpReward() {
        return 7;
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "attack")) {
            return this.attackAnimationState;
        }
        if (Objects.equals(input, "attack2")) {
            return this.attack2AnimationState;
        }
        return Objects.equals(input, "idle") ? this.idleAnimationState : new AnimationState();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Entity entity = source.m_7640_();
        if (damage > 0.0f && this.canBlockDamageSource(source)) {
            this.m_7909_(damage);
            if (!source.m_269533_(DamageTypeTags.f_268524_) && entity instanceof LivingEntity) {
                this.m_6728_((LivingEntity)entity);
            }
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            return false;
        }
        return super.m_6469_(source, damage);
    }

    public int getShieldCooldownTime() {
        return this.shieldCooldownTime;
    }

    public void setShieldCooldownTime(int shieldCooldownTime) {
        this.shieldCooldownTime = shieldCooldownTime;
    }

    public boolean isShieldDisabled() {
        return this.shieldCooldownTime > 0;
    }

    public void disableShield(boolean guaranteeDisable) {
        float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (guaranteeDisable) {
            f += 0.75f;
        }
        if (this.f_19796_.m_188501_() < f) {
            this.shieldCooldownTime = 100;
            this.m_5810_();
            this.m_9236_().m_7605_((Entity)this, (byte)30);
            this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        }
    }

    protected void m_7909_(float p_36383_) {
        if (this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK) && p_36383_ >= 3.0f) {
            int i = 1 + Mth.m_14143_((float)p_36383_);
            InteractionHand interactionhand = this.m_7655_();
            this.f_20935_.m_41622_(i, (LivingEntity)this, p_219739_ -> p_219739_.m_21190_(interactionhand));
            if (this.f_20935_.m_41619_()) {
                this.m_5810_();
                if (interactionhand == InteractionHand.MAIN_HAND) {
                    this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                } else {
                    this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                }
                this.f_20935_ = ItemStack.f_41583_;
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
            }
        }
    }

    public boolean m_21254_() {
        return false;
    }

    protected void m_6728_(LivingEntity p_36295_) {
        super.m_6728_(p_36295_);
        if (p_36295_.m_21205_().canDisableShield(this.f_20935_, (LivingEntity)this, p_36295_)) {
            this.disableShield(true);
        }
    }

    public boolean isDraugrBlocking() {
        if (this.m_6117_() && !this.f_20935_.m_41619_()) {
            Item item = this.f_20935_.m_41720_();
            if (!this.f_20935_.canPerformAction(ToolActions.SHIELD_BLOCK)) {
                return false;
            }
            return item.m_8105_(this.f_20935_) - this.f_20936_ >= 5;
        }
        return false;
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        Vec3 vector3d2;
        AbstractArrow abstractarrow;
        Entity entity = damageSourceIn.m_7640_();
        boolean flag = false;
        if (entity instanceof AbstractArrow && (abstractarrow = (AbstractArrow)entity).m_36796_() > 0) {
            flag = true;
        }
        if (!damageSourceIn.m_269533_(DamageTypeTags.f_276146_) && this.isDraugrBlocking() && !flag && (vector3d2 = damageSourceIn.m_7270_()) != null) {
            Vec3 vector3d = this.m_20252_(1.0f);
            Vec3 vector3d1 = vector3d2.m_82505_(this.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, 0.0, vector3d1.f_82481_);
            return vector3d1.m_82526_(vector3d) < 0.0;
        }
        return false;
    }

    public void stopAllAnimationStates() {
        this.attackAnimationState.m_216973_();
        this.attack2AnimationState.m_216973_();
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 4) {
            if (this.f_19796_.m_188499_()) {
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                this.attack2AnimationState.m_216977_(this.f_19797_);
            }
        } else {
            super.m_7822_(p_219360_);
        }
    }

    public boolean m_7327_(Entity p_219472_) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        if (this.isDraugrBlocking()) {
            this.m_5810_();
            this.setShieldCooldownTime(30);
        }
        return super.m_7327_(p_219472_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        RandomSource randomsource = p_34088_.m_213780_();
        this.m_213945_(randomsource, p_34089_);
        this.m_213946_(randomsource, p_34089_);
        this.m_8061_(EquipmentSlot.OFFHAND, this.createSpawnShield());
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
        return spawngroupdata;
    }

    protected void m_213945_(RandomSource p_219059_, DifficultyInstance p_219060_) {
        this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon());
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    private ItemStack createSpawnWeapon() {
        return this.f_19796_.m_188499_() ? new ItemStack((ItemLike)CataclysmItems.BLACK_STEEL_AXE.get()) : new ItemStack((ItemLike)CataclysmItems.BLACK_STEEL_SWORD.get());
    }

    private ItemStack createSpawnShield() {
        return new ItemStack((ItemLike)CataclysmItems.BLACK_STEEL_TARGE.get());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(true, this.f_19797_);
        }
        if (this.shieldCooldownTime > 0) {
            --this.shieldCooldownTime;
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.DRAUGR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_IDLE.get();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
        Item item = itemstack.m_41720_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if ((itemstack.m_150930_(Items.f_42583_) || itemstack.m_204117_(Tags.Items.BONES)) && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                this.m_5634_(2.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (item == CataclysmItems.BLACK_STEEL_TARGE.get() && this.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
                this.m_8061_(EquipmentSlot.OFFHAND, itemstack.m_41777_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    static class Royal_DraugrAttackGoal
    extends Goal {
        protected final RoyalDraugrServant mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private final int attackInterval = 20;
        private long lastCanUseCheck;
        private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;

        public Royal_DraugrAttackGoal(RoyalDraugrServant p_25552_, double p_25553_, boolean p_25554_) {
            this.mob = p_25552_;
            this.speedModifier = p_25553_;
            this.followingTargetEvenIfNotSeen = p_25554_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long i = this.mob.m_9236_().m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
            if (this.mob.isDraugrBlocking()) {
                this.mob.m_5810_();
                this.mob.setShieldCooldownTime(60);
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                double d0 = this.mob.m_262793_(livingentity);
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if (!this.isShieldDisabled(this.mob) && this.mob.m_21206_().canPerformAction(ToolActions.SHIELD_BLOCK) && this.mob.m_217043_().m_188503_(6) == 0) {
                    this.mob.m_6672_(InteractionHand.OFF_HAND);
                }
                if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                    this.pathedTargetX = livingentity.m_20185_();
                    this.pathedTargetY = livingentity.m_20186_();
                    this.pathedTargetZ = livingentity.m_20189_();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    if (this.canPenalize) {
                        Node finalPathPoint;
                        this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                        this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                    }
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(livingentity, d0);
            }
        }

        public boolean isShieldDisabled(RoyalDraugrServant shieldUser) {
            return shieldUser.isShieldDisabled();
        }

        protected void checkAndPerformAttack(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.getAttackReachSqr(p_25557_);
            if (p_25558_ <= d0 && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                if (this.mob.isDraugrBlocking()) {
                    this.mob.m_5810_();
                    this.mob.setShieldCooldownTime(30);
                }
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)p_25557_);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return this.m_183277_(20);
        }

        protected double getAttackReachSqr(LivingEntity p_25556_) {
            float f = p_25556_.m_20205_();
            return f * 2.25f * f * 2.25f + p_25556_.m_20205_();
        }
    }
}

