/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.deepling;

import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.goety_cataclysm.common.entities.ally.deepling.DeeplingAnglerServant;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCMobsConfig;
import com.github.L_Ender.cataclysm.entity.AI.AnimalAIRandomSwimming;
import com.github.L_Ender.cataclysm.entity.etc.AquaticMoveController;
import com.github.L_Ender.cataclysm.entity.etc.path.SemiAquaticPathNavigator;
import com.github.L_Ender.cataclysm.entity.projectile.Lionfish_Spike_Entity;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.AnimationHandler;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class LionfishServant
extends Summoned
implements IAnimatedEntity {
    public static final Animation LIONFISH_BITE = Animation.create((int)19);
    private int animationTick;
    private Animation currentAnimation;
    public float prevOnLandProgress;
    public float onLandProgress;
    public float LayerBrightness;
    public float oLayerBrightness;
    public int LayerTicks;

    public LionfishServant(EntityType<? extends Summoned> monster, Level level) {
        super(monster, level);
        this.f_21342_ = new AquaticMoveController((PathfinderMob)this, 1.0f, 15.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new SemiAquaticPathNavigator((Mob)this, worldIn);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12289_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12292_;
    }

    protected SoundEvent m_7975_(DamageSource p_29628_) {
        return SoundEvents.f_12294_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12293_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new AnimationMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(4, (Goal)new AnimalAIRandomSwimming((PathfinderMob)this, 1.0, 12, 5){

            @Nullable
            protected Vec3 m_7037_() {
                return LionfishServant.this.isGuardingArea() ? this.randomBoundPos() : super.m_7037_();
            }

            public Vec3 randomBoundPos() {
                Vec3 vec3 = null;
                int range = IServant.GUARDING_RANGE / 2;
                for (int i = 0; i < 10; ++i) {
                    BlockPos blockPos = LionfishServant.this.getBoundPos().m_7918_(LionfishServant.this.m_217043_().m_216332_(-range, range), LionfishServant.this.m_217043_().m_216332_(-range, range), LionfishServant.this.m_217043_().m_216332_(-range, range));
                    if (LionfishServant.this.m_21573_() instanceof WaterBoundPathNavigation) {
                        if (!GoalUtils.m_148445_((PathfinderMob)LionfishServant.this, (BlockPos)blockPos)) continue;
                        vec3 = Vec3.m_82539_((Vec3i)blockPos);
                        break;
                    }
                    BlockPos blockPos1 = LandRandomPos.m_148518_((PathfinderMob)LionfishServant.this, (BlockPos)blockPos);
                    if (blockPos1 == null) continue;
                    vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                    break;
                }
                return vec3;
            }

            public boolean m_8036_() {
                if (!super.m_8036_()) {
                    return false;
                }
                return !LionfishServant.this.isStaying() && !LionfishServant.this.isCommanded() || LionfishServant.this.getTrueOwner() == null;
            }
        });
    }

    public void followGoal() {
        this.f_21345_.m_25352_(3, (Goal)new Summoned.FollowOwnerWaterGoal((Summoned)this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.LionfishDamage.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.LionfishArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.LionfishHealth.get()).doubleValue());
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.LionfishHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.LionfishArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.LionfishDamage.get()));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.45f;
    }

    public boolean canUpdateMove() {
        return true;
    }

    public boolean m_6469_(DamageSource p_32820_, float p_32821_) {
        LivingEntity livingentity;
        Entity entity;
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (!p_32820_.m_269533_(DamageTypeTags.f_268640_) && !p_32820_.m_276093_(DamageTypes.f_268440_) && (entity = p_32820_.m_7640_()) instanceof LivingEntity && (livingentity = (LivingEntity)entity).m_6469_(this.m_269291_().m_269374_((Entity)this), 1.0f)) {
            livingentity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 40, 0), (Entity)this);
        }
        return super.m_6469_(p_32820_, p_32821_);
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevOnLandProgress = this.onLandProgress;
        if (!this.m_20069_() && this.onLandProgress < 5.0f) {
            this.onLandProgress += 1.0f;
        }
        if (this.m_20069_() && this.onLandProgress > 0.0f) {
            this.onLandProgress -= 1.0f;
        }
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.m_9236_().f_46443_) {
            ++this.LayerTicks;
            this.LayerBrightness += (0.0f - this.LayerBrightness) * 0.8f;
        }
        if (this.m_6084_()) {
            Entity entity = this.m_21524_();
            if (entity instanceof DeeplingAnglerServant) {
                DeeplingAnglerServant anglerServant = (DeeplingAnglerServant)entity;
                anglerServant.setNoLionfish((Integer)GCMobsConfig.DeeplingAnglerCatchTime.get());
            }
            LivingEntity target = this.m_5448_();
            if (this.getAnimation() == LIONFISH_BITE && this.getAnimationTick() == 7) {
                this.m_5496_(SoundEvents.f_12228_, 0.4f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                if (target != null) {
                    float damage = (float)this.m_21133_(Attributes.f_22281_);
                    target.m_6469_(this.getServantAttack(), damage);
                }
            }
        }
    }

    public DamageSource getMobAttack() {
        return this.getTrueOwner() != null ? ModDamageSource.summonAttack((LivingEntity)this, (LivingEntity)this.getTrueOwner()) : this.m_269291_().m_269333_((LivingEntity)this);
    }

    protected void handleAirSupply(int p_30344_) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(p_30344_ - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 0.01f);
            }
        } else {
            this.m_20301_(1000);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public void m_21455_(boolean p_21456_, boolean p_21457_) {
        super.m_21455_(p_21456_, !(this.m_21524_() instanceof OwnableEntity) && p_21457_);
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        int shardCount = 6 + this.f_19796_.m_188503_(2);
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < shardCount; ++i) {
                float f = (float)(i + 1) / (float)shardCount * 360.0f;
                Lionfish_Spike_Entity shard = new Lionfish_Spike_Entity(this.m_9236_(), (LivingEntity)this);
                shard.m_6686_((double)(this.f_19796_.m_188501_() * 0.4f * 2.0f - 0.4f), (double)(this.f_19796_.m_188501_() * 0.25f + 0.1f), (double)(this.f_19796_.m_188501_() * 0.4f * 2.0f - 0.4f), 0.35f, 1.0f);
                this.m_9236_().m_7967_((Entity)shard);
            }
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    private boolean isLeashedToAngler() {
        return this.m_21524_() instanceof DeeplingAnglerServant;
    }

    public boolean m_6040_() {
        return true;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{LIONFISH_BITE, NO_ANIMATION};
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        OwnableEntity ownable;
        Entity entity;
        ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
        if (itemstack.m_204117_(Tags.Items.SHEARS) && this.m_21523_() && (entity = this.m_21524_()) instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() == pPlayer) {
            this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            this.m_21455_(true, false);
            this.setTrueOwner((LivingEntity)pPlayer);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static class AnimationMeleeAttackGoal
    extends MeleeAttackGoal {
        protected final LionfishServant mob;

        public AnimationMeleeAttackGoal(LionfishServant p_25552_, double p_25553_, boolean p_25554_) {
            super((PathfinderMob)p_25552_, p_25553_, p_25554_);
            this.mob = p_25552_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_);
            if (p_25558_ <= d0 && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.mob.setAnimation(LIONFISH_BITE);
            }
        }
    }
}

