/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.deepling;

import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.ally.deepling.AbstractDeeplingServant;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class DeeplingPriestServant
extends AbstractDeeplingServant {
    public static final Animation DEEPLING_MELEE = Animation.create((int)20);
    public static final Animation DEEPLING_BLIND = Animation.create((int)57);
    private int lightcooldown = 200;
    public static final int LIGHT_COOLDOWN = 200;
    private static final EntityDimensions SWIMMING_SIZE = new EntityDimensions(1.15f, 0.6f, false);

    public DeeplingPriestServant(EntityType<? extends AbstractDeeplingServant> entity, Level world) {
        super(entity, world);
        this.switchNavigator(false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new DeeplingLightGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AnimationMeleeAttackGoal(this, 1.0, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.27f).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.DeeplingPriestDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.DeeplingPriestHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.DeeplingPriestArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.25);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.DeeplingPriestHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.DeeplingPriestArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.DeeplingPriestDamage.get()));
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof DeeplingPriestServant;
    }

    public int getSummonLimit(LivingEntity caster) {
        return (Integer)GCSpellConfig.DeeplingCasterLimit.get();
    }

    public int xpReward() {
        return 10;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected void m_213945_(RandomSource p_219154_, DifficultyInstance p_219155_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)CataclysmItems.ATHAME.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        RandomSource randomsource = p_34088_.m_213780_();
        this.m_213945_(randomsource, p_34089_);
        return spawngroupdata;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, DEEPLING_MELEE, DEEPLING_BLIND};
    }

    private boolean isEntityLookingAt(LivingEntity looker, LivingEntity seen, double degree) {
        Vec3 Vector3d = looker.m_20252_(1.0f).m_82541_();
        Vec3 Vector3d1 = new Vec3(seen.m_20185_() - looker.m_20185_(), seen.m_20191_().f_82289_ + (double)seen.m_20192_() - (looker.m_20186_() + (double)looker.m_20192_()), seen.m_20189_() - looker.m_20189_());
        double d0 = Vector3d1.m_82553_();
        double d1 = Vector3d.m_82526_(Vector3d1 = Vector3d1.m_82541_());
        return d1 > 1.0 - (degree *= 1.0 + (double)looker.m_20270_((Entity)seen) * 0.1) / d0 && looker.m_142582_((Entity)seen);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.lightcooldown > 0) {
            --this.lightcooldown;
        }
        if (this.m_6084_()) {
            if (this.getAnimation() == DEEPLING_MELEE && this.getAnimationTick() == 5) {
                this.m_5496_((SoundEvent)CataclysmSounds.DEEPLING_SWING.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                if (target != null && this.m_20270_((Entity)target) < 3.0f) {
                    float damage = (float)this.m_21133_(Attributes.f_22281_);
                    if (target.m_6469_(this.getServantAttack(), damage)) {
                        ItemHelper.hurtAndBreak((ItemStack)this.m_21205_(), (int)1, (LivingEntity)this);
                    }
                }
            }
            if (this.getAnimation() == DEEPLING_BLIND) {
                if (this.getAnimationTick() == 18) {
                    this.m_5496_((SoundEvent)CataclysmSounds.DEEPLING_LIGHT.get(), 0.2f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                }
                if (this.getAnimationTick() > 18 && this.getAnimationTick() < 47) {
                    for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(7.0))) {
                        boolean flag;
                        if (MobUtil.areAllies((Entity)this, (Entity)entity) || !this.isEntityLookingAt(entity, (LivingEntity)this, 0.6) || !(flag = entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), (float)this.m_21133_(Attributes.f_22281_) * 0.7f))) continue;
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80));
                    }
                }
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.9f;
    }

    @Override
    public EntityDimensions getSwimmingSize() {
        return SWIMMING_SIZE;
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        ItemStack itemstack2 = this.m_21205_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_150930_((Item)CataclysmItems.ATHAME.get())) {
            this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
            this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
            this.m_21508_(EquipmentSlot.MAINHAND);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    static class DeeplingLightGoal
    extends Goal {
        private final DeeplingPriestServant angler;

        public DeeplingLightGoal(DeeplingPriestServant angler) {
            this.angler = angler;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.angler.m_5448_();
            return this.angler.lightcooldown <= 0 && this.angler.getAnimation() == IAnimatedEntity.NO_ANIMATION && target != null && this.angler.m_20280_((Entity)target) <= 64.0 && target.m_6084_() && this.angler.m_217043_().m_188501_() * 100.0f < 12.0f;
        }

        public void m_8056_() {
            super.m_8056_();
            this.angler.setAnimation(DEEPLING_BLIND);
            this.angler.lightcooldown = 200;
            this.angler.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class AnimationMeleeAttackGoal
    extends MeleeAttackGoal {
        protected final DeeplingPriestServant mob;

        public AnimationMeleeAttackGoal(DeeplingPriestServant p_25552_, double p_25553_, boolean p_25554_) {
            super((PathfinderMob)p_25552_, p_25553_, p_25554_);
            this.mob = p_25552_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_);
            if (p_25558_ <= d0 && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.mob.setAnimation(DEEPLING_MELEE);
            }
        }
    }
}

