/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.deepling;

import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.ally.deepling.AbstractDeeplingServant;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.entity.projectile.ThrownCoral_Bardiche_Entity;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DeeplingBruteServant
extends AbstractDeeplingServant {
    public static final Animation DEEPLING_BRUTE_TRIDENT_THROW = Animation.create((int)45);
    public static final Animation DEEPLING_BRUTE_MELEE = Animation.create((int)20);
    private int SpinAttackTicks;
    private static final EntityDataAccessor<Boolean> SPIN_ATTACK = SynchedEntityData.m_135353_(DeeplingBruteServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDimensions SWIMMING_SIZE = new EntityDimensions(1.3f, 0.7f, false);

    public DeeplingBruteServant(EntityType<? extends AbstractDeeplingServant> entity, Level world) {
        super(entity, world);
        this.f_21342_ = new AbstractDeeplingServant.DeeplingMoveControl(this, 2.0f);
        this.switchNavigator(false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new DeeplingBruteTridentShoot(this, 1.0, 15.0f));
        this.f_21345_.m_25352_(5, (Goal)new AbstractDeeplingServant.DeeplingGoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new AbstractDeeplingServant.DeeplingSwimUpGoal(this, 1.0, this.m_9236_().m_5736_()));
        this.f_21345_.m_25352_(3, (Goal)new AnimationMeleeAttackGoal(this, 1.1f, false));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.29f).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.DeeplingBruteDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.DeeplingBruteHealth.get()).doubleValue()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.DeeplingBruteArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.35);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.DeeplingBruteHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.DeeplingBruteArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.DeeplingBruteDamage.get()));
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof DeeplingBruteServant;
    }

    public int getSummonLimit(LivingEntity caster) {
        return (Integer)GCSpellConfig.DeeplingBruteLimit.get();
    }

    public int xpReward() {
        return 15;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPIN_ATTACK, (Object)false);
    }

    protected void m_213945_(RandomSource p_219154_, DifficultyInstance p_219155_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)CataclysmItems.CORAL_BARDICHE.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        RandomSource randomsource = p_34088_.m_213780_();
        this.m_213945_(randomsource, p_34089_);
        return spawngroupdata;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, DEEPLING_BRUTE_TRIDENT_THROW, DEEPLING_BRUTE_MELEE};
    }

    public boolean getSpinAttack() {
        return (Boolean)this.f_19804_.m_135370_(SPIN_ATTACK);
    }

    public void setSpinAttack(boolean p_211137_1_) {
        this.f_19804_.m_135381_(SPIN_ATTACK, (Object)p_211137_1_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.m_6084_()) {
            if (this.getAnimation() == DEEPLING_BRUTE_TRIDENT_THROW && target != null && this.getAnimationTick() == 11) {
                if (this.m_20070_() && !this.m_20159_()) {
                    double f1 = target.m_20185_() - this.m_20185_();
                    double f2 = target.m_20186_() - this.m_20186_();
                    double f3 = target.m_20189_() - this.m_20189_();
                    double f4 = Mth.m_14116_((float)((float)(f1 * f1 + f2 * f2 + f3 * f3)));
                    float f5 = 2.0f;
                    this.m_5997_(f1 *= (double)f5 / f4, f2 *= (double)f5 / f4, f3 *= (double)f5 / f4);
                    this.startAutoSpinAttack(20);
                    if (this.m_20096_()) {
                        this.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                    }
                    this.m_5496_(SoundEvents.f_12519_, 1.0f, 1.0f);
                    ItemHelper.hurtAndBreak((ItemStack)this.m_21205_(), (int)1, (LivingEntity)this);
                } else {
                    ThrownCoral_Bardiche_Entity throwntrident = new ThrownCoral_Bardiche_Entity(this.m_9236_(), (LivingEntity)this, new ItemStack((ItemLike)CataclysmItems.CORAL_BARDICHE.get()));
                    double p0 = target.m_20185_() - this.m_20185_();
                    double p1 = target.m_20227_(0.3333333333333333) - throwntrident.m_20186_();
                    double p2 = target.m_20189_() - this.m_20189_();
                    double p3 = Math.sqrt(p0 * p0 + p2 * p2);
                    throwntrident.m_6686_(p0, p1 + p3 * (double)0.2f, p2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
                    this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                    if (this.m_9236_().m_7967_((Entity)throwntrident)) {
                        ItemHelper.hurtAndBreak((ItemStack)this.m_21205_(), (int)1, (LivingEntity)this);
                    }
                }
            }
            if (this.getAnimation() == DEEPLING_BRUTE_MELEE && this.getAnimationTick() == 5) {
                this.m_5496_((SoundEvent)CataclysmSounds.DEEPLING_SWING.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                if (target != null && this.m_20270_((Entity)target) < 3.0f) {
                    float damage = (float)this.m_21133_(Attributes.f_22281_);
                    if (target.m_6469_(this.getServantAttack(), damage)) {
                        ItemHelper.hurtAndBreak((ItemStack)this.m_21205_(), (int)1, (LivingEntity)this);
                    }
                }
            }
        }
        AABB aabb = this.m_20191_();
        if (this.SpinAttackTicks > 0) {
            --this.SpinAttackTicks;
            this.m_21071_(aabb, this.m_20191_());
        }
    }

    public void startAutoSpinAttack(int p_204080_) {
        this.SpinAttackTicks = p_204080_;
        if (!this.m_9236_().f_46443_) {
            this.setSpinAttack(true);
        }
    }

    protected void m_21071_(AABB p_21072_, AABB p_21073_) {
        AABB aabb = p_21072_.m_82367_(p_21073_);
        List list = this.m_9236_().m_45933_((Entity)this, aabb);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity) || MobUtil.areAllies((Entity)this, (Entity)entity)) continue;
                entity.m_6469_(this.getServantAttack(), (float)this.m_21133_(Attributes.f_22281_));
                this.SpinAttackTicks = 0;
                this.m_20256_(this.m_20184_().m_82490_(-0.2));
                break;
            }
        } else if (this.f_19862_) {
            this.SpinAttackTicks = 0;
        }
        if (!this.m_9236_().f_46443_ && this.SpinAttackTicks <= 0) {
            this.setSpinAttack(false);
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.9f;
    }

    @Override
    public AABB getSwimmingBox() {
        return new AABB(this.m_20185_() - (double)1.3f, this.m_20186_(), this.m_20189_() - (double)1.3f, this.m_20185_() + (double)1.3f, this.m_20186_() + (double)0.7f, this.m_20189_() + (double)1.3f);
    }

    @Override
    public AABB getNormalBox() {
        return new AABB(this.m_20185_() - (double)0.7f, this.m_20186_(), this.m_20189_() - (double)0.7f, this.m_20185_() + (double)0.7f, this.m_20186_() + (double)2.6f, this.m_20189_() + (double)0.7f);
    }

    @Override
    public EntityDimensions getSwimmingSize() {
        return SWIMMING_SIZE;
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        ItemStack itemstack2 = this.m_21205_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_150930_((Item)CataclysmItems.CORAL_BARDICHE.get())) {
            this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
            this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
            this.m_21508_(EquipmentSlot.MAINHAND);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    static class DeeplingBruteTridentShoot
    extends Goal {
        private final DeeplingBruteServant mob;
        private final double moveSpeedAmp;
        private int attackCooldown;
        private final float maxAttackDistance;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public DeeplingBruteTridentShoot(DeeplingBruteServant mob, double moveSpeedAmpIn, float maxAttackDistanceIn) {
            this.mob = mob;
            this.moveSpeedAmp = moveSpeedAmpIn;
            this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.mob.m_21205_().m_150930_((Item)CataclysmItems.CORAL_BARDICHE.get()) && this.mob.m_20280_((Entity)livingentity) >= 36.0;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.m_21561_(true);
            this.mob.m_6672_(InteractionHand.MAIN_HAND);
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.m_21561_(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.mob.m_5810_();
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                boolean flag1;
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                boolean flag = this.mob.m_142582_((Entity)livingentity);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                    this.mob.m_21573_().m_26573_();
                    ++this.strafingTime;
                } else {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                }
                if (!flag && this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (flag && this.mob.getAnimation() != DEEPLING_BRUTE_TRIDENT_THROW) {
                    this.mob.setAnimation(DEEPLING_BRUTE_TRIDENT_THROW);
                    this.attackTime = this.attackCooldown;
                }
            }
        }
    }

    static class AnimationMeleeAttackGoal
    extends MeleeAttackGoal {
        protected final DeeplingBruteServant mob;

        public AnimationMeleeAttackGoal(DeeplingBruteServant p_25552_, double p_25553_, boolean p_25554_) {
            super((PathfinderMob)p_25552_, p_25553_, p_25554_);
            this.mob = p_25552_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        protected double m_6639_(LivingEntity p_25556_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + p_25556_.m_20205_();
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_);
            if (p_25558_ <= d0 && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.mob.setAnimation(DEEPLING_BRUTE_MELEE);
            }
        }
    }
}

