/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.deepling;

import com.Polarice3.Goety.utils.ItemHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.deepling.AbstractDeeplingServant;
import com.Polarice3.goety_cataclysm.common.entities.ally.deepling.LionfishServant;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCMobsConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import com.github.L_Ender.lionfishapi.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class DeeplingAnglerServant
extends AbstractDeeplingServant {
    public static final Animation DEEPLING_MELEE = Animation.create((int)20);
    public static final Animation DEEPLING_HUG = Animation.create((int)20);
    private static final EntityDimensions SWIMMING_SIZE = new EntityDimensions(1.225f, 0.65f, false);
    private int hugcooldown = 100;
    public int noLionfish = (Integer)GCMobsConfig.DeeplingAnglerCatchTime.get();
    public static final int HUG_COOLDOWN = 100;

    public DeeplingAnglerServant(EntityType<? extends AbstractDeeplingServant> entity, Level world) {
        super(entity, world);
        this.f_21342_ = new AbstractDeeplingServant.DeeplingMoveControl(this, 2.0f);
        this.switchNavigator(false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new AnimationMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new AbstractDeeplingServant.DeeplingGoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new AbstractDeeplingServant.DeeplingSwimUpGoal(this, 1.0, this.m_9236_().m_5736_()));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.27f).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.DeeplingAnglerDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.DeeplingAnglerHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.DeeplingAnglerArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.25);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.DeeplingAnglerHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.DeeplingAnglerArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.DeeplingAnglerDamage.get()));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("NoLionfish", this.getNoLionfish());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("NoLionfish")) {
            this.setNoLionfish(compound.m_128451_("NoLionfish"));
        }
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof DeeplingAnglerServant;
    }

    public int getSummonLimit(LivingEntity caster) {
        return (Integer)GCSpellConfig.DeeplingLimit.get();
    }

    public int xpReward() {
        return 8;
    }

    public int getNoLionfish() {
        return this.noLionfish;
    }

    public void setNoLionfish(int noLionfish) {
        this.noLionfish = noLionfish;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterBoundPathNavigation((Mob)this, worldIn);
    }

    protected void m_213945_(RandomSource p_219154_, DifficultyInstance p_219155_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42523_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData spawngroupdata = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        LionfishServant fish = (LionfishServant)((EntityType)GCEntityType.LIONFISH.get()).m_20615_(this.m_9236_());
        if (fish != null) {
            fish.setTrueOwner((LivingEntity)this);
            fish.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
            fish.m_20359_((Entity)this);
            fish.m_21463_((Entity)this, true);
            if (this.hasLifespan()) {
                fish.setLimitedLife(this.getLifespan());
            }
            pLevel.m_7967_((Entity)fish);
        }
        return spawngroupdata;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, DEEPLING_MELEE, DEEPLING_HUG};
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (this.hugcooldown > 0) {
            --this.hugcooldown;
        }
        if (this.getNoLionfish() > 0 && this.m_20069_() && this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42523_)) {
            --this.noLionfish;
        }
        if (this.m_6084_()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                LionfishServant fish;
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.getNoLionfish() <= 0 && this.m_6844_(EquipmentSlot.MAINHAND).m_150930_(Items.f_42523_) && (fish = (LionfishServant)((EntityType)GCEntityType.LIONFISH.get()).m_20615_(this.m_9236_())) != null) {
                    fish.setTrueOwner((LivingEntity)this);
                    fish.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    fish.m_20359_((Entity)this);
                    fish.m_21463_((Entity)this, true);
                    if (this.hasLifespan()) {
                        fish.setLimitedLife(this.getLifespan());
                    }
                    if (serverLevel.m_7967_((Entity)fish)) {
                        ItemHelper.hurtAndBreak((ItemStack)this.m_21205_(), (int)5, (LivingEntity)this);
                        this.m_5496_(SoundEvents.f_11939_, 1.0f, 0.4f / (this.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
                        this.setNoLionfish((Integer)GCMobsConfig.DeeplingAnglerCatchTime.get());
                    }
                }
            }
            if (this.getAnimation() == DEEPLING_MELEE && this.getAnimationTick() == 5) {
                this.m_5496_((SoundEvent)CataclysmSounds.DEEPLING_SWING.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                if (target != null && this.m_20270_((Entity)target) < 3.0f) {
                    float damage = (float)this.m_21133_(Attributes.f_22281_);
                    if (target.m_6469_(this.getServantAttack(), damage)) {
                        ItemHelper.hurtAndBreak((ItemStack)this.m_21205_(), (int)1, (LivingEntity)this);
                    }
                }
            }
            if (this.getAnimation() == DEEPLING_HUG && this.getAnimationTick() == 9) {
                this.m_5496_((SoundEvent)CataclysmSounds.DEEPLING_SWING.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                if (target != null && this.m_20270_((Entity)target) < 3.0f) {
                    float damage = (float)this.m_21133_(Attributes.f_22281_);
                    boolean flag = target.m_6469_(this.getServantAttack(), damage);
                    if (flag) {
                        target.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60, 1), (Entity)this);
                        ItemHelper.hurtAndBreak((ItemStack)this.m_21205_(), (int)1, (LivingEntity)this);
                    }
                }
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.9f;
    }

    @Override
    public EntityDimensions getSwimmingSize() {
        return SWIMMING_SIZE;
    }

    @Override
    public AABB getSwimmingBox() {
        return new AABB(this.m_20185_() - (double)1.225f, this.m_20186_(), this.m_20189_() - (double)1.225f, this.m_20185_() + (double)1.225f, this.m_20186_() + (double)0.65f, this.m_20189_() + (double)1.225f);
    }

    @Override
    public AABB getNormalBox() {
        return new AABB(this.m_20185_() - (double)0.65f, this.m_20186_(), this.m_20189_() - (double)0.65f, this.m_20185_() + (double)0.65f, this.m_20186_() + (double)2.45f, this.m_20189_() + (double)0.65f);
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        ItemStack itemstack2 = this.m_21205_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_150930_(Items.f_42523_)) {
            this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
            this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
            this.m_21508_(EquipmentSlot.MAINHAND);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    static class AnimationMeleeAttackGoal
    extends MeleeAttackGoal {
        protected final DeeplingAnglerServant mob;

        public AnimationMeleeAttackGoal(DeeplingAnglerServant p_25552_, double p_25553_, boolean p_25554_) {
            super((PathfinderMob)p_25552_, p_25553_, p_25554_);
            this.mob = p_25552_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        protected double m_6639_(LivingEntity p_25556_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + p_25556_.m_20205_();
        }

        protected void m_6739_(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.m_6639_(p_25557_);
            if (p_25558_ <= d0 && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                if (this.mob.hugcooldown <= 0) {
                    this.mob.setAnimation(DEEPLING_HUG);
                    this.mob.hugcooldown = 100;
                } else {
                    this.mob.setAnimation(DEEPLING_MELEE);
                }
            }
        }
    }
}

