/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.acropolis;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.ally.InternalAnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonAttackGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonMoveGoal;
import com.Polarice3.goety_cataclysm.common.entities.ally.ai.InternalSummonStateGoal;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.etc.path.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.etc.path.SemiAquaticPathNavigator;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class HippocamtusServant
extends InternalAnimationSummon {
    boolean searchingForLand;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState swing1AnimationState = new AnimationState();
    public AnimationState swing2AnimationState = new AnimationState();
    public AnimationState stabAnimationState = new AnimationState();
    public AnimationState guardAnimationState = new AnimationState();
    public AnimationState guardcounterAnimationState = new AnimationState();
    public AnimationState parryingAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public static final EntityDataAccessor<Boolean> STAB = SynchedEntityData.m_135353_(HippocamtusServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int block_stage = 0;
    private int charge_cooldown = 0;
    public static final int CHARGE_COOLDOWN = 100;
    private int guard_cooldown = 0;
    public static final int GUARD_COOLDOWN = 160;
    public static int SWING_1 = 1;
    public static int SWING_2 = 2;
    public static int STAB_ATTACK = 3;
    public static int GUARD = 4;
    public static int PARRYING = 5;
    public static int GUARD_COUNTER = 6;
    public static int DEATH = 7;
    protected final SemiAquaticPathNavigator waterNavigation;
    protected final CMPathNavigateGround groundNavigation;

    public HippocamtusServant(EntityType<? extends Summoned> entity, Level world) {
        super(entity, world);
        this.m_274367_(1.75f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.waterNavigation = new SemiAquaticPathNavigator((Mob)this, world);
        this.groundNavigation = new CMPathNavigateGround((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this, 1.0, 80));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new InternalSummonMoveGoal(this, false, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new ChargeAttackGoal(this, 0, STAB_ATTACK, 0, 41, 13, 4.5f, 16.0f));
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, GUARD, 0, 50, 50, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && HippocamtusServant.this.m_217043_().m_188501_() * 100.0f < 48.0f && HippocamtusServant.this.guard_cooldown <= 0;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && HippocamtusServant.this.block_stage == 0;
            }

            @Override
            public void m_8041_() {
                HippocamtusServant.this.guard_cooldown = 160;
                if (HippocamtusServant.this.block_stage == 1) {
                    this.entity.setAttackState(5);
                } else if (HippocamtusServant.this.block_stage == 2) {
                    this.entity.setAttackState(6);
                } else {
                    super.m_8041_();
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, SWING_1, 0, 45, 8, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && HippocamtusServant.this.getStab();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                HippocamtusServant.this.setStab(HippocamtusServant.this.f_19796_.m_188499_());
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new InternalSummonAttackGoal(this, 0, SWING_2, 0, 39, 8, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !HippocamtusServant.this.getStab();
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                HippocamtusServant.this.setStab(HippocamtusServant.this.f_19796_.m_188499_());
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new InternalSummonStateGoal(this, PARRYING, PARRYING, 0, 64, 64){

            @Override
            public void m_8041_() {
                super.m_8041_();
                HippocamtusServant.this.block_stage = 0;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new InternalSummonStateGoal(this, GUARD_COUNTER, GUARD_COUNTER, 0, 51, 51){

            @Override
            public void m_8041_() {
                super.m_8041_();
                HippocamtusServant.this.block_stage = 0;
            }
        });
    }

    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal((Summoned)this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.HippocamtusDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.HippocamtusHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.HippocamtusArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 0.7);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.HippocamtusHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.HippocamtusArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.HippocamtusDamage.get()));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public int xpReward() {
        return 35;
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof HippocamtusServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.HippocamtusLimit.get();
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6109_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.f_21342_ = new HippocamtusSwimControl(this, 4.0f);
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.f_21342_ = new MoveControl((Mob)this);
                this.m_20282_(false);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float damage) {
        Vec3 vector3d2;
        Entity entity = source.m_7640_();
        if (!source.m_269533_(DamageTypeTags.f_276146_) && !this.m_21525_() && this.getAttackState() == GUARD && (vector3d2 = source.m_7270_()) != null) {
            Vec3 vector3d = this.m_20252_(1.0f);
            Vec3 vector3d1 = vector3d2.m_82505_(this.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, 0.0, vector3d1.f_82481_);
            if (vector3d1.m_82526_(vector3d) < 0.0) {
                if (this.attackTicks >= 7 && this.attackTicks <= 17) {
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        this.block_stage = 1;
                        if (!this.m_9236_().f_46443_) {
                            living.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), 50));
                        }
                        this.m_5496_((SoundEvent)CataclysmSounds.PARRY.get(), 0.8f, 1.0f);
                    }
                    return false;
                }
                if (this.attackTicks > 17 && this.attackTicks <= 43) {
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        this.block_stage = 2;
                        living.m_147240_(0.5, this.m_20185_() - living.m_20185_(), this.m_20189_() - living.m_20189_());
                    }
                    return false;
                }
                return super.m_6469_(source, damage);
            }
        }
        return super.m_6469_(source, damage);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "swing1")) {
            return this.swing1AnimationState;
        }
        if (Objects.equals(input, "swing2")) {
            return this.swing2AnimationState;
        }
        if (Objects.equals(input, "stab")) {
            return this.stabAnimationState;
        }
        if (Objects.equals(input, "guard")) {
            return this.guardAnimationState;
        }
        if (Objects.equals(input, "guardcounter")) {
            return this.guardcounterAnimationState;
        }
        if (Objects.equals(input, "parry")) {
            return this.parryingAnimationState;
        }
        if (Objects.equals(input, "idle")) {
            return this.idleAnimationState;
        }
        return Objects.equals(input, "death") ? this.deathAnimationState : new AnimationState();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STAB, (Object)false);
    }

    public void setStab(boolean stab) {
        this.f_19804_.m_135381_(STAB, (Object)stab);
    }

    public boolean getStab() {
        return (Boolean)this.f_19804_.m_135370_(STAB);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_)) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.swing1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.swing2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.stabAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.guardAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.parryingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.guardcounterAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.swing1AnimationState.m_216973_();
        this.swing2AnimationState.m_216973_();
        this.stabAnimationState.m_216973_();
        this.guardAnimationState.m_216973_();
        this.guardcounterAnimationState.m_216973_();
        this.parryingAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.setAttackState(DEATH);
    }

    @Override
    public int deathTimer() {
        return 60;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.HIPPOCAMTUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.HIPPOCAMTUS_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CataclysmSounds.HIPPOCAMTUS_IDLE.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.getAttackState() != DEATH, this.f_19797_);
        }
        if (this.charge_cooldown > 0) {
            --this.charge_cooldown;
        }
        if (this.guard_cooldown > 0) {
            --this.guard_cooldown;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() == STAB_ATTACK) {
            if (this.attackTicks == 16) {
                this.m_5496_((SoundEvent)CataclysmSounds.IGNIS_POKE.get(), 1.0f, 1.25f + this.m_217043_().m_188501_() * 0.1f);
            }
            if (this.attackTicks == 18) {
                this.AreaAttack(8.5f, 6.0f, 45.0f, 1.0f, 90, false, false);
            }
        }
        if (this.getAttackState() == SWING_1 && this.attackTicks == 11) {
            this.m_5496_((SoundEvent)CataclysmSounds.SWING.get(), 1.0f, 1.25f + this.m_217043_().m_188501_() * 0.1f);
            this.AreaAttack(5.0f, 5.0f, 200.0f, 1.0f, 70, false, false);
        }
        if (this.getAttackState() == SWING_2 && this.attackTicks == 11) {
            this.m_5496_((SoundEvent)CataclysmSounds.SWING.get(), 1.0f, 1.25f + this.m_217043_().m_188501_() * 0.1f);
            this.AreaAttack(5.0f, 5.0f, 200.0f, 1.0f, 60, false, false);
        }
        if (this.getAttackState() == PARRYING) {
            if (this.attackTicks == 1) {
                this.parryParticle(1.5f, 0.9f, -0.1f);
            }
            if (this.attackTicks == 35 || this.attackTicks == 42 || this.attackTicks == 48) {
                this.m_5496_((SoundEvent)CataclysmSounds.SWING.get(), 1.0f, 1.25f + this.m_217043_().m_188501_() * 0.1f);
                this.AreaAttack(7.0f, 6.0f, 45.0f, 0.9f, 90, false, true);
            }
        }
        if (this.getAttackState() == GUARD_COUNTER && (this.attackTicks == 10 || this.attackTicks == 17 || this.attackTicks == 24)) {
            this.m_5496_((SoundEvent)CataclysmSounds.SWING.get(), 1.0f, 1.25f + this.m_217043_().m_188501_() * 0.1f);
            this.AreaAttack(7.0f, 6.0f, 45.0f, 0.9f, 90, false, true);
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, int shieldbreakticks, boolean knockback, boolean penetrate) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        if (!this.m_9236_().f_46443_) {
            for (LivingEntity entityHit : entitiesHit) {
                float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
                float entityAttackingAngle = this.f_20883_ % 360.0f;
                if (entityHitAngle < 0.0f) {
                    entityHitAngle += 360.0f;
                }
                if (entityAttackingAngle < 0.0f) {
                    entityAttackingAngle += 360.0f;
                }
                float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
                float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
                if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || MobUtil.areAllies((Entity)this, (Entity)entityHit)) continue;
                DamageSource damagesource = penetrate ? CMDamageTypes.causePenetrateDamage((LivingEntity)this) : this.getServantAttack();
                boolean hurt = entityHit.m_6469_(damagesource, (float)(this.m_21133_(Attributes.f_22281_) * (double)damage));
                if (entityHit.m_21275_(damagesource) && shieldbreakticks > 0) {
                    this.disableShield(entityHit, shieldbreakticks);
                }
                double d0 = entityHit.m_20185_() - this.m_20185_();
                double d1 = entityHit.m_20189_() - this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                if (!hurt || !knockback) continue;
                entityHit.m_5997_(d0 / d2 * 2.25, 0.15, d1 / d2 * 2.25);
            }
        }
    }

    private void parryParticle(float height, float vec, float math) {
        if (this.m_9236_().f_46443_) {
            double d0 = this.m_20185_();
            double d1 = this.m_20186_() + (double)height;
            double d2 = this.m_20189_();
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
            double theta = (double)this.f_20883_ * (Math.PI / 180);
            double vecX = Math.cos(theta);
            double vecZ = Math.sin(theta);
            double theta2 = theta + 1.5707963267948966;
            double X = Math.cos(theta2);
            double Z = Math.sin(theta2);
            for (int i = 0; i < 12; ++i) {
                float throwAngle = (float)i * (float)Math.PI / 6.0f;
                double y = 2.0 * Math.sin(throwAngle);
                double xz = 2.0 * Math.cos(throwAngle);
                double d3 = xz * vecX + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                double d4 = y + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                double d5 = xz * vecZ + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                double speed = 0.35;
                this.m_9236_().m_7106_((ParticleOptions)ModParticle.SPARK.get(), d0 + (double)vec * X + (double)(f * math), d1, d2 + (double)vec * Z + (double)(f1 * math), d3 * speed, d4 * speed, d5 * speed);
            }
        }
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    public boolean m_7301_(MobEffectInstance p_34192_) {
        return p_34192_.m_19544_() != ModEffect.EFFECTABYSSAL_CURSE.get() && super.m_7301_(p_34192_);
    }

    protected boolean m_7341_(Entity p_31508_) {
        return false;
    }

    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_204117_(ItemTags.f_13156_) && this.m_21223_() < this.m_21233_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.m_5634_(2.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static class ChargeAttackGoal
    extends Goal {
        protected final HippocamtusServant entity;
        private final int getAttackState;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackminrange;
        private final float attackrange;

        public ChargeAttackGoal(HippocamtusServant entity, int getAttackState, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackminrange, float attackrange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getAttackState = getAttackState;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackminrange = attackminrange;
            this.attackrange = attackrange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && this.entity.m_20270_((Entity)target) > this.attackminrange && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getAttackState && this.entity.m_217043_().m_188501_() * 100.0f < 16.0f && this.entity.charge_cooldown <= 0;
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
            this.entity.charge_cooldown = 100;
        }

        public boolean m_8045_() {
            return this.entity.attackTicks < this.attackMaxtick;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_146922_(this.entity.f_20883_);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            if (this.entity.attackTicks == this.attackseetick) {
                float f1 = (float)Math.cos(Math.toRadians(this.entity.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(this.entity.m_146908_() + 90.0f));
                if (target != null) {
                    float r = this.entity.m_20270_((Entity)target);
                    r = Mth.m_14036_((float)r, (float)0.0f, (float)5.0f);
                    this.entity.m_5997_((double)f1 * 0.4 * (double)r, 0.0, (double)f2 * 0.4 * (double)r);
                } else {
                    this.entity.m_5997_((double)f1 * 2.0, 0.0, (double)f2 * 2.0);
                }
            }
        }
    }

    static class HippocamtusSwimControl
    extends MoveControl {
        private final HippocamtusServant drowned;
        private final float speedMulti;

        public HippocamtusSwimControl(HippocamtusServant p_32433_, float speedMulti) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
            this.speedMulti = speedMulti;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            LivingEntity owner = this.drowned.getTrueOwner();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand || owner != null && owner.m_20186_() > this.drowned.m_20186_() && this.drowned.isFollowing()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * (double)this.speedMulti * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

