/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.entities.TrainingBlockEntity;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.goety_cataclysm.common.blocks.GCBlocks;
import com.Polarice3.goety_cataclysm.common.blocks.entities.GCBlockEntities;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.factory.WatcherServant;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FabricatorBlockEntity
extends TrainingBlockEntity {
    public int tickCount;
    private float activeRotation;

    public FabricatorBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)GCBlockEntities.FABRICATOR.get(), p_155229_, p_155230_);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, TrainingBlockEntity blockEntity) {
        super.tick(level, blockPos, blockState, blockEntity);
        ++this.tickCount;
        this.activeRotation += 1.0f;
        if (blockEntity.isTraining()) {
            if (blockEntity.trainTime != blockEntity.getMaxTrainTime()) {
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ServerParticleUtil.spawnRedstoneParticles((ServerLevel)serverLevel, (BlockPos)blockPos);
                }
                if (this.trainTime == 20) {
                    level.m_5594_(null, blockPos, (SoundEvent)GoetySounds.BLAZING_CAGE_TRAIN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
            } else if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ServerParticleUtil.spawnRedstoneParticles((ServerLevel)serverLevel, (BlockPos)blockPos);
            }
        }
    }

    public float getActiveRotation(float p_205036_1_) {
        return (this.activeRotation + p_205036_1_) * -0.0375f;
    }

    public void setVariant(ItemStack itemStack, Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel && this.getTrainMob() != GCEntityType.WATCHER_SERVANT.get()) {
            this.setEntityType((EntityType)GCEntityType.WATCHER_SERVANT.get());
            this.markUpdated();
        }
    }

    public void startTraining(int amount, ItemStack itemStack) {
        super.startTraining(amount, itemStack);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)GoetySounds.BLAZING_CAGE_START.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void playSpawnSound() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)GoetySounds.SUMMON_SPELL_FIERY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public int maxTrainAmount() {
        return 5;
    }

    public boolean summonLimit() {
        int count = 0;
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity entity : serverLevel.m_8583_()) {
                if (!(entity instanceof WatcherServant)) continue;
                WatcherServant servant = (WatcherServant)entity;
                if (this.getTrueOwner() == null || servant.getTrueOwner() != this.getTrueOwner() || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count >= (Integer)GCSpellConfig.WatcherLimit.get();
    }

    public boolean isFuel(ItemStack itemStack) {
        return itemStack.m_150930_(((Block)GCBlocks.MECHANIZED_IRON_BLOCK.get()).m_5456_());
    }
}

