/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.item.additional_placements;

import com.mojang.datafixers.util.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AdditionalItemPlacementsAPI {
    private static boolean isAfterRegistration = false;
    private static WeakReference<Map<Block, Item>> blockToItemsMap = new WeakReference<Object>(null);
    private static final List<Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends Item>>> PLACEMENTS = new ArrayList<Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends Item>>>();
    private static final List<Pair<Function<Item, ? extends AdditionalItemPlacement>, Predicate<Item>>> PLACEMENTS_GENERIC = new ArrayList<Pair<Function<Item, ? extends AdditionalItemPlacement>, Predicate<Item>>>();

    public static void register(Supplier<? extends AdditionalItemPlacement> placement, Supplier<? extends Item> itemSupplier) {
        if (PlatHelper.isDev() && isAfterRegistration) {
            throw new IllegalStateException("Attempted to add placeable behavior after registration");
        }
        PLACEMENTS.add((Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends Item>>)Pair.of(placement, itemSupplier));
    }

    public static void register(Function<Item, ? extends AdditionalItemPlacement> placement, Predicate<Item> itemPredicate) {
        if (PlatHelper.isDev() && isAfterRegistration) {
            throw new IllegalStateException("Attempted to add placeable behavior after registration");
        }
        PLACEMENTS_GENERIC.add((Pair<Function<Item, ? extends AdditionalItemPlacement>, Predicate<Item>>)Pair.of(placement, itemPredicate));
    }

    public static void registerSimple(Supplier<? extends Block> block, Supplier<? extends Item> itemSupplier) {
        AdditionalItemPlacementsAPI.register(() -> new AdditionalItemPlacement((Block)block.get()), itemSupplier);
    }

    @Nullable
    public static AdditionalItemPlacement getBehavior(Item item) {
        return ((IExtendedItem)item).moonlight$getAdditionalBehavior();
    }

    public static boolean hasBehavior(Item item) {
        return AdditionalItemPlacementsAPI.getBehavior(item) != null;
    }

    @ApiStatus.Internal
    public static void afterItemReg() {
        if (blockToItemsMap.get() == null && PlatHelper.isDev()) {
            throw new AssertionError((Object)"Block to items map was null");
        }
        AdditionalItemPlacementsAPI.attemptRegistering();
    }

    private static void attemptRegistering() {
        Map map = (Map)blockToItemsMap.get();
        if (map != null) {
            for (Item item : BuiltInRegistries.f_257033_) {
                for (Pair<Function<Item, ? extends AdditionalItemPlacement>, Predicate<Item>> v : PLACEMENTS_GENERIC) {
                    Predicate predicate = (Predicate)v.getSecond();
                    if (!predicate.test(item)) continue;
                    PLACEMENTS.add((Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends Item>>)Pair.of(() -> (AdditionalItemPlacement)((Function)v.getFirst()).apply(item), () -> item));
                }
            }
            PLACEMENTS_GENERIC.clear();
            for (Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends Item>> p : PLACEMENTS) {
                AdditionalItemPlacement placement = (AdditionalItemPlacement)((Supplier)p.getFirst()).get();
                Item i = (Item)((Supplier)p.getSecond()).get();
                Block b = placement.getPlacedBlock();
                if (i == null || b == null) continue;
                if (i != Items.f_41852_ && b != Blocks.f_50016_) {
                    ((IExtendedItem)i).moonlight$addAdditionalBehavior(placement);
                    if (map.containsKey(b)) continue;
                    map.put(b, i);
                    continue;
                }
                throw new AssertionError((Object)("Attempted to register an Additional behavior to invalid blocks or items: " + b + ", " + i));
            }
        }
    }

    static void onRegistryCallback(Map<Block, Item> pBlockToItemMap) {
        blockToItemsMap = new WeakReference<Map<Block, Item>>(pBlockToItemMap);
        if (isAfterRegistration) {
            AdditionalItemPlacementsAPI.attemptRegistering();
            blockToItemsMap.clear();
        }
        isAfterRegistration = true;
    }
}

