/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.salju.trialstowers.block.CrafterEntity;
import net.salju.trialstowers.init.TrialsBlockEntities;
import net.salju.trialstowers.init.TrialsProperties;

public class CrafterBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    public static final BooleanProperty CRAFTING = TrialsProperties.CRAFTING;

    public CrafterBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CRAFTING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{TRIGGERED});
        builder.m_61104_(new Property[]{CRAFTING});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rez) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CrafterEntity) {
            CrafterEntity target = (CrafterEntity)blockEntity;
            player.m_5893_((MenuProvider)target);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean check) {
        super.m_6807_(state, world, pos, newState, check);
        if (!(newState.m_60713_(state.m_60734_()) || world.m_5776_() || ((Boolean)state.m_61143_((Property)TRIGGERED)).booleanValue() || ((Boolean)state.m_61143_((Property)CRAFTING)).booleanValue())) {
            world.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_6810_(BlockState newState, Level world, BlockPos pos, BlockState oldState, boolean check) {
        if (!newState.m_60713_(oldState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CrafterEntity) {
                CrafterEntity target = (CrafterEntity)blockEntity;
                target.m_6211_();
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(newState, world, pos, oldState, check);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blok, BlockPos poz, boolean check) {
        super.m_6861_(state, world, pos, blok, poz, check);
        if (!(world.m_5776_() || ((Boolean)state.m_61143_((Property)TRIGGERED)).booleanValue() || ((Boolean)state.m_61143_((Property)CRAFTING)).booleanValue())) {
            world.m_186460_(pos, (Block)this, 1);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction dir = context.m_7820_().m_122424_();
        if (dir == Direction.UP || dir == Direction.DOWN) {
            dir = Direction.NORTH;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir);
    }

    public void m_213897_(BlockState state, ServerLevel lvl, BlockPos pos, RandomSource rng) {
        super.m_213897_(state, lvl, pos, rng);
        BlockEntity blockEntity = lvl.m_7702_(pos);
        if (blockEntity instanceof CrafterEntity) {
            CrafterEntity target = (CrafterEntity)blockEntity;
            if (((Boolean)state.m_61143_((Property)TRIGGERED)).booleanValue() && ((Boolean)state.m_61143_((Property)CRAFTING)).booleanValue()) {
                lvl.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CRAFTING, (Comparable)Boolean.valueOf(false)), 2);
                lvl.m_46717_(pos, state.m_60734_());
                if (target.m_7983_() || !target.canCraftItem()) {
                    lvl.m_5594_(null, pos, SoundEvents.f_11797_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    Container con = HopperBlockEntity.m_59390_((Level)lvl, (BlockPos)pos.m_121945_((Direction)state.m_61143_((Property)FACING)));
                    if (con != null && !(con instanceof CrafterEntity) && this.canPlace(con, target.getResultItem())) {
                        lvl.m_5594_(null, pos, SoundEvents.f_11798_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        HopperBlockEntity.m_59326_((Container)target, (Container)con, (ItemStack)target.getResultItem().m_41777_(), (Direction)((Direction)state.m_61143_((Property)FACING)).m_122424_());
                        for (ItemStack stack : target.stacks) {
                            if (stack.m_41619_() || target.isResultItem(stack)) continue;
                            if (stack.hasCraftingRemainingItem() && this.canPlace(con, stack.getCraftingRemainingItem())) {
                                HopperBlockEntity.m_59326_((Container)target, (Container)con, (ItemStack)stack.getCraftingRemainingItem().m_41777_(), (Direction)((Direction)state.m_61143_((Property)FACING)).m_122424_());
                            }
                            stack.m_41774_(1);
                        }
                    } else if (lvl.m_46859_(pos.m_121945_((Direction)state.m_61143_((Property)FACING)))) {
                        lvl.m_5594_(null, pos, SoundEvents.f_11798_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        target.craftItem((Direction)state.m_61143_((Property)FACING));
                    } else {
                        lvl.m_5594_(null, pos, SoundEvents.f_11797_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            } else if (((Boolean)state.m_61143_((Property)TRIGGERED)).booleanValue() && !((Boolean)state.m_61143_((Property)CRAFTING)).booleanValue()) {
                lvl.m_7731_(pos, (BlockState)state.m_61124_((Property)CRAFTING, (Comparable)Boolean.valueOf(true)), 2);
                lvl.m_46717_(pos, state.m_60734_());
                lvl.m_186460_(pos, (Block)this, 4);
            } else if (lvl.m_276867_(pos) && !((Boolean)state.m_61143_((Property)TRIGGERED)).booleanValue()) {
                lvl.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
                lvl.m_46717_(pos, state.m_60734_());
                lvl.m_186460_(pos, (Block)this, 4);
            }
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int i, int e) {
        return world.m_7702_(pos) == null ? super.m_8133_(state, world, pos, i, e) : world.m_7702_(pos).m_7531_(i, e);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CrafterEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return CrafterBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TrialsBlockEntities.CRAFTER.get()), CrafterEntity::tick);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CrafterEntity) {
            CrafterEntity target = (CrafterEntity)blockEntity;
            return target.getPower();
        }
        return 0;
    }

    public boolean canPlace(Container con, ItemStack stack) {
        boolean check = false;
        for (int i = 0; i < con.m_6643_(); ++i) {
            if (!con.m_7013_(i, stack) || !con.m_8020_(i).m_41619_() && (con.m_8020_(i).m_41720_() != stack.m_41720_() || con.m_8020_(i).m_41613_() + stack.m_41613_() >= con.m_8020_(i).m_41741_())) continue;
            check = true;
            break;
        }
        return check;
    }
}

