/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import ewewukek.musketmod.GunItem;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.ai.goals.RangedCrossbowAttackPassiveGoal;

public class ModCompat {
    public static HumanoidModel.ArmPose reloadMusketAnim(ItemStack stack, InteractionHand handIn, Guard guard, HumanoidModel.ArmPose bipedmodel$armpose) {
        if (stack.m_41720_() instanceof GunItem && !GunItem.isLoaded((ItemStack)stack) && handIn == guard.m_7655_()) {
            return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
        }
        return bipedmodel$armpose;
    }

    public static boolean isHoldingMusket(ItemStack stack) {
        return stack.m_41720_() instanceof GunItem;
    }

    public static HumanoidModel.ArmPose holdMusketAnim(ItemStack stack, Guard guard, HumanoidModel.ArmPose bipedmodel$armpose) {
        if (stack.m_41720_() instanceof GunItem && GunItem.isLoaded((ItemStack)stack) && guard.m_5912_()) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    public static void shootGun(Guard guard) {
        Item item = guard.m_21205_().m_41720_();
        if (item instanceof GunItem) {
            GunItem musketItem = (GunItem)item;
            Vec3 front = Vec3.m_82498_((float)guard.m_146909_(), (float)guard.m_146908_());
            musketItem.fire((LivingEntity)guard, front);
            GunItem.setLoaded((ItemStack)guard.m_21205_(), (boolean)false);
            guard.m_5496_(musketItem.fireSound(), 3.5f, 1.0f);
            guard.m_21205_().m_41622_(1, (LivingEntity)guard, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public static class UseMusketGoal<T extends PathfinderMob>
    extends Goal {
        private final double speedModifier;
        private final float attackRadiusSqr;
        private final T mob;
        private int attackIntervalMin;
        private Path path;
        private int attackTime = -1;
        private int seeTime;
        private int avoidTime;
        private int bulletsShot = 0;
        private int timeUntilShoot = 20;

        public UseMusketGoal(T pMob, double pSpeedModifier, int pAttackIntervalMin, float pAttackRadius) {
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.attackIntervalMin = pAttackIntervalMin;
            this.attackRadiusSqr = pAttackRadius * pAttackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity target = this.mob.m_5448_();
            return target != null && this.mob.m_21205_().m_41720_() instanceof GunItem;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.mob.m_21561_(true);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                double distanceSquared = this.mob.m_20280_((Entity)target);
                boolean canSee = this.mob.m_21574_().m_148306_((Entity)target);
                boolean seeTimeGreaterThanZero = this.seeTime > 0;
                this.mob.m_21563_().m_148051_((Entity)target);
                this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
                if (!canSee && this.seeTime < -60) {
                    this.mob.m_5810_();
                }
                if (GunItem.isLoaded((ItemStack)this.mob.m_21205_())) {
                    this.mob.m_5810_();
                    if (canSee) {
                        --this.timeUntilShoot;
                        if (this.timeUntilShoot <= 0) {
                            ((RangedAttackMob)this.mob).m_6504_(target, ((GunItem)this.mob.m_21205_().m_41720_()).bulletSpeed());
                            this.attackTime = this.attackIntervalMin;
                            ++this.bulletsShot;
                        }
                    }
                } else if (--this.attackTime <= 0 && this.seeTime >= -60 && !GunItem.isLoaded((ItemStack)this.mob.m_21205_())) {
                    this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof GunItem));
                    this.timeUntilShoot = 20;
                }
                if (canSee != seeTimeGreaterThanZero) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                if (distanceSquared <= 6.0 || this.bulletsShot >= 3) {
                    this.avoidTime = this.avoidTime <= 0 ? 60 : (this.avoidTime -= 10);
                    this.bulletsShot = 0;
                }
                if (this.avoidTime <= 0) {
                    this.mob.m_21573_().m_26573_();
                }
                if (distanceSquared > (double)this.attackRadiusSqr || this.seeTime < 5) {
                    this.mob.m_21573_().m_5624_((Entity)target, 1.0);
                } else if (distanceSquared < (double)this.attackRadiusSqr) {
                    this.mob.m_21573_().m_26573_();
                }
                if (this.avoidTime > 60) {
                    this.avoidTime = 60;
                }
                if (--this.avoidTime > 0 || RangedCrossbowAttackPassiveGoal.friendlyInLineOfSight(this.mob)) {
                    Vec3 vec3 = this.getPosition(this.mob);
                    if (distanceSquared <= (double)this.attackRadiusSqr && vec3 != null && this.mob.m_21573_().m_26571_()) {
                        this.path = this.mob.m_21573_().m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
                        this.mob.m_21563_().m_24946_(vec3.f_82479_, this.mob.m_20188_(), vec3.f_82481_);
                        if (this.path != null && this.path.m_77403_()) {
                            this.mob.m_21573_().m_26536_(this.path, 0.9);
                            this.attackTime = -1;
                            this.mob.m_5810_();
                        }
                    }
                }
            }
        }

        public void m_8041_() {
            this.mob.m_21561_(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.mob.m_5810_();
            this.timeUntilShoot = 20;
        }

        @Nullable
        protected Vec3 getPosition(T mob) {
            if (mob.m_5448_() != null) {
                return LandRandomPos.m_148521_(mob, (int)5, (int)7, (Vec3)mob.m_5448_().m_20182_());
            }
            return LandRandomPos.m_148488_(mob, (int)5, (int)7);
        }
    }
}

