/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.client.gui.screen.AdornMenuScreen;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.menu.BrewerMenu;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.LoggingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0017\u001a\u00020\u0002\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001a\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001e"}, d2={"Ljuuxel/adorn/client/gui/screen/BrewerScreen;", "Ljuuxel/adorn/client/gui/screen/AdornMenuScreen;", "Ljuuxel/adorn/menu/BrewerMenu;", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "delta", "", "mouseX", "mouseY", "", "drawBackground", "(Lnet/minecraft/client/gui/GuiGraphics;FII)V", "x", "y", "drawMouseoverTooltip", "(Lnet/minecraft/client/gui/GuiGraphics;II)V", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "", "Lnet/minecraft/network/chat/Component;", "getFluidTooltip", "(Ljuuxel/adorn/fluid/FluidReference;)Ljava/util/List;", "menu", "Lnet/minecraft/world/entity/player/Inventory;", "playerInventory", "title", "<init>", "(Ljuuxel/adorn/menu/BrewerMenu;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V", "Companion", "Adorn"})
public final class BrewerScreen
extends AdornMenuScreen<BrewerMenu> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER = LoggingKt.logger();
    @NotNull
    private static final ResourceLocation TEXTURE = AdornCommon.id("textures/gui/brewer.png");
    public static final int FLUID_AREA_HEIGHT = 59;

    public BrewerScreen(@NotNull BrewerMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void m_7286_(@NotNull GuiGraphics context2, float delta, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        context2.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        Companion.drawFluid(context2, this.f_97735_ + 145, this.f_97736_ + 17, ((BrewerMenu)this.f_97732_).getFluid());
        context2.m_280218_(TEXTURE, this.f_97735_ + 145, this.f_97736_ + 21, 176, 25, 16, 51);
        int progress = ((BrewerMenu)this.f_97732_).getProgress();
        if (progress > 0) {
            float progressFract = (float)progress / 200.0f;
            context2.m_280218_(TEXTURE, this.f_97735_ + 84, this.f_97736_ + 24, 176, 0, 8, Mth.m_14167_((float)(progressFract * (float)25)));
        }
    }

    protected void m_280072_(@NotNull GuiGraphics context2, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super.m_280072_(context2, x, y);
        int x2 = x - this.f_97735_;
        int y2 = y - this.f_97736_;
        boolean bl = 145 <= x2 ? x2 < 161 : false;
        if (bl) {
            boolean bl2 = 17 <= y2 ? y2 < 76 : false;
            if (bl2) {
                context2.m_280666_(this.f_96547_, this.getFluidTooltip(((BrewerMenu)this.f_97732_).getFluid()), x, y);
            }
        }
    }

    private final List<Component> getFluidTooltip(FluidReference fluid) {
        FluidRenderingBridge fluidRenderingBridge = FluidRenderingBridge.Companion.get();
        Minecraft minecraft = this.f_96541_;
        Intrinsics.checkNotNull((Object)minecraft);
        TooltipFlag.Default default_ = minecraft.f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_;
        Intrinsics.checkNotNullExpressionValue((Object)default_, (String)"if (client!!.options.adv\u2026ntext.BASIC\n            }");
        return fluidRenderingBridge.getTooltip(fluid, (TooltipFlag)default_, 2000);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b(\u0010)J-\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJg\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J%\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Ljuuxel/adorn/client/gui/screen/BrewerScreen$Companion;", "", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "", "x", "y", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "", "drawFluid", "(Lnet/minecraft/client/gui/GuiGraphics;IILjuuxel/adorn/fluid/FluidReference;)V", "", "width", "height", "u0", "v0", "u1", "v1", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "sprite", "color", "drawSprite", "(Lnet/minecraft/client/gui/GuiGraphics;IFFFFFFFLnet/minecraft/client/renderer/texture/TextureAtlasSprite;I)V", "Lnet/minecraft/client/Minecraft;", "client", "syncId", "Ljuuxel/adorn/fluid/FluidVolume;", "setFluidFromPacket", "(Lnet/minecraft/client/Minecraft;ILjuuxel/adorn/fluid/FluidVolume;)V", "FLUID_AREA_HEIGHT", "I", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Lnet/minecraft/resources/ResourceLocation;", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "getTEXTURE", "()Lnet/minecraft/resources/ResourceLocation;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getTEXTURE() {
            return TEXTURE;
        }

        public final void setFluidFromPacket(@NotNull Minecraft client, int syncId, @NotNull FluidVolume fluid) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            Screen screen = client.f_91080_;
            if (screen instanceof MenuAccess) {
                AbstractContainerMenu menu = ((MenuAccess)screen).m_6262_();
                if (menu.f_38840_ == syncId && menu instanceof BrewerMenu) {
                    ((BrewerMenu)menu).setFluid(fluid);
                }
            }
        }

        private final void drawSprite(GuiGraphics context2, int x, float y, float width, float height, float u0, float v0, float u1, float v1, TextureAtlasSprite sprite, int color) {
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172814_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.m_247685_());
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            Matrix4f positionMatrix = context2.m_280168_().m_85850_().m_252922_();
            float au0 = Mth.m_14179_((float)u0, (float)sprite.m_118409_(), (float)sprite.m_118410_());
            float au1 = Mth.m_14179_((float)u1, (float)sprite.m_118409_(), (float)sprite.m_118410_());
            float av0 = Mth.m_14179_((float)v0, (float)sprite.m_118411_(), (float)sprite.m_118412_());
            float av1 = Mth.m_14179_((float)v1, (float)sprite.m_118411_(), (float)sprite.m_118412_());
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            buffer.m_252986_(positionMatrix, (float)x, y + height, 0.0f).m_193479_(color).m_7421_(au0, av1).m_5752_();
            buffer.m_252986_(positionMatrix, (float)x + width, y + height, 0.0f).m_193479_(color).m_7421_(au1, av1).m_5752_();
            buffer.m_252986_(positionMatrix, (float)x + width, y, 0.0f).m_193479_(color).m_7421_(au1, av0).m_5752_();
            buffer.m_252986_(positionMatrix, (float)x, y, 0.0f).m_193479_(color).m_7421_(au0, av0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
            RenderSystem.disableBlend();
        }

        public final void drawFluid(@NotNull GuiGraphics context2, int x, int y, @NotNull FluidReference fluid) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
            if (fluid.isEmpty()) {
                return;
            }
            FluidRenderingBridge bridge = FluidRenderingBridge.Companion.get();
            TextureAtlasSprite textureAtlasSprite = bridge.getStillSprite(fluid);
            if (textureAtlasSprite == null) {
                Companion $this$drawFluid_u24lambda_u240 = this;
                boolean bl = false;
                LOGGER.warn("Could not find sprite for {} in brewer screen", (Object)fluid);
                return;
            }
            TextureAtlasSprite sprite = textureAtlasSprite;
            int color = ColorsKt.color$default(FluidRenderingBridge.getColor$default(bridge, fluid, null, null, 6, null), 0, 2, null);
            float height = (float)59 * ((float)fluid.getAmount() / (float)((long)2 * fluid.getUnit().getBucketVolume()));
            Ref.IntRef fluidY = new Ref.IntRef();
            int n = Mth.m_14143_((float)(height / (float)16));
            for (int i = 0; i < n; ++i) {
                this.drawSprite(context2, x, (float)y + juuxel.adorn.client.gui.screen.BrewerScreen$Companion.drawFluid$transformY(bridge, fluid, fluidY, 16.0f), 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, sprite, color);
                fluidY.element += 16;
            }
            float leftover = height % (float)16;
            this.drawSprite(context2, x, (float)y + juuxel.adorn.client.gui.screen.BrewerScreen$Companion.drawFluid$transformY(bridge, fluid, fluidY, leftover), 16.0f, leftover, 0.0f, 0.0f, 1.0f, leftover / 16.0f, sprite, color);
        }

        private static final float drawFluid$transformY(FluidRenderingBridge bridge, FluidReference $fluid, Ref.IntRef fluidY, float areaHeight) {
            return bridge.fillsFromTop($fluid) ? (float)fluidY.element : (float)(59 - fluidY.element) - areaHeight;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

