/*
 * Decompiled with CFR 0.152.
 */
package net.qualityequipment.configuration;

import java.util.List;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class ReforgesConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<String> FALLBACK_MATERIAL;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> MATERIAL_OVERRIDES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> REFORGE_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<Boolean> AUTO_REFORGE;
    public static final ForgeConfigSpec.ConfigValue<Double> AUTO_REFORGE_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> QUALITIES;

    static {
        BUILDER.push("Materials");
        FALLBACK_MATERIAL = BUILDER.comment("This material will be used to reforge an item that does not have a material override or repair item").define("Fallback", (Object)ForgeRegistries.ITEMS.getKey((Object)Blocks.f_50080_.m_5456_()).toString());
        MATERIAL_OVERRIDES = BUILDER.comment("In this list you can define different reforge items for specific equipment.\nThis can override repair items and will be used instead of the fallback item in case no repair item exists.\nThe left item is the equipment and right is the material.").defineList("Overrides", List.of("minecraft:bow,minecraft:string", "minecraft:crossbow,minecraft:iron_ingot"), entry -> true);
        BUILDER.pop();
        BUILDER.push("Reforging");
        REFORGE_BLACKLIST = BUILDER.comment("A list of equipment that cannot be reforged.").defineList("Blacklist", List.of(), entry -> true);
        AUTO_REFORGE = BUILDER.comment("If true, items have a chance to be automatically reforged when they enter the player's inventory.").define("AutoReforge", true);
        AUTO_REFORGE_CHANCE = BUILDER.comment("The chance an item has of being automatically reforged.\nMax is 1.0 (100%) and minimum is 0.1 (10%).").define("AutoReforgeChance", (Object)0.5);
        BUILDER.pop();
        BUILDER.push("Qualities");
        QUALITIES = BUILDER.comment("A list of json objects assigned to a translation key.\nEach json object represents a quality.\nNew qualities can be freely added so long as their format is valid.").defineList("QualityList", List.of("quality_equipment.quality.worthless={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":-0.1},{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":-0.1},{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":-0.1},{\"uuid\":\"bdb8f2c3-dd0a-44cb-b82e-cbcbbea0171d\",\"attribute\":\"forge:entity_reach\",\"operation\":\"addition\",\"value\":-1}]}", "quality_equipment.quality.broken={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":-0.15}]}", "quality_equipment.quality.chipped={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":-0.05},{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":-0.05}]}", "quality_equipment.quality.bulky={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":-0.15},{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":-0.15}]}", "quality_equipment.quality.rusted={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":-0.1},{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":-0.1}]}", "quality_equipment.quality.clumsy={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":-0.05},{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":-0.05}]}", "quality_equipment.quality.clumsy={\"type\":\"bow\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:projectile_damage\",\"operation\":\"multiply_base\",\"value\":-0.05}]}", "quality_equipment.quality.short={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"bdb8f2c3-dd0a-44cb-b82e-cbcbbea0171d\",\"attribute\":\"forge:entity_reach\",\"operation\":\"addition\",\"value\":-1}]}", "quality_equipment.quality.broad={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":-0.05},{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":-0.05},{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":0.1}]}", "quality_equipment.quality.thin={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":0.1},{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":-0.05}]}", "quality_equipment.quality.vicious={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":0.15},{\"uuid\":\"bdb8f2c3-dd0a-44cb-b82e-cbcbbea0171d\",\"attribute\":\"forge:entity_reach\",\"operation\":\"addition\",\"value\":-0.5}]}", "quality_equipment.quality.long={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"bdb8f2c3-dd0a-44cb-b82e-cbcbbea0171d\",\"attribute\":\"forge:entity_reach\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.sharp={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":0.1}]}", "quality_equipment.quality.keen={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":0.1},{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":0.1}]}", "quality_equipment.quality.graceful={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":0.15},{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":0.15}]}", "quality_equipment.quality.sweeping={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":0.2},{\"uuid\":\"bdb8f2c3-dd0a-44cb-b82e-cbcbbea0171d\",\"attribute\":\"forge:entity_reach\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.legendary={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":0.1},{\"uuid\":\"3d9461b2-3aed-4732-8760-4ebc2ea56a05\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":0.1},{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":0.15},{\"uuid\":\"bdb8f2c3-dd0a-44cb-b82e-cbcbbea0171d\",\"attribute\":\"forge:entity_reach\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.legendary={\"type\":\"bow\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:projectile_damage\",\"operation\":\"multiply_base\",\"value\":0.15}]}", "quality_equipment.quality.pokey={\"type\":\"tool\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":-0.1},{\"uuid\":\"c1127ef0-9c11-48e0-98da-faa1fcc010b3\",\"attribute\":\"minecraft:generic.attack_damage\",\"operation\":\"multiply_total\",\"value\":0.05}]}", "quality_equipment.quality.cracked={\"type\":\"bow\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:projectile_damage\",\"operation\":\"multiply_base\",\"value\":-0.15}]}", "quality_equipment.quality.light={\"type\":\"bow\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:projectile_damage\",\"operation\":\"multiply_base\",\"value\":0.05}]}", "quality_equipment.quality.powerful={\"type\":\"bow\",\"modifiers\":[{\"uuid\":\"5e86f314-00dd-4b50-97dd-7cc5d2fdd360\",\"attribute\":\"quality_equipment:projectile_damage\",\"operation\":\"multiply_base\",\"value\":0.1}]}", "quality_equipment.quality.crumbling={\"type\":\"armor\",\"modifiers\":[{\"uuid\":\"9add5032-c788-4fbb-bce4-e638fb094235\",\"attribute\":\"minecraft:generic.armor_toughness\",\"operation\":\"addition\",\"value\":-1},{\"uuid\":\"28446339-ec31-4bce-b795-f144c874d710\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":-1.5}]}", "quality_equipment.quality.dented={\"type\":\"armor\",\"modifiers\":[{\"uuid\":\"70e661f6-90c8-4380-8df7-b6333915cb88\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":-1}]}", "quality_equipment.quality.heavy={\"type\":\"armor\",\"modifiers\":[{\"uuid\":\"2c08261e-6312-4e42-9ea2-4dff1ea7b17b\",\"attribute\":\"minecraft:generic.movement_speed\",\"operation\":\"multiply_total\",\"value\":-0.1}]}", "quality_equipment.quality.heavy={\"type\":\"shield\",\"modifiers\":[{\"uuid\":\"0049b49e-6e53-4eae-a633-fd3bcad788cc\",\"attribute\":\"minecraft:generic.movement_speed\",\"operation\":\"multiply_total\",\"value\":-0.1}]}", "quality_equipment.quality.thick={\"type\":\"armor\",\"modifiers\":[{\"uuid\":\"b0375af6-84a2-4a96-992c-653618fbefcc\",\"attribute\":\"minecraft:generic.movement_speed\",\"operation\":\"multiply_total\",\"value\":-0.05},{\"uuid\":\"5171aff0-6979-427b-993c-33bbff0329e7\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.thick={\"type\":\"shield\",\"modifiers\":[{\"uuid\":\"975a56f6-1ee7-4838-a617-1e450a61ba68\",\"attribute\":\"minecraft:generic.movement_speed\",\"operation\":\"multiply_total\",\"value\":-0.05},{\"uuid\":\"9a7e26ed-55fe-4311-b4f1-3d0a0ff193a4\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.lucky={\"type\":\"helmet\",\"modifiers\":[{\"uuid\":\"95417373-5e52-4142-9a6e-0c8edc8759a8\",\"attribute\":\"minecraft:generic.luck\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.tall={\"type\":\"boots\",\"modifiers\":[{\"uuid\":\"24ec67ee-956c-4d5e-bb17-45d6bd8e5555\",\"attribute\":\"forge:step_height_addition\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.speedy={\"type\":\"boots\",\"modifiers\":[{\"uuid\":\"ba77d08c-e81e-40e7-b007-613c535213d2\",\"attribute\":\"minecraft:generic.movement_speed\",\"operation\":\"multiply_total\",\"value\":0.1}]}", "quality_equipment.quality.tough={\"type\":\"armor\",\"modifiers\":[{\"uuid\":\"90d7b3f3-28ea-411e-8d1c-400dfeeb778f\",\"attribute\":\"minecraft:generic.armor_toughness\",\"operation\":\"addition\",\"value\":1}]}", "quality_equipment.quality.protective={\"type\":\"armor\",\"modifiers\":[{\"uuid\":\"bea95b5f-5dd0-4f45-af5d-129a49366913\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.solid={\"type\":\"chestplate\",\"modifiers\":[{\"uuid\":\"bd3b540e-e6fe-415b-95f9-a37c5852cb03\",\"attribute\":\"minecraft:generic.knockback_resistance\",\"operation\":\"addition\",\"value\":0.05}]}", "quality_equipment.quality.solid={\"type\":\"shield\",\"modifiers\":[{\"uuid\":\"70cc1477-f0ad-4daa-a152-fd2b338090e0\",\"attribute\":\"minecraft:generic.knockback_resistance\",\"operation\":\"addition\",\"value\":0.05}]}", "quality_equipment.quality.cumbersome={\"type\":\"armor\",\"modifiers\":[{\"uuid\":\"eb7db392-19b7-48d8-9368-e4acb7be31b3\",\"attribute\":\"quality_equipment:dig_speed\",\"operation\":\"multiply_base\",\"value\":-0.1},{\"uuid\":\"4c019447-9eb4-4c0b-b53e-086b538a0f2f\",\"attribute\":\"minecraft:generic.attack_speed\",\"operation\":\"multiply_total\",\"value\":-0.1}]}", "quality_equipment.quality.springy={\"type\":\"leggings\",\"modifiers\":[{\"uuid\":\"4e82a48e-00d0-45f4-997d-b2fb6b1fc50d\",\"attribute\":\"quality_equipment:jump_height\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.masterful={\"type\":\"helmet\",\"modifiers\":[{\"uuid\":\"3170bc58-2345-4fd9-8b13-d906c3bee618\",\"attribute\":\"minecraft:generic.armor_toughness\",\"operation\":\"addition\",\"value\":1},{\"uuid\":\"c3658dee-0a44-4ca7-af0d-e5dd5a9fa87f\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":0.5},{\"uuid\":\"edaa6d4d-53dc-4ad4-80ea-e751073dae03\",\"attribute\":\"minecraft:generic.luck\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.masterful={\"type\":\"chestplate\",\"modifiers\":[{\"uuid\":\"42229752-518c-4b38-bde1-22f0eb7d4434\",\"attribute\":\"minecraft:generic.armor_toughness\",\"operation\":\"addition\",\"value\":1},{\"uuid\":\"f95138e0-a461-4a2b-946b-61e3289a03b0\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":0.5},{\"uuid\":\"7ba15d13-bf9c-4094-bd5a-7871da5e13f2\",\"attribute\":\"minecraft:generic.knockback_resistance\",\"operation\":\"addition\",\"value\":0.05}]}", "quality_equipment.quality.masterful={\"type\":\"leggings\",\"modifiers\":[{\"uuid\":\"324b3f24-a835-40c8-921d-012f4eefbfb7\",\"attribute\":\"minecraft:generic.armor_toughness\",\"operation\":\"addition\",\"value\":1},{\"uuid\":\"4ee5c96c-7ae2-413d-86e4-6e165141afef\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":0.5},{\"uuid\":\"ee9b1e45-51e9-4223-a957-e13af274d140\",\"attribute\":\"quality_equipment:jump_height\",\"operation\":\"addition\",\"value\":0.5}]}", "quality_equipment.quality.masterful={\"type\":\"boots\",\"modifiers\":[{\"uuid\":\"d176200e-de51-4823-b03d-6aa640b134c8\",\"attribute\":\"minecraft:generic.armor_toughness\",\"operation\":\"addition\",\"value\":1},{\"uuid\":\"4235cf80-9ad7-49ec-bf6a-0aced23d8256\",\"attribute\":\"minecraft:generic.armor\",\"operation\":\"addition\",\"value\":0.5},{\"uuid\":\"73ba4bc1-f87f-4951-a02a-3aa8cbfd3bc7\",\"attribute\":\"forge:step_height_addition\",\"operation\":\"addition\",\"value\":0.5},{\"uuid\":\"1851ae66-ec1c-406c-8499-8177c9950d84\",\"attribute\":\"minecraft:generic.movement_speed\",\"operation\":\"multiply_total\",\"value\":0.1}]}"), entry -> true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

