/*
 * Decompiled with CFR 0.152.
 */
package net.mathimomos.wormhole_artifact.server.message;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mathimomos.wormhole_artifact.WormholeArtifact;
import net.mathimomos.wormhole_artifact.server.item.ModItems;
import net.mathimomos.wormhole_artifact.server.message.PlayerData;
import net.mathimomos.wormhole_artifact.server.message.PlayerListResponseMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PlayerListRequestMessage {
    public static void write(PlayerListRequestMessage message, FriendlyByteBuf buffer) {
    }

    public static PlayerListRequestMessage read(FriendlyByteBuf buffer) {
        return new PlayerListRequestMessage();
    }

    public static void handle(PlayerListRequestMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Level pLevel = context.getSender().m_9236_();
            ServerPlayer serverPlayer = context.getSender();
            List<PlayerData> playerDataList = pLevel.m_7654_().m_6846_().m_11314_().stream().filter(player -> PlayerListRequestMessage.hasWormholeArtifactsInInventory((Player)player)).filter(player -> !player.m_7755_().getString().equals(serverPlayer.m_7755_().getString())).filter(player -> player.m_6084_()).filter(player -> PlayerListRequestMessage.notMultidimension((Player)serverPlayer) ? player.m_9236_() == serverPlayer.m_9236_() : true).map(player -> {
                String name = player.m_7755_().getString();
                String dimension = player.m_9236_().m_46472_().m_135782_().toString();
                int distance = player.m_9236_() == serverPlayer.m_9236_() ? (int)Math.sqrt(serverPlayer.m_20280_((Entity)player)) : -1;
                return new PlayerData(name, dimension, distance);
            }).collect(Collectors.toList());
            WormholeArtifact.NETWORK_WRAPPER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerListResponseMessage(playerDataList));
        });
        context.setPacketHandled(true);
    }

    private static boolean hasWormholeArtifactsInInventory(Player pPlayer) {
        for (ItemStack stack : pPlayer.m_150109_().f_35974_) {
            if (stack.m_41720_() != ModItems.WORMHOLE_ARTIFACT.get() && stack.m_41720_() != ModItems.WORMHOLE_REMOTE.get()) continue;
            return true;
        }
        return false;
    }

    private static boolean notMultidimension(Player pPlayer) {
        ItemStack stackMain = pPlayer.m_21205_();
        ItemStack stackOff = pPlayer.m_21206_();
        Item wormholeArtifact = (Item)ModItems.WORMHOLE_ARTIFACT.get();
        return stackMain.m_41720_() == wormholeArtifact || stackOff.m_41720_() == wormholeArtifact;
    }
}

