/*
 * Decompiled with CFR 0.152.
 */
package net.mathimomos.wormhole_artifact.server.item.custom;

import net.mathimomos.wormhole_artifact.WormholeArtifact;
import net.mathimomos.wormhole_artifact.client.particle.ModParticles;
import net.mathimomos.wormhole_artifact.client.sound.ModSounds;
import net.mathimomos.wormhole_artifact.server.item.ModItems;
import net.mathimomos.wormhole_artifact.server.message.OpenWormholeArtifactScreenMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;

public class WormholeRemoteItem
extends Item {
    public WormholeRemoteItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack pStack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_ && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            OpenWormholeArtifactScreenMessage message = new OpenWormholeArtifactScreenMessage();
            WormholeArtifact.NETWORK_WRAPPER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)message);
        }
        return InteractionResultHolder.m_19092_((Object)pStack, (boolean)pLevel.m_5776_());
    }

    public boolean m_6832_(ItemStack stackToRepair, ItemStack repairMaterial) {
        return repairMaterial.m_41720_() == ModItems.ENDER_NACRE.get() || super.m_6832_(stackToRepair, repairMaterial);
    }

    public void teleportToTarget(ServerPlayer pPlayer, ServerPlayer pTargetPlayer, ItemStack pStack, Level pLevel) {
        if (pTargetPlayer != null && pTargetPlayer.m_6084_()) {
            ServerLevel targetLevel = (ServerLevel)pTargetPlayer.m_9236_();
            this.teleportEffect(pPlayer, pLevel);
            pStack.m_41622_(1, (LivingEntity)pPlayer, p -> p.m_21190_(p.m_7655_()));
            pPlayer.m_36335_().m_41524_((Item)this, (Integer)WormholeArtifact.COMMON_CONFIG.WORMHOLE_REMOTE_COOLDOWN.get() * 20);
            String pPlayerName = pPlayer.m_5446_().getString();
            String pTargetPlayerName = pTargetPlayer.m_5446_().getString();
            pLevel.m_6907_().forEach(player -> player.m_213846_((Component)Component.m_237110_((String)"text.wormhole_artifact.teleported", (Object[])new Object[]{pPlayerName, pTargetPlayerName}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW))));
            pPlayer.m_8999_(targetLevel, pTargetPlayer.m_20185_(), pTargetPlayer.m_20186_(), pTargetPlayer.m_20189_(), pTargetPlayer.m_146908_(), pTargetPlayer.m_146909_());
            this.teleportEffect(pTargetPlayer, (Level)targetLevel);
        }
    }

    public void teleportEffect(ServerPlayer pPlayer, Level pLevel) {
        if (pLevel instanceof ServerLevel) {
            double y;
            double z;
            double x;
            ServerLevel serverLevel = (ServerLevel)pLevel;
            double spacing = 0.75;
            for (int i = 0; i < 3; ++i) {
                x = pPlayer.m_20185_();
                z = pPlayer.m_20189_();
                y = pPlayer.m_20186_() + (double)i * spacing;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.TELEPORT_WAVE_PARTICLES.get()), x, y, z, 1, 0.0, 0.0, 0.0, (double)0.1f);
            }
            for (int j = 0; j < 30; ++j) {
                x = pPlayer.m_20185_();
                z = pPlayer.m_20189_();
                y = pPlayer.m_20186_();
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.TELEPORT_PARTICLES.get()), x, y, z, 1, 0.5, 0.5, 0.5, 1.0);
            }
            serverLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)ModSounds.TELEPORT_SFX.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)WormholeArtifact.COMMON_CONFIG.WORMHOLE_REMOTE_MAX_DURABILITY.get();
    }

    public void setDamage(ItemStack stack, int damage) {
        int maxDamage = this.getMaxDamage(stack);
        if (damage >= maxDamage) {
            damage = maxDamage - 1;
        }
        super.setDamage(stack, damage);
    }
}

