/*
 * Decompiled with CFR 0.152.
 */
package net.mathimomos.wormhole_artifact.client.screen;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import net.mathimomos.wormhole_artifact.WormholeArtifact;
import net.mathimomos.wormhole_artifact.client.screen.WormholeArtifactButton;
import net.mathimomos.wormhole_artifact.server.message.PlayerData;
import net.mathimomos.wormhole_artifact.server.message.PlayerListRequestMessage;
import net.mathimomos.wormhole_artifact.server.message.TeleportToTargetMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WormholeArtifactScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("wormhole_artifact", "textures/gui/wormhole_artifact_gui.png");
    private static final int GUI_WIDTH = 184;
    private static final int GUI_HEIGHT = 216;
    private static final int BUTTONS_PER_PAGE = 6;
    private static final int BUTTON_WIDTH = 160;
    private static final int BUTTON_HEIGHT = 30;
    private static final int BUTTON_GAP = 32;
    private List<PlayerData> playerDataList = new ArrayList<PlayerData>();
    private int tickCount = 20;
    private int scrollIndex = 0;
    private int centerX;
    private int centerY;
    private int startX;
    private int startY;

    public WormholeArtifactScreen() {
        super((Component)Component.m_237115_((String)"item.wormhole_artifact.wormhole_artifact_screen"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.centerX = (this.f_96543_ - 184) / 2;
        this.centerY = (this.f_96544_ - 216) / 2;
        this.startX = this.centerX + 12;
        this.startY = this.centerY + 20;
        WormholeArtifact.NETWORK_WRAPPER.sendToServer((Object)new PlayerListRequestMessage());
        this.updateButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.tickCount;
        if (this.tickCount >= 20) {
            this.tickCount = 0;
            WormholeArtifact.NETWORK_WRAPPER.sendToServer((Object)new PlayerListRequestMessage());
        }
    }

    public void updatePlayerData(List<PlayerData> newPlayerDataList) {
        this.playerDataList = newPlayerDataList;
        this.updateButtons();
    }

    private void updateButtons() {
        this.m_169413_();
        for (int i = this.scrollIndex; i < Math.min(this.scrollIndex + 6, this.playerDataList.size()); ++i) {
            PlayerData playerData = this.playerDataList.get(i);
            int buttonY = this.startY + (i - this.scrollIndex) * 32;
            String playerName = playerData.getPlayerName();
            String playerDimension = playerData.getPlayerDimension();
            String playerDistance = Integer.toString(playerData.getPlayerDistance());
            this.m_142416_((GuiEventListener)new WormholeArtifactButton(this.startX, buttonY, 160, 30, playerName, playerDimension, playerDistance, button -> this.onPlayerSelected(playerData)));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        graphics.m_280163_(GUI_TEXTURE, this.centerX, this.centerY, 0.0f, 0.0f, 184, 216, 184, 216);
        int titleX = this.centerX + (184 - this.f_96547_.m_92895_(this.f_96539_.getString())) / 2;
        graphics.m_280056_(this.f_96547_, this.f_96539_.getString(), titleX, this.centerY + 6, 0x3F3F3F, false);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        Minecraft.m_91087_();
        for (int i = this.scrollIndex; i < Math.min(this.scrollIndex + 6, this.playerDataList.size()); ++i) {
            PlayerData playerData = this.playerDataList.get(i);
            int buttonY = this.startY + (i - this.scrollIndex) * 32;
            int headX = this.startX + 7;
            int headY = buttonY + 7;
            PlayerInfo playerInfo = this.f_96541_.m_91403_().m_104938_(playerData.getPlayerName());
            if (playerInfo == null) continue;
            GameProfile profile = playerInfo.m_105312_();
            ResourceLocation skin = this.f_96541_.m_91109_().m_240306_(profile);
            graphics.m_280411_(skin, headX, headY, 16, 16, 8.0f, 8.0f, 8, 8, 64, 64);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta > 0.0 && this.scrollIndex > 0) {
            --this.scrollIndex;
        } else if (delta < 0.0 && this.scrollIndex + 6 < this.playerDataList.size()) {
            ++this.scrollIndex;
        }
        this.updateButtons();
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void onPlayerSelected(PlayerData targetPlayerData) {
        WormholeArtifact.NETWORK_WRAPPER.sendToServer((Object)new TeleportToTargetMessage(targetPlayerData.getPlayerName()));
        this.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }
}

