/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Llama;
import net.satisfy.vinery.entity.TraderMuleEntity;
import net.satisfy.vinery.entity.WanderingWinemakerEntity;
import net.satisfy.vinery.util.VineryIdentifier;

public class EntityRegistry {
    private static final Registrar<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.f_256939_).getRegistrar();
    public static final RegistrySupplier<EntityType<TraderMuleEntity>> MULE = EntityRegistry.create("mule", () -> EntityType.Builder.m_20704_(TraderMuleEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.87f).m_20702_(10).m_20712_(new VineryIdentifier("mule").toString()));
    public static final RegistrySupplier<EntityType<WanderingWinemakerEntity>> WANDERING_WINEMAKER = EntityRegistry.create("wandering_winemaker", () -> EntityType.Builder.m_20704_(WanderingWinemakerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f).m_20702_(10).m_20712_(new VineryIdentifier("wandering_winemaker").toString()));

    public static <T extends EntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new VineryIdentifier(path), type);
    }

    public static void init() {
        EntityAttributeRegistry.register(MULE, () -> Llama.m_30824_().m_22268_(Attributes.f_22279_, (double)0.2f));
        EntityAttributeRegistry.register(WANDERING_WINEMAKER, Mob::m_21552_);
    }
}

