/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.block.storage;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.common.block.StorageBlock;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import de.cristelknight.doapi.common.util.GeneralUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.item.DrinkBlockItem;
import net.satisfy.vinery.registry.StorageTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class WineBottleBlock
extends StorageBlock {
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    public static final BooleanProperty FAKE_MODEL = BooleanProperty.m_61465_((String)"fake_model");
    private final int maxCount;

    public WineBottleBlock(BlockBehaviour.Properties settings, int maxCount) {
        super(settings);
        this.maxCount = maxCount;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FAKE_MODEL, (Comparable)Boolean.valueOf(true)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity wineEntity = (StorageBlockEntity)blockEntity;
            NonNullList inventory = wineEntity.getInventory();
            if (this.canInsertStack(stack) && this.willFitStack(stack, (NonNullList<ItemStack>)inventory)) {
                int posInE = this.getFirstEmptySlot((NonNullList<ItemStack>)inventory);
                if (posInE == Integer.MIN_VALUE) {
                    return InteractionResult.PASS;
                }
                if (!world.m_5776_()) {
                    wineEntity.setStack(posInE, stack.m_41620_(1));
                    if (player.m_7500_()) {
                        stack.m_41769_(1);
                    }
                    world.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (stack.m_41619_() && !this.isEmpty((NonNullList<ItemStack>)inventory)) {
                int posInE = this.getLastFullSlot((NonNullList<ItemStack>)inventory);
                if (posInE == Integer.MIN_VALUE) {
                    return InteractionResult.PASS;
                }
                if (!world.m_5776_()) {
                    ItemStack wine = wineEntity.removeStack(posInE);
                    if (!player.m_150109_().m_36054_(wine)) {
                        player.m_36176_(wine, false);
                    }
                    if (this.isEmpty((NonNullList<ItemStack>)inventory)) {
                        world.m_46961_(pos, false);
                    }
                    world.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isEmpty(NonNullList<ItemStack> inventory) {
        for (ItemStack stack : inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int getFirstEmptySlot(NonNullList<ItemStack> inventory) {
        for (ItemStack stack : inventory) {
            if (!stack.m_41619_()) continue;
            return inventory.indexOf((Object)stack);
        }
        return Integer.MIN_VALUE;
    }

    public int getLastFullSlot(NonNullList<ItemStack> inventory) {
        for (int i = inventory.size() - 1; i >= 0; --i) {
            if (((ItemStack)inventory.get(i)).m_41619_()) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FAKE_MODEL});
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return GeneralUtil.isSolid((LevelReader)levelReader, (BlockPos)blockPos);
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN && !blockState.m_60710_((LevelReader)levelAccessor, blockPos)) {
            levelAccessor.m_46961_(blockPos, true);
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public int size() {
        return this.maxCount;
    }

    public ResourceLocation type() {
        return StorageTypeRegistry.WINE_BOTTLE;
    }

    public boolean canInsertStack(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof DrinkBlockItem;
    }

    public boolean willFitStack(ItemStack itemStack, NonNullList<ItemStack> inventory) {
        Pair<Integer, Integer> p = WineBottleBlock.getFilledAmountAndBiggest(inventory);
        int biggest = (Integer)p.getSecond();
        int count = (Integer)p.getFirst();
        int stackCount = WineBottleBlock.getCount(itemStack);
        if (biggest == Integer.MAX_VALUE) {
            return true;
        }
        return stackCount > count && count < biggest;
    }

    public static Pair<Integer, Integer> getFilledAmountAndBiggest(NonNullList<ItemStack> inventory) {
        int count = 0;
        int biggest = Integer.MAX_VALUE;
        for (ItemStack stack : inventory) {
            DrinkBlockItem item;
            if (stack.m_41619_()) continue;
            ++count;
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof DrinkBlockItem) || !((item2 = (item = (DrinkBlockItem)item2).m_40614_()) instanceof WineBottleBlock)) continue;
            WineBottleBlock wine = (WineBottleBlock)item2;
            if (wine.maxCount >= biggest) continue;
            biggest = wine.maxCount;
        }
        return new Pair((Object)count, (Object)biggest);
    }

    public static int getCount(ItemStack itemStack) {
        DrinkBlockItem item;
        Item item2 = itemStack.m_41720_();
        if (item2 instanceof DrinkBlockItem && (item2 = (item = (DrinkBlockItem)item2).m_40614_()) instanceof WineBottleBlock) {
            WineBottleBlock wine = (WineBottleBlock)item2;
            return wine.maxCount;
        }
        return Integer.MIN_VALUE;
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public int getSection(Float aFloat, Float aFloat1) {
        return 0;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[0];
    }
}

